/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.Release;
import com.gitee.jenkins.gitee.api.model.builder.generated.ReleaseBuilder;
import com.gitee.jenkins.publisher.Messages;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.VirtualFile;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GiteeReleasePublisher
extends Notifier
implements MatrixAggregatable {
    private String owner;
    private String repo;
    private String tagName;
    private String name;
    private String body;
    private String targetCommit;
    private boolean prerelease;
    private boolean artifacts;
    private boolean increment;

    @DataBoundConstructor
    public GiteeReleasePublisher() {
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public String getTargetCommit() {
        return this.targetCommit;
    }

    public boolean isArtifacts() {
        return this.artifacts;
    }

    public boolean isIncrement() {
        return this.increment;
    }

    @DataBoundSetter
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @DataBoundSetter
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setPrerelease(boolean prerelease) {
        this.prerelease = prerelease;
    }

    @DataBoundSetter
    public void setArtifacts(boolean artifacts) {
        this.artifacts = artifacts;
    }

    @DataBoundSetter
    public void setTargetCommit(String targetCommit) {
        this.targetCommit = targetCommit;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    @DataBoundSetter
    public void setIncrement(boolean increment) {
        this.increment = increment;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                GiteeReleasePublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    private String createIncrementVersionString(GiteeClient client) {
        Pattern incrementRegex = Pattern.compile("(=+|0+|\\++)");
        Matcher incrementMatcher = incrementRegex.matcher(this.tagName);
        Release latestRelease = client.getLatestRelease(this.owner, this.repo);
        String latestTag = latestRelease.getTagName();
        Pattern regex = Pattern.compile("(\\d+)");
        Matcher latestMatcher = regex.matcher(latestTag);
        ArrayList<Object> newVersion = new ArrayList<Object>();
        while (latestMatcher.find() && incrementMatcher.find()) {
            if (incrementMatcher.group().equals("+")) {
                int versionNumberString = Integer.parseInt(latestMatcher.group()) + 1;
                newVersion.add("" + versionNumberString);
                continue;
            }
            if (incrementMatcher.group().equals("=")) {
                newVersion.add(latestMatcher.group());
                continue;
            }
            if (!incrementMatcher.group().equals("0")) continue;
            newVersion.add("0");
        }
        if (!latestMatcher.find() && !incrementMatcher.find()) {
            return String.join((CharSequence)".", newVersion);
        }
        return null;
    }

    private void attachFileArtifacts(Integer releaseId, GiteeClient client, AbstractBuild<?, ?> build) {
        ArtifactArchiver archiver = (ArtifactArchiver)build.getProject().getPublishersList().get(ArtifactArchiver.class);
        for (Run.Artifact artifact : build.getArtifacts()) {
            VirtualFile file = build.getArtifactManager().root().child(artifact.toString());
            if (archiver.getExcludes() != null && archiver.getExcludes().contains(file.getName())) continue;
            client.attachFileToRelease(this.owner, this.repo, releaseId, artifact.getFileName(), file);
        }
    }

    private String getCommitHash(AbstractBuild<?, ?> build) {
        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)build.getProject());
        String commitHash = null;
        for (SCM scm : item.getSCMs()) {
            GitSCM gitSCM;
            BuildData data;
            if (!(scm instanceof GitSCM) || (data = (gitSCM = (GitSCM)scm).getBuildData(build)) == null || data.getLastBuiltRevision() == null) continue;
            commitHash = data.getLastBuiltRevision().getSha1String();
        }
        return commitHash;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        GiteeClient client = GiteeConnectionProperty.getClient(build);
        String incrementedTagName = null;
        String commitHash = this.getCommitHash(build);
        if (commitHash == null) {
            launcher.getListener().getLogger().print("Failed to find commit hash. Check that first repository is configured and is Gitee repo.");
            return false;
        }
        if (this.increment && (incrementedTagName = this.createIncrementVersionString(client)) == null) {
            launcher.getListener().getLogger().print("Failed to increment. Check version string format.");
            return false;
        }
        Release release = new ReleaseBuilder().withTagName(this.increment ? incrementedTagName : this.tagName).withName(this.name).withBody(this.body).withPrerelease(this.prerelease).withTargetCommitish(commitHash).build();
        Release releaseResponse = client.createRelease(this.owner, this.repo, release);
        if (this.artifacts) {
            this.attachFileArtifacts(releaseResponse.getId(), client, build);
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GiteeReleasePublisher_DisplayName();
        }
    }
}

