/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.api.impl;

import com.gitee.jenkins.gitee.api.impl.GiteeApiProxy;
import com.gitee.jenkins.gitee.api.model.Label;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.api.model.Release;
import com.gitee.jenkins.gitee.api.model.User;
import com.gitee.jenkins.gitee.api.model.WebHook;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;

@Path(value="/api/v5")
interface GiteeV5ApiProxy
extends GiteeApiProxy {
    public static final String ID = "v5";

    @Override
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/repos/{ownerPath}/{repoPath}/pulls/{prNumber}/merge")
    public void acceptPullRequest(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @PathParam(value="prNumber") Integer var3);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/repos/{ownerPath}/{repoPath}/pulls/{prNumber}/comments")
    public void createPullRequestNote(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @PathParam(value="prNumber") Integer var3, @FormParam(value="body") String var4);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/repos/{ownerPath}/{repoPath}/pulls")
    public void createPullRequest(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @FormParam(value="title") String var3, @FormParam(value="base") String var4, @FormParam(value="head") String var5, @FormParam(value="body") String var6, @FormParam(value="prune_source_branch") Boolean var7, @FormParam(value="draft") Boolean var8, @FormParam(value="squash") Boolean var9);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/repos/{ownerPath}/{repoPath}/pulls")
    public List<PullRequest> getPullRequest(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @QueryParam(value="base") String var3, @QueryParam(value="head") String var4);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/repos/{ownerPath}/{repoPath}/hooks")
    public WebHook createWebHook(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @FormParam(value="url") String var3, @FormParam(value="title") String var4, @FormParam(value="encryption_type") Integer var5, @FormParam(value="push_events") Boolean var6, @FormParam(value="tag_push_events") Boolean var7, @FormParam(value="issues_events") Boolean var8, @FormParam(value="note_events") Boolean var9, @FormParam(value="merge_requests_events") Boolean var10);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/repos/{ownerPath}/{repoPath}/hooks")
    public List<WebHook> getWebHooks(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2);

    @Override
    @HEAD
    @Produces(value={"application/json"})
    @Path(value="/user")
    public void headCurrentUser();

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/user")
    public User getCurrentUser();

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/repos/{ownerPath}/{repoPath}/labels")
    public List<Label> getLabels(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/repos/{ownerPath}/{repoPath}/releases/latest")
    public Release getLatestRelease(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Path(value="/repos/{ownerPath}/{repoPath}/releases")
    public Release createRelease(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @FormParam(value="tag_name") String var3, @FormParam(value="name") String var4, @FormParam(value="body") String var5, @FormParam(value="prerelease") Boolean var6, @FormParam(value="target_commitish") String var7);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/repos/{ownerPath}/{repoPath}/releases/{releaseId}/attach_files")
    public void attachFileToRelease(@PathParam(value="ownerPath") String var1, @PathParam(value="repoPath") String var2, @PathParam(value="releaseId") Integer var3, MultipartFormDataOutput var4);
}

