/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.Release;
import com.gitee.jenkins.gitee.api.model.builder.generated.ReleaseBuilder;
import com.gitee.jenkins.publisher.Messages;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.VirtualFile;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GiteeReleasePublisher
extends Notifier
implements MatrixAggregatable {
    private String owner;
    private String repo;
    private String tagName;
    private String name;
    private String body;
    private String targetCommit;
    private boolean prerelease;
    private boolean artifacts;

    @DataBoundConstructor
    public GiteeReleasePublisher() {
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public String getTargetCommit() {
        return this.targetCommit;
    }

    public boolean isArtifacts() {
        return this.artifacts;
    }

    @DataBoundSetter
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @DataBoundSetter
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setPrerelease(boolean prerelease) {
        this.prerelease = prerelease;
    }

    @DataBoundSetter
    public void setArtifacts(boolean artifacts) {
        this.artifacts = artifacts;
    }

    @DataBoundSetter
    public void setTargetCommit(String targetCommit) {
        this.targetCommit = targetCommit;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                GiteeReleasePublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        GiteeClient client = GiteeConnectionProperty.getClient(build);
        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)build.getProject());
        String commitHash = null;
        for (SCM scm : item.getSCMs()) {
            GitSCM gitSCM;
            BuildData data;
            if (!(scm instanceof GitSCM) || (data = (gitSCM = (GitSCM)scm).getBuildData(build)) == null || data.getLastBuiltRevision() == null) continue;
            commitHash = data.getLastBuiltRevision().getSha1String();
        }
        Release release = new ReleaseBuilder().withTagName(this.tagName).withName(this.name).withBody(this.body).withPrerelease(this.prerelease).withTargetCommitish(commitHash).build();
        Release releaseResponse = client.createRelease(this.owner, this.repo, release);
        if (this.artifacts) {
            ArtifactArchiver archiver = (ArtifactArchiver)build.getProject().getPublishersList().get(ArtifactArchiver.class);
            for (Run.Artifact artifact : build.getArtifacts()) {
                VirtualFile file = build.getArtifactManager().root().child(artifact.toString());
                if (archiver.getExcludes() != null && archiver.getExcludes().contains(file.getName())) continue;
                client.attachFileToRelease(this.owner, this.repo, releaseResponse.getId(), artifact.getFileName(), file);
            }
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GiteeReleasePublisher_DisplayName();
        }
    }
}

