/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.connection;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.gitee.jenkins.connection.GiteeApiToken;
import com.gitee.jenkins.connection.GiteeApiTokenImpl;
import com.gitee.jenkins.connection.GiteeConnectionConfig;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.GiteeClientBuilder;
import com.gitee.jenkins.gitee.api.impl.GiteeV5ClientBuilder;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class GiteeConnection {
    private final String name;
    private final String url;
    private transient String apiToken;
    private String apiTokenId;
    private GiteeClientBuilder clientBuilder;
    private final boolean ignoreCertificateErrors;
    private final Integer connectionTimeout;
    private final Integer readTimeout;
    private transient GiteeClient apiCache;

    public GiteeConnection(String name, String url, String apiTokenId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, new GiteeV5ClientBuilder(), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @DataBoundConstructor
    public GiteeConnection(String name, String url, String apiTokenId, String clientBuilderId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, GiteeClientBuilder.getGiteeClientBuilderById(clientBuilderId), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @Restricted(value={NoExternalUse.class})
    public GiteeConnection(String name, String url, String apiTokenId, GiteeClientBuilder clientBuilder, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this.name = name;
        this.url = url;
        this.apiTokenId = apiTokenId;
        this.clientBuilder = clientBuilder;
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiTokenId() {
        return this.apiTokenId;
    }

    public String getClientBuilderId() {
        return this.clientBuilder.id();
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public GiteeClient getClient() {
        if (this.apiCache == null) {
            this.apiCache = this.clientBuilder.buildClient(this.url, this.getApiToken(this.apiTokenId), this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
        }
        return this.apiCache;
    }

    private String getApiToken(String apiTokenId) {
        StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardCredentials.class, null, (Authentication)ACL.SYSTEM2, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)apiTokenId));
        if (credentials != null) {
            if (credentials instanceof GiteeApiToken) {
                GiteeApiToken token = (GiteeApiToken)credentials;
                return token.getApiToken().getPlainText();
            }
            if (credentials instanceof StringCredentials) {
                StringCredentials stringCredentials = (StringCredentials)credentials;
                return stringCredentials.getSecret().getPlainText();
            }
        }
        throw new IllegalStateException("No credentials found for credentialsId: " + apiTokenId);
    }

    protected GiteeConnection readResolve() {
        if (this.connectionTimeout == null || this.readTimeout == null) {
            return new GiteeConnection(this.name, this.url, this.apiTokenId, new GiteeV5ClientBuilder(), this.ignoreCertificateErrors, (Integer)10, (Integer)10);
        }
        if (this.clientBuilder == null) {
            return new GiteeConnection(this.name, this.url, this.apiTokenId, new GiteeV5ClientBuilder(), this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
        }
        return this;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void migrate() throws IOException {
        GiteeConnectionConfig descriptor = (GiteeConnectionConfig)Jenkins.get().getDescriptor(GiteeConnectionConfig.class);
        for (GiteeConnection connection : descriptor.getConnections()) {
            if (connection.apiTokenId != null || connection.apiToken == null) continue;
            for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
                if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
                List domains = credentialsStore.getDomains();
                connection.apiTokenId = UUID.randomUUID().toString();
                credentialsStore.addCredentials((Domain)domains.get(0), (Credentials)new GiteeApiTokenImpl(CredentialsScope.SYSTEM, connection.apiTokenId, "Gitee API Token", Secret.fromString((String)connection.apiToken)));
            }
        }
        descriptor.save();
    }
}

