/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.api.impl;

import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.impl.GiteeApiProxy;
import com.gitee.jenkins.gitee.api.model.Label;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.api.model.Release;
import com.gitee.jenkins.gitee.api.model.User;
import com.gitee.jenkins.gitee.api.model.WebHook;
import com.google.common.base.Function;
import java.util.List;

final class ResteasyGiteeClient
implements GiteeClient {
    private final String hostUrl;
    private final GiteeApiProxy api;
    private final Function<PullRequest, Integer> pullRequestIdProvider;

    ResteasyGiteeClient(String hostUrl, GiteeApiProxy api, Function<PullRequest, Integer> pullRequestIdProvider) {
        this.hostUrl = hostUrl;
        this.api = api;
        this.pullRequestIdProvider = pullRequestIdProvider;
    }

    @Override
    public String getHostUrl() {
        return this.hostUrl;
    }

    @Override
    public void acceptPullRequest(PullRequest mr, String mergeCommitMessage, boolean shouldRemoveSourceBranch) {
        this.api.acceptPullRequest(mr.getRepoOwner(), mr.getRepoPath(), mr.getIid());
    }

    @Override
    public void createPullRequestNote(PullRequest mr, String body) {
        this.api.createPullRequestNote(mr.getRepoOwner(), mr.getRepoPath(), mr.getIid(), body);
    }

    @Override
    public void createPullRequest(PullRequest pr, boolean pruneSourceBranch, boolean isDraft, boolean isSquashMerge) {
        this.api.createPullRequest(pr.getRepoOwner(), pr.getRepoPath(), pr.getTitle(), pr.getTargetBranch(), pr.getSourceBranch(), pr.getDescription(), pruneSourceBranch, isDraft, isSquashMerge);
    }

    @Override
    public List<PullRequest> getPullRequest(PullRequest pr) {
        return this.api.getPullRequest(pr.getRepoOwner(), pr.getRepoPath(), pr.getTargetBranch(), pr.getSourceBranch());
    }

    @Override
    public User getCurrentUser() {
        return this.api.getCurrentUser();
    }

    @Override
    public List<Label> getLabels(String owner, String repo) {
        return this.api.getLabels(owner, repo);
    }

    @Override
    public WebHook createWebHook(String owner, String repo, WebHook hook) {
        return this.api.createWebHook(owner, repo, hook.getUrl(), hook.getTitle(), hook.getEncryptionType(), hook.getPushEvents(), hook.getTagPushEvents(), hook.getIssuesEvents(), hook.getNoteEvents(), hook.getMergeRequestsEvents());
    }

    @Override
    public List<WebHook> getWebHooks(String owner, String repo) {
        return this.api.getWebHooks(owner, repo);
    }

    @Override
    public Release createRelease(String owner, String repo, Release release) {
        return this.api.createRelease(owner, repo, release.getTagName(), release.getName(), release.getBody(), release.isPrerelease(), release.getTargetCommitish());
    }
}

