/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.build;

import com.gitee.jenkins.gitee.hook.model.Project;
import com.gitee.jenkins.gitee.hook.model.PullRequestHook;
import com.gitee.jenkins.gitee.hook.model.PullRequestObjectAttributes;
import com.gitee.jenkins.trigger.GiteePushTrigger;
import com.gitee.jenkins.util.JsonUtil;
import com.gitee.jenkins.webhook.build.LegacyBuildWebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HttpResponses;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;

public class LegacyPullRequestBuildAction
extends LegacyBuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(LegacyPullRequestBuildAction.class.getName());
    private Item project;
    private PullRequestHook pullRequestHook;
    private final String secretToken;

    public LegacyPullRequestBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "PullRequest: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pullRequestHook = JsonUtil.read(json, PullRequestHook.class);
        this.pullRequestHook.setJsonBody(json);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        PullRequestObjectAttributes attributes = this.pullRequestHook.getPullRequest();
        if (attributes != null) {
            Project source = attributes.getSource();
            if (source != null && source.getGitHttpUrl() != null) {
                if (source.getUrl() == null) {
                    source.setUrl(source.getGitHttpUrl());
                }
                if (source.getHomepage() == null) {
                    source.setHomepage(source.getGitHttpUrl().substring(0, source.getGitHttpUrl().lastIndexOf(".git")));
                }
            }
            if (this.pullRequestHook.getRepo() == null && attributes.getTarget() != null) {
                this.pullRequestHook.setRepo(attributes.getTarget());
            }
        }
    }

    @Override
    public void execute() {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Merge Request Hook is not supported for this project");
        }
        Authentication auth = Jenkins.getAuthentication2();
        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
            new LegacyBuildWebHookAction.TriggerNotifier(this.project, this.secretToken, auth){

                @Override
                protected void performOnPost(GiteePushTrigger trigger) {
                    trigger.onPost(LegacyPullRequestBuildAction.this.pullRequestHook);
                }
            }.run();
        }
        throw LegacyPullRequestBuildAction.responseWithHook(this.pullRequestHook);
    }
}

