/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.util;

import hudson.security.ACL;
import hudson.security.ACLContext;
import org.springframework.security.core.Authentication;

public class ACLUtil {
    public static <T> T impersonate(Authentication auth, Function<T> function) {
        try (ACLContext ignored = ACL.as2((Authentication)auth);){
            ObjectHolder<T> holder = new ObjectHolder<T>();
            holder.setValue(function.invoke());
            Object t = holder.getValue();
            return t;
        }
    }

    private static class ObjectHolder<T> {
        private T value;

        private ObjectHolder() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static interface Function<T> {
        public T invoke();
    }
}

