/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.api;

import com.gitee.jenkins.gitee.api.GiteeClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class GiteeClientBuilder
implements Comparable<GiteeClientBuilder>,
ExtensionPoint,
Serializable {
    private final String id;
    private final int ordinal;

    public static GiteeClientBuilder getGiteeClientBuilderById(String id) {
        id = "v5";
        for (GiteeClientBuilder provider : GiteeClientBuilder.getAllGiteeClientBuilders()) {
            if (!provider.id().equals(id)) continue;
            return provider;
        }
        throw new NoSuchElementException("unknown client-builder-id: " + id);
    }

    public static List<GiteeClientBuilder> getAllGiteeClientBuilders() {
        ArrayList<GiteeClientBuilder> builders = new ArrayList<GiteeClientBuilder>((Collection<GiteeClientBuilder>)Jenkins.get().getExtensionList(GiteeClientBuilder.class));
        Collections.sort(builders);
        return builders;
    }

    protected GiteeClientBuilder(String id, int ordinal) {
        this.id = id;
        this.ordinal = ordinal;
    }

    @NonNull
    public final String id() {
        return this.id;
    }

    @NonNull
    public abstract GiteeClient buildClient(String var1, String var2, boolean var3, int var4, int var5);

    @Override
    public final int compareTo(@NonNull GiteeClientBuilder other) {
        int o = this.ordinal - other.ordinal;
        return o != 0 ? o : this.id().compareTo(other.id());
    }
}

