/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import jakarta.annotation.Priority;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.util.Functions;

public class PriorityServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private final Object lock = new Object();
    private final Supplier<String> toString;
    private final Holder<S>[] holders;
    private final int size;

    private PriorityServiceLoader(Class<S> service, Holder<S>[] holders) {
        this.holders = holders;
        this.size = holders.length;
        this.toString = Functions.singleton(() -> "PriorityServiceLoader[type=" + service.getName() + ", implementations=" + String.valueOf(Stream.of(holders).map(holder -> holder.type.getName()).collect(Collectors.toList())) + "]");
    }

    public static <S> PriorityServiceLoader<S> load(Class<S> type) {
        return PriorityServiceLoader.load(type, PriorityServiceLoader.classLoader(type), null);
    }

    public static <S> PriorityServiceLoader<S> load(Class<S> type, Function<Class<? extends S>, S> constructor) {
        return PriorityServiceLoader.load(type, PriorityServiceLoader.classLoader(type), constructor);
    }

    public static <S> PriorityServiceLoader<S> load(Class<S> type, ClassLoader cl) {
        return PriorityServiceLoader.load(type, cl, null);
    }

    public static <S> PriorityServiceLoader<S> load(Class<S> type, ClassLoader cl, Function<Class<? extends S>, S> constructor) {
        try {
            Holder<? extends S>[] holders = PriorityServiceLoader.findClasses(type, cl, constructor);
            return new PriorityServiceLoader<S>(type, holders);
        }
        catch (IOException e) {
            throw Messages.MESSAGES.failedToLoadService(e, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<S> first() {
        if (this.size > 0) {
            Object object = this.lock;
            synchronized (object) {
                return Optional.of(this.holders[0].getInstance());
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<S> last() {
        if (this.size > 0) {
            Object object = this.lock;
            synchronized (object) {
                return Optional.of(this.holders[this.size - 1].getInstance());
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<S>> getTypes() {
        Holder[] holders;
        Object object = this.lock;
        synchronized (object) {
            holders = (Holder[])this.holders.clone();
        }
        int len = holders.length;
        LinkedHashSet<Class<S>> result = new LinkedHashSet<Class<S>>(len);
        for (Holder holder : holders) {
            result.add(holder.type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<S> iterator() {
        Holder[] holders;
        Object object = this.lock;
        synchronized (object) {
            holders = (Holder[])this.holders.clone();
        }
        return new Iterator<S>(){
            final AtomicInteger current = new AtomicInteger();

            @Override
            public boolean hasNext() {
                int i = this.current.get();
                return i + 1 <= PriorityServiceLoader.this.size;
            }

            @Override
            public S next() {
                int i = this.current.getAndIncrement();
                if (i >= PriorityServiceLoader.this.size) {
                    throw new NoSuchElementException();
                }
                return holders[i].getInstance();
            }
        };
    }

    public String toString() {
        return this.toString.get();
    }

    private static <S> Holder<S>[] findClasses(Class<S> type, ClassLoader cl, Function<Class<? extends S>, S> constructor) throws IOException {
        TreeSet<Holder<? extends S>> holders = new TreeSet<Holder<? extends S>>();
        Enumeration<URL> resources = cl.getResources(PREFIX + type.getName());
        block9: while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                block10: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int commentIdx = line.indexOf(35);
                        if (commentIdx >= 0) {
                            line = line.substring(0, commentIdx);
                        }
                        if ((line = line.trim()).equals("")) continue;
                        try {
                            Class<?> found = cl.loadClass(line);
                            Priority priority = found.getAnnotation(Priority.class);
                            int p = Integer.MAX_VALUE;
                            if (priority != null) {
                                p = priority.value();
                            }
                            holders.add(new Holder<S>(found, p, constructor));
                            continue block10;
                        }
                        catch (ClassNotFoundException e) {
                            LogMessages.LOGGER.failedToLoad(e, line);
                        }
                    }
                    continue block9;
                    {
                        continue block10;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                LogMessages.LOGGER.failedToLoad(e, url.toString());
            }
        }
        return holders.toArray(new Holder[0]);
    }

    private static ClassLoader classLoader(Class<?> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = service.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private static class Holder<S>
    implements Comparable<Holder<S>> {
        final Class<S> type;
        final int priority;
        final Function<Class<? extends S>, S> constructor;
        volatile S instance;

        private Holder(Class<S> type, int priority, Function<Class<? extends S>, S> constructor) {
            this.type = type;
            this.priority = priority;
            this.constructor = constructor;
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Holder)) {
                return false;
            }
            Holder other = (Holder)obj;
            return Objects.equals(this.type, other.type);
        }

        @Override
        public int compareTo(Holder o) {
            return Integer.compare(this.priority, o.priority);
        }

        public String toString() {
            return "Holder[type=" + String.valueOf(this.type) + ", priority=" + this.priority + ", currentInstance=" + String.valueOf(this.instance) + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        S getInstance() {
            if (this.instance == null) {
                Holder holder = this;
                synchronized (holder) {
                    try {
                        this.instance = this.createInstance();
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw Messages.MESSAGES.failedToConstructClass(e, this.type);
                    }
                }
            }
            return this.instance;
        }

        private S createInstance() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            if (this.constructor == null) {
                return this.type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.constructor.apply(this.type);
        }
    }
}

