/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.filter;

import com.gitee.jenkins.trigger.filter.BranchFilterType;

public final class BranchFilterConfig {
    private final BranchFilterType type;
    private final String includeBranchesSpec;
    private final String excludeBranchesSpec;
    private final String targetBranchRegex;

    private BranchFilterConfig(BranchFilterType type, String includeBranchesSpec, String excludeBranchesSpec, String targetBranchRegex) {
        this.type = type;
        this.includeBranchesSpec = includeBranchesSpec;
        this.excludeBranchesSpec = excludeBranchesSpec;
        this.targetBranchRegex = targetBranchRegex;
    }

    public BranchFilterType getType() {
        return this.type;
    }

    String getIncludeBranchesSpec() {
        return this.includeBranchesSpec;
    }

    String getExcludeBranchesSpec() {
        return this.excludeBranchesSpec;
    }

    String getTargetBranchRegex() {
        return this.targetBranchRegex;
    }

    public static class BranchFilterConfigBuilder {
        private String includeBranchesSpec;
        private String excludeBranchesSpec;
        private String targetBranchRegex;

        public static BranchFilterConfigBuilder branchFilterConfig() {
            return new BranchFilterConfigBuilder();
        }

        public BranchFilterConfigBuilder withIncludeBranchesSpec(String includeBranchesSpec) {
            this.includeBranchesSpec = includeBranchesSpec;
            return this;
        }

        public BranchFilterConfigBuilder withExcludeBranchesSpec(String excludeBranchesSpec) {
            this.excludeBranchesSpec = excludeBranchesSpec;
            return this;
        }

        public BranchFilterConfigBuilder withTargetBranchRegex(String targetBranchRegex) {
            this.targetBranchRegex = targetBranchRegex;
            return this;
        }

        public BranchFilterConfig build(BranchFilterType type) {
            return new BranchFilterConfig(type, this.includeBranchesSpec, this.excludeBranchesSpec, this.targetBranchRegex);
        }
    }
}

