/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.status;

import com.gitee.jenkins.webhook.status.BuildStatusAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.HttpResponses;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerResponse2;

class StatusPngAction
extends BuildStatusAction {
    protected StatusPngAction(Job<?, ?> project, Run<?, ?> build) {
        super(project, build);
    }

    @Override
    protected void writeStatusBody(StaplerResponse2 response, Run<?, ?> build, BuildStatusAction.BuildStatus status) {
        try {
            response.setHeader("Expires", "Fri, 01 Jan 1984 00:00:00 GMT");
            response.setHeader("Cache-Control", "no-cache, private");
            response.setHeader("Content-Type", "image/png");
            IOUtils.copy((InputStream)this.getStatusImage(status), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            throw HttpResponses.error((int)500, (String)"Could not generate response.");
        }
    }

    private InputStream getStatusImage(BuildStatusAction.BuildStatus status) {
        return switch (status) {
            case BuildStatusAction.BuildStatus.RUNNING -> this.getClass().getResourceAsStream("running.png");
            case BuildStatusAction.BuildStatus.SUCCESS -> this.getClass().getResourceAsStream("success.png");
            case BuildStatusAction.BuildStatus.FAILED -> this.getClass().getResourceAsStream("failed.png");
            case BuildStatusAction.BuildStatus.UNSTABLE -> this.getClass().getResourceAsStream("unstable.png");
            default -> this.getClass().getResourceAsStream("unknown.png");
        };
    }
}

