/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.handler.push;

import com.gitee.jenkins.cause.CauseData;
import com.gitee.jenkins.cause.CauseDataBuilder;
import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.gitee.hook.model.Commit;
import com.gitee.jenkins.gitee.hook.model.PushHook;
import com.gitee.jenkins.trigger.exception.NoRevisionToBuildException;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BuildInstructionFilter;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilter;
import com.gitee.jenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.gitee.jenkins.trigger.handler.push.PushHookTriggerHandler;
import com.gitee.jenkins.util.BuildUtil;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;

class PushHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<PushHook>
implements PushHookTriggerHandler {
    private static final Logger LOGGER = Logger.getLogger(PushHookTriggerHandlerImpl.class.getName());
    private static final String NO_COMMIT = "0000000000000000000000000000000000000000";
    private final boolean skipWorkInProgressPullRequest;
    private final boolean ciBuildForDeleteRef;

    PushHookTriggerHandlerImpl(boolean skipWorkInProgressPullRequest, boolean ciBuildForDeleteRef) {
        this.skipWorkInProgressPullRequest = skipWorkInProgressPullRequest;
        this.ciBuildForDeleteRef = ciBuildForDeleteRef;
    }

    @Override
    public void handle(Job<?, ?> job, PushHook hook, BuildInstructionFilter buildInstructionFilter, boolean skipLastCommitHasBeenBuild, BranchFilter branchFilter, PullRequestLabelFilter pullRequestLabelFilter) {
        if (this.ciBuildForDeleteRef || this.isNoRemoveBranchPush(hook)) {
            super.handle(job, hook, buildInstructionFilter, skipLastCommitHasBeenBuild, branchFilter, pullRequestLabelFilter);
        }
    }

    @Override
    protected boolean isCiSkip(PushHook hook, BuildInstructionFilter buildInstructionFilter) {
        List<Commit> commits = hook.getCommits();
        if (buildInstructionFilter != null && commits != null && !commits.isEmpty()) {
            return !buildInstructionFilter.isBuildAllow(commits.get(commits.size() - 1).getMessage());
        }
        return false;
    }

    @Override
    protected boolean isCommitSkip(Job<?, ?> project, PushHook hook) {
        Run<?, ?> pushBuild;
        String sha = hook.getAfter();
        if (hook != null && sha != null && (pushBuild = BuildUtil.getBuildBySHA1IncludingMergeBuilds(project, sha)) != null && StringUtils.equals((String)this.getRefFromBuild(pushBuild), (String)hook.getRef())) {
            LOGGER.log(Level.INFO, "Last commit in push has already been built sha=" + sha);
            return true;
        }
        return false;
    }

    @Override
    protected CauseData retrieveCauseData(PushHook hook) {
        CauseData.ActionType actionType = CauseData.ActionType.PUSH;
        return CauseDataBuilder.causeData().withActionType(actionType).withSourceProjectId(hook.getProjectId()).withTargetProjectId(hook.getProjectId()).withBranch(this.getTargetBranch(hook)).withSourceBranch(this.getTargetBranch(hook)).withUserName(hook.getUserName()).withUserEmail(hook.getUserEmail()).withSourceRepoHomepage(hook.getProject().getHomepage()).withSourceRepoName(hook.getProject().getName()).withSourceNamespace(hook.getProject().getNamespace()).withSourceRepoUrl(hook.getProject().getUrl()).withSourceRepoSshUrl(hook.getProject().getSshUrl()).withSourceRepoHttpUrl(hook.getProject().getGitHttpUrl()).withPullRequestTitle("").withPullRequestDescription("").withPullRequestId(null).withPullRequestIid(null).withPullRequestState(null).withMergedByUser("").withPullRequestAssignee("").withPullRequestTargetProjectId(null).withTargetBranch(this.getTargetBranch(hook)).withTargetRepoName("").withTargetNamespace("").withTargetRepoSshUrl("").withTargetRepoHttpUrl("").withTriggeredByUser(hook.getSender().getName()).withBefore(hook.getBefore()).withAfter(hook.getAfter()).withRef(hook.getRef()).withLastCommit(hook.getAfter()).withSha(hook.getAfter()).withCreated(hook.getCreated()).withDeleted(hook.getDeleted()).withTargetProjectUrl(hook.getProject().getUrl()).withJsonBody(hook.getJsonBody()).build();
    }

    @Override
    protected String getTargetBranch(PushHook hook) {
        return hook.getRef() == null ? null : hook.getRef().replaceFirst("^refs/heads/", "");
    }

    @Override
    protected String getTriggerType() {
        return "push";
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(PushHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook, gitSCM), this.retrieveUrIish(hook));
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(PushHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getProjectId()).withSha(hook.getAfter()).withRef(this.getTargetBranch(hook)).build();
    }

    private String retrievePushedBy(PushHook hook) {
        String userName = hook.getUserName();
        if (StringUtils.isNotBlank((String)userName)) {
            return userName;
        }
        List<Commit> commits = hook.getCommits();
        if (commits != null && !commits.isEmpty()) {
            return commits.get(commits.size() - 1).getAuthor().getName();
        }
        return null;
    }

    private String retrieveRevisionToBuild(PushHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        if (this.isNoRemoveBranchPush(hook)) {
            if (gitSCM != null && gitSCM.getRepositories().size() == 1) {
                String repositoryName = ((RemoteConfig)gitSCM.getRepositories().get(0)).getName();
                return hook.getRef().replaceFirst("^refs/heads", "remotes/" + repositoryName);
            }
            return hook.getAfter();
        }
        throw new NoRevisionToBuildException();
    }

    private boolean isNoRemoveBranchPush(PushHook hook) {
        return hook.getAfter() != null && !hook.getAfter().equals(NO_COMMIT);
    }

    private String getRefFromBuild(Run<?, ?> pushBuild) {
        GiteeWebHookCause cause = (GiteeWebHookCause)pushBuild.getCause(GiteeWebHookCause.class);
        return cause == null ? null : cause.getData().getRef();
    }
}

