/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.api.model.builder.generated.PullRequestBuilder;
import com.gitee.jenkins.publisher.Messages;
import com.gitee.jenkins.util.LoggerUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GiteeCreatePullRequestPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(GiteeCreatePullRequestPublisher.class.getName());
    private String repo;
    private String owner;
    private String title;
    private String base;
    private String head;
    private String body;
    private List<LabelNameEntry> labelNames = Collections.emptyList();
    private boolean addDatetime;

    @DataBoundConstructor
    public GiteeCreatePullRequestPublisher() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBase() {
        return this.base;
    }

    public String getHead() {
        return this.head;
    }

    public boolean getAddDatetime() {
        return this.addDatetime;
    }

    public String getBody() {
        return this.body;
    }

    public List<LabelNameEntry> getLabelNames() {
        return this.labelNames;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @DataBoundSetter
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setBase(String base) {
        this.base = base;
    }

    @DataBoundSetter
    public void setHead(String head) {
        this.head = head;
    }

    @DataBoundSetter
    public void setAddDatetime(boolean addDatetime) {
        this.addDatetime = addDatetime;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    @DataBoundSetter
    public void setLabelNames(List<LabelNameEntry> labelNames) {
        this.labelNames = labelNames;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PullRequest pr;
        ArrayList<String> labels = new ArrayList<String>();
        for (LabelNameEntry entry : this.labelNames) {
            if (labels.contains(entry.toString())) continue;
            labels.add(entry.toString());
        }
        GiteeClient client = GiteeConnectionProperty.getClient(build);
        if (client == null) {
            listener.getLogger().println("No Gitee connection configured");
            return true;
        }
        String pullRequestTitle = this.title;
        if (this.addDatetime) {
            StringBuilder newTitle = new StringBuilder();
            newTitle.append(LocalDateTime.now().toString());
            newTitle.append(" ");
            newTitle.append(this.title);
            pullRequestTitle = newTitle.toString();
        }
        if (build.getResult() == Result.SUCCESS) {
            pr = PullRequestBuilder.pullRequest().withRepoOwner(this.owner).withRepoPath(this.repo).withTitle(pullRequestTitle).withSourceBranch(this.head).withTargetBranch(this.base).withDescription(this.body).withLabels(labels).build();
            if (!client.getPullRequest(pr).isEmpty()) {
                LOGGER.log(Level.INFO, "Pull request {0} -> {1} already exists", LoggerUtil.toArray(this.head, this.base));
                if (launcher != null) {
                    launcher.getListener().getLogger().println("Pull request {0} -> {1} already exists");
                }
                return true;
            }
            client.createPullRequest(pr);
            LOGGER.log(Level.INFO, "Pull request {0} generated, {1} -> {2}", LoggerUtil.toArray(this.title, this.head, this.base));
        }
        if (build.getResult() == Result.SUCCESS) {
            pr = PullRequestBuilder.pullRequest().withRepoOwner(this.owner).withRepoPath(this.repo).withTitle(pullRequestTitle).withSourceBranch(this.head).withTargetBranch(this.base).withDescription(this.body).build();
            if (!client.getPullRequest(pr).isEmpty()) {
                LOGGER.log(Level.INFO, "Pull request {0} -> {1} already exists", LoggerUtil.toArray(this.head, this.base));
                if (launcher != null) {
                    launcher.getListener().getLogger().println("Pull request {0} -> {1} already exists");
                }
                return true;
            }
            client.createPullRequest(pr);
            LOGGER.log(Level.INFO, "Pull request {0} generated, {1} -> {2}", LoggerUtil.toArray(this.title, this.head, this.base));
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                GiteeCreatePullRequestPublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    public static final class LabelNameEntry
    extends AbstractDescribableImpl<LabelNameEntry> {
        private final String text;

        @DataBoundConstructor
        public LabelNameEntry(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<LabelNameEntry> {
            public String getDisplayName() {
                return "Label";
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/gitee/help/help-createPullRequest.html";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GiteeCreatePullRequestPublisher_DisplayName();
        }
    }
}

