/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger;

import com.gitee.jenkins.connection.GiteeConnection;
import com.gitee.jenkins.connection.GiteeConnectionConfig;
import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.hook.model.NoteHook;
import com.gitee.jenkins.gitee.hook.model.PipelineHook;
import com.gitee.jenkins.gitee.hook.model.PullRequestHook;
import com.gitee.jenkins.gitee.hook.model.PushHook;
import com.gitee.jenkins.publisher.GiteeAcceptPullRequestPublisher;
import com.gitee.jenkins.publisher.GiteeMessagePublisher;
import com.gitee.jenkins.trigger.Messages;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BranchFilterConfig;
import com.gitee.jenkins.trigger.filter.BranchFilterFactory;
import com.gitee.jenkins.trigger.filter.BranchFilterType;
import com.gitee.jenkins.trigger.filter.BuildInstructionFilterType;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilter;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilterConfig;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilterFactory;
import com.gitee.jenkins.trigger.handler.note.NoteHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.note.NoteHookTriggerHandlerFactory;
import com.gitee.jenkins.trigger.handler.pipeline.PipelineHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.pipeline.PipelineHookTriggerHandlerFactory;
import com.gitee.jenkins.trigger.handler.pull.PullRequestHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.pull.PullRequestHookTriggerHandlerFactory;
import com.gitee.jenkins.trigger.handler.push.PushHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.push.PushHookTriggerHandlerFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.Secret;
import hudson.util.SequentialExecutionQueue;
import java.io.IOException;
import java.io.ObjectStreamException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class GiteePushTrigger
extends Trigger<Job<?, ?>> {
    private boolean triggerOnPush = true;
    private boolean triggerOnCommitComment = false;
    private boolean triggerOnOpenPullRequest = true;
    private boolean triggerOnPipelineEvent = false;
    private boolean triggerOnAcceptedPullRequest = false;
    private String triggerOnUpdatePullRequest = "3";
    private boolean triggerOnClosedPullRequest = false;
    private boolean triggerOnApprovedPullRequest = false;
    private boolean triggerOnTestedPullRequest = false;
    private boolean triggerOnNoteRequest = true;
    private String noteRegex = "";
    private transient boolean ciSkip = true;
    private BuildInstructionFilterType buildInstructionFilterType = BuildInstructionFilterType.NONE;
    private boolean skipWorkInProgressPullRequest;
    private boolean ciSkipFroTestNotRequired;
    private boolean ciBuildForDeleteRef;
    private boolean skipLastCommitHasBeenBuild;
    private boolean setBuildDescription = true;
    private transient boolean addNoteOnPullRequest;
    private transient boolean addCiMessage;
    private transient boolean addVoteOnPullRequest;
    private transient boolean allowAllBranches = false;
    private transient String branchFilterName;
    private BranchFilterType branchFilterType;
    private String includeBranchesSpec;
    private String excludeBranchesSpec;
    private String targetBranchRegex;
    private PullRequestLabelFilterConfig pullRequestLabelFilterConfig;
    private volatile Secret secretToken;
    private String pendingBuildName;
    private boolean cancelPendingBuildsOnUpdate;
    private boolean cancelIncompleteBuildOnSamePullRequest;
    private boolean ignorePullRequestConflicts;
    private transient BranchFilter branchFilter;
    private transient PushHookTriggerHandler pushHookTriggerHandler;
    private transient PullRequestHookTriggerHandler pullRequestHookTriggerHandler;
    private transient NoteHookTriggerHandler noteHookTriggerHandler;
    private transient PipelineHookTriggerHandler pipelineTriggerHandler;
    private transient boolean acceptPullRequestOnSuccess;
    private transient PullRequestLabelFilter pullRequestLabelFilter;

    @Deprecated
    @GeneratePojoBuilder(intoPackage="*.builder.generated", withFactoryMethod="*")
    public GiteePushTrigger(boolean triggerOnPush, boolean triggerOnCommitComment, boolean triggerOnOpenPullRequest, String triggerOnUpdatePullRequest, boolean triggerOnAcceptedPullRequest, boolean triggerOnClosedPullRequest, boolean triggerOnNoteRequest, String noteRegex, boolean skipWorkInProgressPullRequest, boolean ciSkip, BuildInstructionFilterType buildInstructionFilterType, boolean setBuildDescription, boolean addNoteOnPullRequest, boolean addCiMessage, boolean addVoteOnPullRequest, boolean acceptPullRequestOnSuccess, BranchFilterType branchFilterType, String includeBranchesSpec, String excludeBranchesSpec, String targetBranchRegex, PullRequestLabelFilterConfig pullRequestLabelFilterConfig, String secretToken, boolean triggerOnPipelineEvent, boolean triggerOnApprovedPullRequest, String pendingBuildName, boolean cancelPendingBuildsOnUpdate, boolean cancelIncompleteBuildOnSamePullRequest, boolean ignorePullRequestConflicts) {
        this.triggerOnPush = triggerOnPush;
        this.triggerOnCommitComment = triggerOnCommitComment;
        this.triggerOnOpenPullRequest = triggerOnOpenPullRequest;
        this.triggerOnUpdatePullRequest = triggerOnUpdatePullRequest;
        this.triggerOnAcceptedPullRequest = triggerOnAcceptedPullRequest;
        this.triggerOnClosedPullRequest = triggerOnClosedPullRequest;
        this.triggerOnNoteRequest = triggerOnNoteRequest;
        this.noteRegex = noteRegex;
        this.triggerOnPipelineEvent = triggerOnPipelineEvent;
        this.ciSkip = ciSkip;
        this.buildInstructionFilterType = buildInstructionFilterType;
        this.skipWorkInProgressPullRequest = skipWorkInProgressPullRequest;
        this.setBuildDescription = setBuildDescription;
        this.addNoteOnPullRequest = addNoteOnPullRequest;
        this.addCiMessage = addCiMessage;
        this.addVoteOnPullRequest = addVoteOnPullRequest;
        this.branchFilterType = branchFilterType;
        this.includeBranchesSpec = includeBranchesSpec;
        this.excludeBranchesSpec = excludeBranchesSpec;
        this.targetBranchRegex = targetBranchRegex;
        this.acceptPullRequestOnSuccess = acceptPullRequestOnSuccess;
        this.pullRequestLabelFilterConfig = pullRequestLabelFilterConfig;
        this.secretToken = Secret.fromString((String)secretToken);
        this.triggerOnApprovedPullRequest = triggerOnApprovedPullRequest;
        this.pendingBuildName = pendingBuildName;
        this.cancelPendingBuildsOnUpdate = cancelPendingBuildsOnUpdate;
        this.cancelIncompleteBuildOnSamePullRequest = cancelIncompleteBuildOnSamePullRequest;
        this.ignorePullRequestConflicts = ignorePullRequestConflicts;
        this.initializeTriggerHandler();
        this.initializeBranchFilter();
        this.initializePullRequestLabelFilter();
    }

    @DataBoundConstructor
    public GiteePushTrigger() {
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void migrateJobs() throws IOException {
        GiteePushTrigger trigger;
        DescriptorImpl oldConfig = (DescriptorImpl)((Object)Trigger.all().get(DescriptorImpl.class));
        if (!oldConfig.jobsMigrated) {
            GiteeConnectionConfig giteeConfig = (GiteeConnectionConfig)Jenkins.get().getDescriptor(GiteeConnectionConfig.class);
            giteeConfig.getConnections().add(new GiteeConnection(oldConfig.giteeHostUrl, oldConfig.giteeHostUrl, oldConfig.GiteeApiToken, "autodetect", oldConfig.ignoreCertificateErrors, (Integer)10, (Integer)10));
            String defaultConnectionName = giteeConfig.getConnections().get(0).getName();
            for (AbstractProject project : Jenkins.get().getAllItems(AbstractProject.class)) {
                GiteePushTrigger trigger2 = (GiteePushTrigger)project.getTrigger(GiteePushTrigger.class);
                if (trigger2 == null) continue;
                project.addProperty((JobProperty)new GiteeConnectionProperty(defaultConnectionName));
                project.save();
            }
            giteeConfig.save();
            oldConfig.jobsMigrated = true;
            oldConfig.save();
        }
        if (!oldConfig.jobsMigrated2) {
            for (AbstractProject project : Jenkins.get().getAllItems(AbstractProject.class)) {
                trigger = (GiteePushTrigger)project.getTrigger(GiteePushTrigger.class);
                if (trigger == null) continue;
                if (trigger.addNoteOnPullRequest) {
                    project.getPublishersList().add((Object)new GiteeMessagePublisher());
                }
                if (trigger.acceptPullRequestOnSuccess) {
                    project.getPublishersList().add((Object)new GiteeAcceptPullRequestPublisher());
                }
                project.save();
            }
            oldConfig.jobsMigrated2 = true;
            oldConfig.save();
        }
        if (!oldConfig.jobsMigrated4) {
            for (AbstractProject project : Jenkins.get().getAllItems(AbstractProject.class)) {
                trigger = (GiteePushTrigger)project.getTrigger(GiteePushTrigger.class);
                if (trigger == null) continue;
                if (trigger.getCiSkip()) {
                    trigger.setBuildInstructionFilterType(BuildInstructionFilterType.CI_SKIP);
                } else if (trigger.getBuildInstructionFilterType() == null) {
                    trigger.setBuildInstructionFilterType(BuildInstructionFilterType.NONE);
                }
                project.save();
            }
            oldConfig.jobsMigrated3 = false;
            oldConfig.jobsMigrated4 = true;
            oldConfig.save();
        }
    }

    public boolean getAddNoteOnPullRequest() {
        return this.addNoteOnPullRequest;
    }

    public boolean getTriggerOnPush() {
        return this.triggerOnPush;
    }

    public boolean isTriggerOnCommitComment() {
        return this.triggerOnCommitComment;
    }

    public boolean getTriggerOnOpenPullRequest() {
        return this.triggerOnOpenPullRequest;
    }

    public boolean getTriggerOnTestedPullRequest() {
        return this.triggerOnTestedPullRequest;
    }

    public String getTriggerOnUpdatePullRequest() {
        return this.triggerOnUpdatePullRequest;
    }

    public boolean isTriggerOnAcceptedPullRequest() {
        return this.triggerOnAcceptedPullRequest;
    }

    public boolean isTriggerOnApprovedPullRequest() {
        return this.triggerOnApprovedPullRequest;
    }

    public boolean isTriggerOnClosedPullRequest() {
        return this.triggerOnClosedPullRequest;
    }

    public boolean getTriggerOnNoteRequest() {
        return this.triggerOnNoteRequest;
    }

    public boolean getTriggerOnPipelineEvent() {
        return this.triggerOnPipelineEvent;
    }

    public String getNoteRegex() {
        return this.noteRegex == null ? "" : this.noteRegex;
    }

    public boolean getSetBuildDescription() {
        return this.setBuildDescription;
    }

    public boolean getCiSkip() {
        return this.ciSkip;
    }

    public BuildInstructionFilterType getBuildInstructionFilterType() {
        return this.buildInstructionFilterType;
    }

    public boolean getCiSkipFroTestNotRequired() {
        return this.ciSkipFroTestNotRequired;
    }

    public boolean getCiBuildForDeleteRef() {
        return this.ciBuildForDeleteRef;
    }

    public boolean getSkipLastCommitHasBeenBuild() {
        return this.skipLastCommitHasBeenBuild;
    }

    public boolean isSkipWorkInProgressPullRequest() {
        return this.skipWorkInProgressPullRequest;
    }

    public boolean isSkipLastCommitHasBuild() {
        return this.skipLastCommitHasBeenBuild;
    }

    public boolean isSkipFroTestNotRequired() {
        return this.ciSkipFroTestNotRequired;
    }

    public BranchFilterType getBranchFilterType() {
        return this.branchFilterType;
    }

    public String getIncludeBranchesSpec() {
        return this.includeBranchesSpec;
    }

    public String getExcludeBranchesSpec() {
        return this.excludeBranchesSpec;
    }

    public String getTargetBranchRegex() {
        return this.targetBranchRegex;
    }

    public PullRequestLabelFilterConfig getPullRequestLabelFilterConfig() {
        return this.pullRequestLabelFilterConfig;
    }

    public String getSecretToken() {
        return this.secretToken == null ? null : this.secretToken.getPlainText();
    }

    public String getPendingBuildName() {
        return this.pendingBuildName;
    }

    public boolean getCancelPendingBuildsOnUpdate() {
        return this.cancelPendingBuildsOnUpdate;
    }

    public boolean isCancelIncompleteBuildOnSamePullRequest() {
        return this.cancelIncompleteBuildOnSamePullRequest;
    }

    public boolean isIgnorePullRequestConflicts() {
        return this.ignorePullRequestConflicts;
    }

    @DataBoundSetter
    public void setTriggerOnPush(boolean triggerOnPush) {
        this.triggerOnPush = triggerOnPush;
    }

    @DataBoundSetter
    public void setTriggerOnCommitComment(boolean triggerOnCommitComment) {
        this.triggerOnCommitComment = triggerOnCommitComment;
    }

    @DataBoundSetter
    public void setTriggerOnApprovedPullRequest(boolean triggerOnApprovedPullRequest) {
        this.triggerOnApprovedPullRequest = triggerOnApprovedPullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnTestedPullRequest(boolean triggerOnTestedPullRequest) {
        this.triggerOnTestedPullRequest = triggerOnTestedPullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnOpenPullRequest(boolean triggerOnOpenPullRequest) {
        this.triggerOnOpenPullRequest = triggerOnOpenPullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnAcceptedPullRequest(boolean triggerOnAcceptedPullRequest) {
        this.triggerOnAcceptedPullRequest = triggerOnAcceptedPullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnClosedPullRequest(boolean triggerOnClosedPullRequest) {
        this.triggerOnClosedPullRequest = triggerOnClosedPullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnNoteRequest(boolean triggerOnNoteRequest) {
        this.triggerOnNoteRequest = triggerOnNoteRequest;
    }

    @DataBoundSetter
    public void setNoteRegex(String noteRegex) {
        this.noteRegex = noteRegex;
    }

    @DataBoundSetter
    public void setCiSkip(boolean ciSkip) {
        this.ciSkip = ciSkip;
    }

    @DataBoundSetter
    public void setBuildInstructionFilterType(BuildInstructionFilterType buildInstructionFilterType) {
        this.buildInstructionFilterType = buildInstructionFilterType;
    }

    @DataBoundSetter
    public void setCiSkipFroTestNotRequired(boolean ciSkipFroTestNotRequired) {
        this.ciSkipFroTestNotRequired = ciSkipFroTestNotRequired;
    }

    @DataBoundSetter
    public void setCiBuildForDeleteRef(boolean ciBuildForDeleteRef) {
        this.ciBuildForDeleteRef = ciBuildForDeleteRef;
    }

    @DataBoundSetter
    public void setSkipWorkInProgressPullRequest(boolean skipWorkInProgressPullRequest) {
        this.skipWorkInProgressPullRequest = skipWorkInProgressPullRequest;
    }

    @DataBoundSetter
    public void setSkipLastCommitHasBeenBuild(boolean skipLastCommitHasBeenBuild) {
        this.skipLastCommitHasBeenBuild = skipLastCommitHasBeenBuild;
    }

    @DataBoundSetter
    public void setSetBuildDescription(boolean setBuildDescription) {
        this.setBuildDescription = setBuildDescription;
    }

    @DataBoundSetter
    public void setAddNoteOnPullRequest(boolean addNoteOnPullRequest) {
        this.addNoteOnPullRequest = addNoteOnPullRequest;
    }

    @DataBoundSetter
    public void setAddCiMessage(boolean addCiMessage) {
        this.addCiMessage = addCiMessage;
    }

    @DataBoundSetter
    public void setAddVoteOnPullRequest(boolean addVoteOnPullRequest) {
        this.addVoteOnPullRequest = addVoteOnPullRequest;
    }

    @DataBoundSetter
    public void setBranchFilterName(String branchFilterName) {
        this.branchFilterName = branchFilterName;
    }

    @DataBoundSetter
    public void setBranchFilterType(BranchFilterType branchFilterType) {
        this.branchFilterType = branchFilterType;
    }

    @DataBoundSetter
    public void setIncludeBranchesSpec(String includeBranchesSpec) {
        this.includeBranchesSpec = includeBranchesSpec;
    }

    @DataBoundSetter
    public void setExcludeBranchesSpec(String excludeBranchesSpec) {
        this.excludeBranchesSpec = excludeBranchesSpec;
    }

    @DataBoundSetter
    public void setTargetBranchRegex(String targetBranchRegex) {
        this.targetBranchRegex = targetBranchRegex;
    }

    @DataBoundSetter
    public void setPullRequestLabelFilterConfig(PullRequestLabelFilterConfig pullRequestLabelFilterConfig) {
        this.pullRequestLabelFilterConfig = pullRequestLabelFilterConfig;
    }

    @DataBoundSetter
    public void setSecretToken(String secretToken) {
        this.secretToken = Secret.fromString((String)secretToken);
    }

    @DataBoundSetter
    public void setAcceptPullRequestOnSuccess(boolean acceptPullRequestOnSuccess) {
        this.acceptPullRequestOnSuccess = acceptPullRequestOnSuccess;
    }

    @DataBoundSetter
    public void setTriggerOnUpdatePullRequest(String triggerOnUpdatePullRequest) {
        this.triggerOnUpdatePullRequest = triggerOnUpdatePullRequest;
    }

    @DataBoundSetter
    public void setTriggerOnPipelineEvent(boolean triggerOnPipelineEvent) {
        this.triggerOnPipelineEvent = triggerOnPipelineEvent;
    }

    @DataBoundSetter
    public void setPendingBuildName(String pendingBuildName) {
        this.pendingBuildName = pendingBuildName;
    }

    @DataBoundSetter
    public void setCancelPendingBuildsOnUpdate(boolean cancelPendingBuildsOnUpdate) {
        this.cancelPendingBuildsOnUpdate = cancelPendingBuildsOnUpdate;
    }

    @DataBoundSetter
    public void setCancelIncompleteBuildOnSamePullRequest(boolean cancelIncompleteBuildOnSamePullRequest) {
        this.cancelIncompleteBuildOnSamePullRequest = cancelIncompleteBuildOnSamePullRequest;
    }

    @DataBoundSetter
    public void setIgnorePullRequestConflicts(boolean ignorePullRequestConflicts) {
        this.ignorePullRequestConflicts = ignorePullRequestConflicts;
    }

    public void onPost(PushHook hook) {
        if (this.branchFilter == null) {
            this.initializeBranchFilter();
        }
        if (this.pullRequestLabelFilter == null) {
            this.initializePullRequestLabelFilter();
        }
        if (this.pushHookTriggerHandler == null) {
            this.initializeTriggerHandler();
        }
        this.pushHookTriggerHandler.handle((Job)this.job, hook, this.buildInstructionFilterType, this.skipLastCommitHasBeenBuild, this.branchFilter, this.pullRequestLabelFilter);
    }

    public void onPost(PullRequestHook hook) {
        if (this.branchFilter == null) {
            this.initializeBranchFilter();
        }
        if (this.pullRequestLabelFilter == null) {
            this.initializePullRequestLabelFilter();
        }
        if (this.pullRequestHookTriggerHandler == null) {
            this.initializeTriggerHandler();
        }
        this.pullRequestHookTriggerHandler.handle((Job)this.job, hook, this.buildInstructionFilterType, this.skipLastCommitHasBeenBuild, this.branchFilter, this.pullRequestLabelFilter);
    }

    public void onPost(NoteHook hook) {
        if (this.branchFilter == null) {
            this.initializeBranchFilter();
        }
        if (this.pullRequestLabelFilter == null) {
            this.initializePullRequestLabelFilter();
        }
        if (this.noteHookTriggerHandler == null) {
            this.initializeTriggerHandler();
        }
        this.noteHookTriggerHandler.handle((Job)this.job, hook, this.buildInstructionFilterType, this.skipLastCommitHasBeenBuild, this.branchFilter, this.pullRequestLabelFilter);
    }

    public void onPost(PipelineHook hook) {
        if (this.pipelineTriggerHandler == null) {
            this.initializeTriggerHandler();
        }
        this.pipelineTriggerHandler.handle((Job)this.job, hook, this.buildInstructionFilterType, this.skipLastCommitHasBeenBuild, this.branchFilter, this.pullRequestLabelFilter);
    }

    private void initializeTriggerHandler() {
        this.pullRequestHookTriggerHandler = PullRequestHookTriggerHandlerFactory.newPullRequestHookTriggerHandler(this.triggerOnOpenPullRequest, this.triggerOnUpdatePullRequest, this.triggerOnAcceptedPullRequest, this.triggerOnClosedPullRequest, this.skipWorkInProgressPullRequest, this.triggerOnApprovedPullRequest, this.triggerOnTestedPullRequest, this.cancelPendingBuildsOnUpdate, this.ciSkipFroTestNotRequired, this.cancelIncompleteBuildOnSamePullRequest, this.ignorePullRequestConflicts);
        this.noteHookTriggerHandler = NoteHookTriggerHandlerFactory.newNoteHookTriggerHandler(this.triggerOnCommitComment, this.triggerOnNoteRequest, this.noteRegex, this.ciSkipFroTestNotRequired, this.cancelIncompleteBuildOnSamePullRequest, this.ignorePullRequestConflicts);
        this.pushHookTriggerHandler = PushHookTriggerHandlerFactory.newPushHookTriggerHandler(this.triggerOnPush, this.skipWorkInProgressPullRequest, this.ciBuildForDeleteRef);
        this.pipelineTriggerHandler = PipelineHookTriggerHandlerFactory.newPipelineHookTriggerHandler(this.triggerOnPipelineEvent);
    }

    private void initializeBranchFilter() {
        if (this.branchFilterType == null) {
            this.branchFilterType = BranchFilterType.All;
        }
        this.branchFilter = BranchFilterFactory.newBranchFilter(BranchFilterConfig.BranchFilterConfigBuilder.branchFilterConfig().withIncludeBranchesSpec(this.includeBranchesSpec).withExcludeBranchesSpec(this.excludeBranchesSpec).withTargetBranchRegex(this.targetBranchRegex).build(this.branchFilterType));
    }

    private void initializePullRequestLabelFilter() {
        this.pullRequestLabelFilter = PullRequestLabelFilterFactory.newPullRequestLabelFilter(this.pullRequestLabelFilterConfig);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.initializeTriggerHandler();
        this.initializeBranchFilter();
        this.initializePullRequestLabelFilter();
        return super.readResolve();
    }

    public static GiteePushTrigger getFromJob(Job<?, ?> job) {
        GiteePushTrigger trigger = null;
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn.ParameterizedJob p = (ParameterizedJobMixIn.ParameterizedJob)job;
            for (Object t : p.getTriggers().values()) {
                GiteePushTrigger pushTrigger;
                if (!(t instanceof GiteePushTrigger)) continue;
                trigger = pushTrigger = (GiteePushTrigger)((Object)t);
            }
        }
        return trigger;
    }

    @Extension
    @Symbol(value={"gitee"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Jenkins.MasterComputer.threadPoolForRemoting);
        private boolean jobsMigrated = false;
        private boolean jobsMigrated2 = false;
        private boolean jobsMigrated3 = false;
        private boolean jobsMigrated4 = false;
        private String GiteeApiToken;
        private String giteeHostUrl = "";
        private boolean ignoreCertificateErrors = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job && SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        @NonNull
        public String getDisplayName() {
            Job<?, ?> project = this.retrieveCurrentJob();
            if (project != null) {
                try {
                    return Messages.Build_Gitee_WebHook(this.retrieveProjectUrl(project));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return "Build when a change is pushed to Gitee, unknown URL";
        }

        private StringBuilder retrieveProjectUrl(Job<?, ?> project) {
            return new StringBuilder().append(Jenkins.get().getRootUrl()).append("gitee-project").append((CharSequence)this.retrieveParentUrl((Item)project)).append('/').append(Util.rawEncode((String)project.getName()));
        }

        private StringBuilder retrieveParentUrl(Item item) {
            ItemGroup itemGroup = item.getParent();
            if (itemGroup instanceof Item) {
                Item parent = (Item)itemGroup;
                return this.retrieveParentUrl(parent).append('/').append(Util.rawEncode((String)parent.getName()));
            }
            return new StringBuilder();
        }

        private Job<?, ?> retrieveCurrentJob() {
            StaplerRequest2 request = Stapler.getCurrentRequest2();
            if (request != null) {
                Ancestor ancestor = request.findAncestor(Job.class);
                return ancestor == null ? null : (Job)ancestor.getObject();
            }
            return null;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

