/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.build;

import com.gitee.jenkins.gitee.hook.model.Project;
import com.gitee.jenkins.gitee.hook.model.PushHook;
import com.gitee.jenkins.trigger.GiteePushTrigger;
import com.gitee.jenkins.util.JsonUtil;
import com.gitee.jenkins.util.LoggerUtil;
import com.gitee.jenkins.webhook.build.LegacyBuildWebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HttpResponses;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.springframework.security.core.Authentication;

public class LegacyPushBuildAction
extends LegacyBuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(LegacyPushBuildAction.class.getName());
    private final Item project;
    private PushHook pushHook;
    private final String secretToken;

    public LegacyPushBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.INFO, json);
        LOGGER.log(Level.FINE, "Push: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pushHook = JsonUtil.read(json, PushHook.class);
        this.pushHook.setJsonBody(json);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        if (this.pushHook.getProject() == null && this.pushHook.getRepository() != null) {
            try {
                String path = new URL(this.pushHook.getRepository().getGitHttpUrl()).getPath();
                if (StringUtils.isNotBlank((String)path)) {
                    Project project = new Project();
                    project.setNamespace(path.replaceFirst("/", "").substring(0, path.lastIndexOf("/")));
                    this.pushHook.setProject(project);
                } else {
                    LOGGER.log(Level.WARNING, "Could not find suitable namespace.");
                }
            }
            catch (MalformedURLException ignored) {
                LOGGER.log(Level.WARNING, "Invalid repository url found while building namespace.");
            }
        }
    }

    @Override
    public void execute() {
        if (this.pushHook.getRepository() != null && this.pushHook.getRepository().getUrl() == null) {
            LOGGER.log(Level.WARNING, "No repository url found.");
            return;
        }
        if (this.project instanceof Job) {
            Authentication auth = Jenkins.getAuthentication2();
            System.out.println(auth.getDetails());
            ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);
            try {
                new LegacyBuildWebHookAction.TriggerNotifier(this.project, this.secretToken, auth){

                    @Override
                    protected void performOnPost(GiteePushTrigger trigger) {
                        trigger.onPost(LegacyPushBuildAction.this.pushHook);
                    }
                }.run();
                throw LegacyPushBuildAction.responseWithHook(this.pushHook);
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        if (this.project instanceof SCMSourceOwner) {
            try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
                new SCMSourceOwnerNotifier().run();
            }
            throw LegacyPushBuildAction.responseWithHook(this.pushHook);
        }
        throw HttpResponses.errorWithoutStack((int)409, (String)"Push Hook is not supported for this project");
    }

    private class SCMSourceOwnerNotifier
    implements Runnable {
        private SCMSourceOwnerNotifier() {
        }

        @Override
        public void run() {
            for (SCMSource scmSource : ((SCMSourceOwner)LegacyPushBuildAction.this.project).getSCMSources()) {
                if (!(scmSource instanceof GitSCMSource)) continue;
                GitSCMSource gitSCMSource = (GitSCMSource)scmSource;
                try {
                    if (!new URIish(gitSCMSource.getRemote()).equals((Object)new URIish(gitSCMSource.getRemote()))) continue;
                    LOGGER.log(Level.FINE, "Notify scmSourceOwner {0} about changes for {1}", LoggerUtil.toArray(LegacyPushBuildAction.this.project.getName(), gitSCMSource.getRemote()));
                    ((SCMSourceOwner)LegacyPushBuildAction.this.project).onSCMSourceUpdated(scmSource);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
    }
}

