/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.api.model.builder.generated.PullRequestBuilder;
import com.gitee.jenkins.publisher.Messages;
import com.gitee.jenkins.util.LoggerUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GiteeCreatePullRequestPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(GiteeCreatePullRequestPublisher.class.getName());
    private String repo;
    private String owner;
    private String title;
    private String base;
    private String head;
    private String body;
    private boolean addDatetime;

    @DataBoundConstructor
    public GiteeCreatePullRequestPublisher() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBase() {
        return this.base;
    }

    public String getHead() {
        return this.head;
    }

    public boolean getAddDatetime() {
        return this.addDatetime;
    }

    public String getBody() {
        return this.body;
    }

    @DataBoundSetter
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @DataBoundSetter
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setBase(String base) {
        this.base = base;
    }

    @DataBoundSetter
    public void setHead(String head) {
        this.head = head;
    }

    @DataBoundSetter
    public void setAddDatetime(boolean addDatetime) {
        this.addDatetime = addDatetime;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        GiteeClient client = GiteeConnectionProperty.getClient(build);
        if (client == null) {
            listener.getLogger().println("No Gitee connection configured");
            return true;
        }
        Object pullRequestTitle = this.title;
        if (this.addDatetime) {
            pullRequestTitle = LocalDateTime.now().toString() + this.title;
        }
        if (build.getResult() == Result.SUCCESS) {
            PullRequest pr = PullRequestBuilder.pullRequest().withRepoOwner(this.owner).withRepoPath(this.repo).withTitle((String)pullRequestTitle).withSourceBranch(this.head).withTargetBranch(this.base).withDescription(this.body).build();
            if (!client.getPullRequest(pr).isEmpty()) {
                LOGGER.log(Level.INFO, "Pull request {0} -> {1} already exists", LoggerUtil.toArray(this.head, this.base));
                if (launcher != null) {
                    launcher.getListener().getLogger().println("Pull request {0} -> {1} already exists");
                }
                return true;
            }
            client.createPullRequest(pr);
            LOGGER.log(Level.INFO, "Pull request {0} generated, {1} -> {2}", LoggerUtil.toArray(this.title, this.head, this.base));
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                GiteeCreatePullRequestPublisher.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GiteeCreatePullRequestPublisher_DisplayName();
        }
    }
}

