/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.api.model;

import com.gitee.jenkins.gitee.api.model.User;
import com.gitee.jenkins.gitee.hook.model.PullRequestObjectAttributes;
import com.gitee.jenkins.gitee.hook.model.State;
import java.util.List;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@GeneratePojoBuilder(intoPackage="*.builder.generated", withFactoryMethod="*")
public class PullRequest {
    private Integer id;
    private Integer iid;
    private String sourceBranch;
    private String targetBranch;
    private Integer projectId;
    private String title;
    private State state;
    private Integer upvotes;
    private Integer downvotes;
    private User author;
    private User assignee;
    private Integer sourceProjectId;
    private Integer targetProjectId;
    private List<String> labels;
    private String description;
    private Boolean workInProgress;
    private Boolean mergeWhenBuildSucceeds;
    private String mergeStatus;
    private String repoOwner;
    private String repoPath;

    public PullRequest() {
    }

    public PullRequest(int id, int iid, String sourceBranch, String targetBranch, String title, int sourceProjectId, int targetProjectId, String description, String mergeStatus) {
        this.id = id;
        this.iid = iid;
        this.sourceBranch = sourceBranch;
        this.targetBranch = targetBranch;
        this.title = title;
        this.sourceProjectId = sourceProjectId;
        this.projectId = targetProjectId;
        this.description = description;
        this.mergeStatus = mergeStatus;
    }

    public PullRequest(PullRequestObjectAttributes objectAttributes) {
        this.id = objectAttributes.getId();
        this.iid = objectAttributes.getNumber();
        this.sourceBranch = objectAttributes.getSourceBranch();
        this.targetBranch = objectAttributes.getTargetBranch();
        this.title = objectAttributes.getTitle();
        this.sourceProjectId = objectAttributes.getSourceProjectId();
        this.projectId = objectAttributes.getTargetProjectId();
        this.description = objectAttributes.getBody();
        this.mergeStatus = objectAttributes.getMergeStatus();
        String[] path = objectAttributes.getTarget().getPathWithNamespace().split("/");
        this.repoOwner = path[0];
        this.repoPath = path[1];
    }

    public PullRequest(int id, int iid, String sourceBranch, String targetBranch, String title, int sourceProjectId, int targetProjectId, String description, String mergeStatus, String pathWithNamespace) {
        this.id = id;
        this.iid = iid;
        this.sourceBranch = sourceBranch;
        this.targetBranch = targetBranch;
        this.title = title;
        this.sourceProjectId = sourceProjectId;
        this.projectId = targetProjectId;
        this.description = description;
        this.mergeStatus = mergeStatus;
        try {
            String[] path = pathWithNamespace.split("/");
            this.repoOwner = path[0];
            this.repoPath = path[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getIid() {
        return this.iid;
    }

    public void setIid(Integer iid) {
        this.iid = iid;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Integer getUpvotes() {
        return this.upvotes;
    }

    public void setUpvotes(Integer upvotes) {
        this.upvotes = upvotes;
    }

    public Integer getDownvotes() {
        return this.downvotes;
    }

    public void setDownvotes(Integer downvotes) {
        this.downvotes = downvotes;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public Integer getSourceProjectId() {
        return this.sourceProjectId;
    }

    public void setSourceProjectId(Integer sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }

    public Integer getTargetProjectId() {
        return this.targetProjectId;
    }

    public void setTargetProjectId(Integer targetProjectId) {
        this.targetProjectId = targetProjectId;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getWorkInProgress() {
        return this.workInProgress;
    }

    public void setWorkInProgress(Boolean workInProgress) {
        this.workInProgress = workInProgress;
    }

    public Boolean getMergeWhenBuildSucceeds() {
        return this.mergeWhenBuildSucceeds;
    }

    public void setMergeWhenBuildSucceeds(Boolean mergeWhenBuildSucceeds) {
        this.mergeWhenBuildSucceeds = mergeWhenBuildSucceeds;
    }

    public String getMergeStatus() {
        return this.mergeStatus;
    }

    public void setMergeStatus(String mergeStatus) {
        this.mergeStatus = mergeStatus;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public void setRepoOwner(String repoOwner) {
        this.repoOwner = repoOwner;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public void setRepoPath(String repoPath) {
        this.repoPath = repoPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequest that = (PullRequest)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.iid, (Object)that.iid).append((Object)this.sourceBranch, (Object)that.sourceBranch).append((Object)this.targetBranch, (Object)that.targetBranch).append((Object)this.projectId, (Object)that.projectId).append((Object)this.title, (Object)that.title).append((Object)this.state, (Object)that.state).append((Object)this.upvotes, (Object)that.upvotes).append((Object)this.downvotes, (Object)that.downvotes).append((Object)this.author, (Object)that.author).append((Object)this.assignee, (Object)that.assignee).append((Object)this.sourceProjectId, (Object)that.sourceProjectId).append((Object)this.targetProjectId, (Object)that.targetProjectId).append(this.labels, that.labels).append((Object)this.description, (Object)that.description).append((Object)this.workInProgress, (Object)that.workInProgress).append((Object)this.mergeWhenBuildSucceeds, (Object)that.mergeWhenBuildSucceeds).append((Object)this.mergeStatus, (Object)that.mergeStatus).append((Object)this.repoPath, (Object)that.repoPath).append((Object)this.repoOwner, (Object)that.repoOwner).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.iid).append((Object)this.sourceBranch).append((Object)this.targetBranch).append((Object)this.projectId).append((Object)this.title).append((Object)this.state).append((Object)this.upvotes).append((Object)this.downvotes).append((Object)this.author).append((Object)this.assignee).append((Object)this.sourceProjectId).append((Object)this.targetProjectId).append(this.labels).append((Object)this.description).append((Object)this.workInProgress).append((Object)this.mergeWhenBuildSucceeds).append((Object)this.mergeStatus).append((Object)this.repoOwner).append((Object)this.repoPath).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("iid", (Object)this.iid).append("sourceBranch", (Object)this.sourceBranch).append("targetBranch", (Object)this.targetBranch).append("projectId", (Object)this.projectId).append("title", (Object)this.title).append("state", (Object)this.state).append("upvotes", (Object)this.upvotes).append("downvotes", (Object)this.downvotes).append("author", (Object)this.author).append("assignee", (Object)this.assignee).append("sourceProjectId", (Object)this.sourceProjectId).append("targetProjectId", (Object)this.targetProjectId).append("labels", this.labels).append("description", (Object)this.description).append("workInProgress", (Object)this.workInProgress).append("mergeWhenBuildSucceeds", (Object)this.mergeWhenBuildSucceeds).append("mergeStatus", (Object)this.mergeStatus).append("repoOwner", (Object)this.repoOwner).append("repoPath", (Object)this.repoPath).toString();
    }
}

