/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.status;

import com.gitee.jenkins.webhook.WebHookAction;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.HttpResponses;
import jenkins.triggers.SCMTriggerItem;
import org.kohsuke.stapler.StaplerResponse2;

abstract class BuildStatusAction
implements WebHookAction {
    private final Job<?, ?> project;
    private Run<?, ?> build;

    protected BuildStatusAction(Job<?, ?> project, Run<?, ?> build) {
        this.project = project;
        this.build = build;
    }

    @Override
    public void execute(StaplerResponse2 response) {
        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(this.project);
        if (!this.hasGitSCM(item)) {
            throw HttpResponses.error((int)409, (String)"The project has no GitSCM configured");
        }
        this.writeStatusBody(response, this.build, this.getStatus(this.build));
    }

    protected abstract void writeStatusBody(StaplerResponse2 var1, Run<?, ?> var2, BuildStatus var3);

    private boolean hasGitSCM(SCMTriggerItem item) {
        if (item != null) {
            for (SCM scm : item.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                return true;
            }
        }
        return false;
    }

    private BuildStatus getStatus(Run<?, ?> build) {
        if (build == null) {
            return BuildStatus.NOT_FOUND;
        }
        if (build.isBuilding()) {
            return BuildStatus.RUNNING;
        }
        if (build.getResult() == Result.ABORTED) {
            return BuildStatus.CANCELED;
        }
        if (build.getResult() == Result.SUCCESS) {
            return BuildStatus.SUCCESS;
        }
        if (build.getResult() == Result.UNSTABLE) {
            return BuildStatus.UNSTABLE;
        }
        return BuildStatus.FAILED;
    }

    protected static enum BuildStatus {
        NOT_FOUND("not_found"),
        RUNNING("running"),
        CANCELED("canceled"),
        SUCCESS("success"),
        FAILED("failed"),
        UNSTABLE("failed");

        private final String value;

        private BuildStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

