/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.build;

import com.gitee.jenkins.gitee.hook.model.PipelineHook;
import com.gitee.jenkins.gitee.hook.model.Project;
import com.gitee.jenkins.trigger.GiteePushTrigger;
import com.gitee.jenkins.util.JsonUtil;
import com.gitee.jenkins.webhook.build.LegacyBuildWebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HttpResponses;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;

public class LegacyPipelineBuildAction
extends LegacyBuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(LegacyPipelineBuildAction.class.getName());
    private Item project;
    private PipelineHook pipelineBuildHook;
    private final String secretToken;

    public LegacyPipelineBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "Pipeline event: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pipelineBuildHook = JsonUtil.read(json, PipelineHook.class);
        this.pipelineBuildHook.setJsonBody(json);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        if (this.pipelineBuildHook.getProject() == null && this.pipelineBuildHook.getRepository() != null) {
            try {
                String path = new URL(this.pipelineBuildHook.getRepository().getGitHttpUrl()).getPath();
                if (StringUtils.isNotBlank((String)path)) {
                    Project project = new Project();
                    project.setNamespace(path.replaceFirst("/", "").substring(0, path.lastIndexOf("/")));
                    this.pipelineBuildHook.setProject(project);
                } else {
                    LOGGER.log(Level.WARNING, "Could not find suitable namespace.");
                }
            }
            catch (MalformedURLException ignored) {
                LOGGER.log(Level.WARNING, "Invalid repository url found while building namespace.");
            }
        }
    }

    @Override
    void execute() {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Pipeline Hook is not supported for this project");
        }
        Authentication auth = Jenkins.getAuthentication2();
        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
            new LegacyBuildWebHookAction.TriggerNotifier(this.project, this.secretToken, auth){

                @Override
                protected void performOnPost(GiteePushTrigger trigger) {
                    trigger.onPost(LegacyPipelineBuildAction.this.pipelineBuildHook);
                }
            }.run();
        }
        throw LegacyPipelineBuildAction.responseWithHook(this.pipelineBuildHook);
    }
}

