/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.build;

import com.gitee.jenkins.gitee.hook.model.NoteHook;
import com.gitee.jenkins.trigger.GiteePushTrigger;
import com.gitee.jenkins.util.JsonUtil;
import com.gitee.jenkins.webhook.build.LegacyBuildWebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.HttpResponses;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.springframework.security.core.Authentication;

public class LegacyNoteBuildAction
extends LegacyBuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(LegacyNoteBuildAction.class.getName());
    private Item project;
    private NoteHook noteHook;
    private final String secretToken;

    public LegacyNoteBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "Note: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.noteHook = JsonUtil.read(json, NoteHook.class);
        this.noteHook.setJsonBody(json);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
    }

    @Override
    public void execute() {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Note Hook is not supported for this project");
        }
        Authentication auth = Jenkins.getAuthentication2();
        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
            new LegacyBuildWebHookAction.TriggerNotifier(this.project, this.secretToken, auth){

                @Override
                protected void performOnPost(GiteePushTrigger trigger) {
                    trigger.onPost(LegacyNoteBuildAction.this.noteHook);
                }
            }.run();
        }
        throw LegacyNoteBuildAction.responseWithHook(this.noteHook);
    }
}

