/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.webhook.build;

import com.gitee.jenkins.connection.GiteeConnectionConfig;
import com.gitee.jenkins.gitee.hook.model.WebHook;
import com.gitee.jenkins.trigger.GiteePushTrigger;
import com.gitee.jenkins.webhook.WebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.core.Authentication;

abstract class BuildWebHookAction
implements WebHookAction {
    private static final Logger LOGGER = Logger.getLogger(BuildWebHookAction.class.getName());

    BuildWebHookAction() {
    }

    abstract void processForCompatibility();

    abstract void execute();

    @Override
    public final void execute(StaplerResponse2 response) {
        this.processForCompatibility();
        this.execute();
    }

    public static HttpResponses.HttpResponseException responseWithHook(final WebHook webHook) {
        return new HttpResponses.HttpResponseException(){

            public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                String text = webHook.getWebHookDescription() + " has been accepted.";
                rsp.setContentType("text/plain;charset=UTF-8");
                rsp.getWriter().println(text);
            }
        };
    }

    protected static abstract class TriggerNotifier
    implements Runnable {
        private final Item project;
        private final String secretToken;
        private final Authentication authentication;

        public TriggerNotifier(Item project, String secretToken, Authentication authentication) {
            this.project = project;
            this.secretToken = secretToken;
            this.authentication = authentication;
        }

        @Override
        public void run() {
            GiteePushTrigger trigger = GiteePushTrigger.getFromJob((Job)this.project);
            if (trigger != null) {
                if (StringUtils.isEmpty((String)trigger.getSecretToken())) {
                    this.checkPermission(Item.BUILD, this.project);
                } else if (!StringUtils.equals((String)trigger.getSecretToken(), (String)this.secretToken)) {
                    throw HttpResponses.errorWithoutStack((int)401, (String)"Invalid token");
                }
                this.performOnPost(trigger);
            }
        }

        private void checkPermission(Permission permission, Item project) {
            if (((GiteeConnectionConfig)Objects.requireNonNull(Jenkins.get().getDescriptor(GiteeConnectionConfig.class))).isUseAuthenticatedEndpoint() && !project.getACL().hasPermission2(this.authentication, permission)) {
                String message = this.authentication.getName() + " is missing the " + String.valueOf(permission.group.title) + "/" + permission.name + " permission";
                LOGGER.finest("Unauthorized (Did you forget to add API Token to the web hook ?)");
                throw HttpResponses.errorWithoutStack((int)403, (String)message);
            }
        }

        protected abstract void performOnPost(GiteePushTrigger var1);
    }
}

