/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.handler.note;

import com.gitee.jenkins.cause.CauseData;
import com.gitee.jenkins.cause.CauseDataBuilder;
import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.hook.model.NoteAction;
import com.gitee.jenkins.gitee.hook.model.NoteHook;
import com.gitee.jenkins.gitee.hook.model.PullRequestObjectAttributes;
import com.gitee.jenkins.publisher.GiteeMessagePublisher;
import com.gitee.jenkins.trigger.exception.NoRevisionToBuildException;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BuildInstructionFilter;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilter;
import com.gitee.jenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.gitee.jenkins.trigger.handler.note.NoteHookTriggerHandler;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;

class NoteHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<NoteHook>
implements NoteHookTriggerHandler {
    private static final Logger LOGGER = Logger.getLogger(NoteHookTriggerHandlerImpl.class.getName());
    private final boolean triggerOnCommitComment;
    private final boolean triggerOnNoteRequest;
    private final String noteRegex;
    private final boolean ciSkipFroTestNotRequired;
    private final boolean cancelIncompleteBuildOnSamePullRequest;
    private boolean ignorePullRequestConflicts;

    NoteHookTriggerHandlerImpl(boolean triggerOnCommitComment, boolean triggerOnNoteRequest, String noteRegex, boolean ciSkipFroTestNotRequired, boolean cancelIncompleteBuildOnSamePullRequest, boolean ignorePullRequestConflicts) {
        this.triggerOnCommitComment = triggerOnCommitComment;
        this.triggerOnNoteRequest = triggerOnNoteRequest;
        this.noteRegex = noteRegex;
        this.ciSkipFroTestNotRequired = ciSkipFroTestNotRequired;
        this.cancelIncompleteBuildOnSamePullRequest = cancelIncompleteBuildOnSamePullRequest;
        this.ignorePullRequestConflicts = ignorePullRequestConflicts;
    }

    @Override
    public void handle(Job<?, ?> job, NoteHook hook, BuildInstructionFilter buildInstructionFilter, boolean skipLastCommitHasBeenBuild, BranchFilter branchFilter, PullRequestLabelFilter pullRequestLabelFilter) {
        if (this.isValidTrigger(hook)) {
            PullRequestObjectAttributes objectAttributes = hook.getPullRequest();
            if (!this.ignorePullRequestConflicts && objectAttributes != null && !objectAttributes.isMergeable()) {
                LOGGER.log(Level.INFO, "This pull request can not be merge");
                GiteeMessagePublisher publisher = GiteeMessagePublisher.getFromJob(job);
                GiteeClient client = GiteeConnectionProperty.getClient(job);
                if (publisher != null && client != null) {
                    PullRequest pullRequest = new PullRequest(objectAttributes);
                    LOGGER.log(Level.INFO, "sending message to gitee.....");
                    client.createPullRequestNote(pullRequest, ":bangbang: This pull request can not be merge! The build will not be triggered. Please manual merge conflict.");
                }
                return;
            }
            if (objectAttributes != null && this.ciSkipFroTestNotRequired && !objectAttributes.getNeedTest()) {
                LOGGER.log(Level.INFO, "Skip because this pull don't need test.");
                return;
            }
            super.handle(job, hook, buildInstructionFilter, skipLastCommitHasBeenBuild, branchFilter, pullRequestLabelFilter);
        }
    }

    @Override
    protected boolean isCiSkip(NoteHook hook, BuildInstructionFilter buildInstructionFilter) {
        if (buildInstructionFilter != null && hook.getPullRequest() != null) {
            return !buildInstructionFilter.isBuildAllow(hook.getPullRequest().getBody());
        }
        return false;
    }

    @Override
    protected boolean isCommitSkip(Job<?, ?> project, NoteHook hook) {
        return false;
    }

    @Override
    protected void cancelIncompleteBuildIfNecessary(Job<?, ?> job, NoteHook hook) {
        if (!this.cancelIncompleteBuildOnSamePullRequest || hook.getPullRequest() == null) {
            return;
        }
        for (Run build : job.getBuilds()) {
            CauseData causeData;
            if (!job.isBuilding()) break;
            if (!build.isBuilding()) continue;
            CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
            GiteeWebHookCause giteeWebHookCause = null;
            for (Cause cause : causeAction.getCauses()) {
                GiteeWebHookCause webHookCause;
                if (!(cause instanceof GiteeWebHookCause)) continue;
                giteeWebHookCause = webHookCause = (GiteeWebHookCause)cause;
                break;
            }
            if (giteeWebHookCause == null || !(causeData = giteeWebHookCause.getData()).getSourceRepoHttpUrl().equals(hook.getPullRequest().getSource().getGitHttpUrl()) || !causeData.getTargetRepoHttpUrl().equals(hook.getPullRequest().getTarget().getGitHttpUrl()) || !causeData.getRef().equals(hook.getPullRequest().getMergeReferenceName())) continue;
            try {
                this.doStop(build);
            }
            catch (ServletException | IOException e) {
                LOGGER.log(Level.WARNING, "Unable to abort incomplete build", e);
            }
        }
    }

    @Override
    protected String getTargetBranch(NoteHook hook) {
        return hook.getPullRequest() == null ? null : hook.getPullRequest().getTargetBranch();
    }

    @Override
    protected String getTriggerType() {
        return "note";
    }

    @Override
    protected CauseData retrieveCauseData(NoteHook hook) {
        if (hook.getPullRequest() == null) {
            return CauseDataBuilder.causeData().withActionType(CauseData.ActionType.COMMIT_COMMENT).withUserName(hook.getComment().getUser().getUsername()).withUserEmail(hook.getComment().getUser().getEmail()).withPullRequestTitle("").withBranch("").withSourceBranch("").withSourceProjectId(hook.getProject().getId()).withSourceRepoHomepage(hook.getProject().getHomepage()).withSourceRepoName(hook.getProject().getName()).withSourceNamespace(hook.getProject().getNamespace()).withSourceRepoUrl(hook.getProject().getUrl()).withSourceRepoSshUrl(hook.getProject().getSshUrl()).withSourceRepoHttpUrl(hook.getProject().getGitHttpUrl()).withTargetBranch("").withTargetProjectId(hook.getProject().getId()).withTargetRepoName(hook.getProject().getName()).withTargetNamespace(hook.getProject().getNamespace()).withTargetRepoSshUrl(hook.getProject().getSshUrl()).withTargetRepoHttpUrl(hook.getProject().getGitHttpUrl()).withTriggeredByUser(hook.getSender().getName()).withTriggerPhrase(hook.getComment().getBody()).withSha(hook.getComment().getCommitId()).withPathWithNamespace(hook.getProject().getPathWithNamespace()).build();
        }
        return CauseDataBuilder.causeData().withActionType(CauseData.ActionType.NOTE).withSourceProjectId(hook.getPullRequest().getSourceProjectId()).withTargetProjectId(hook.getPullRequest().getTargetProjectId()).withBranch(hook.getPullRequest().getSourceBranch()).withSourceBranch(hook.getPullRequest().getSourceBranch()).withUserName(hook.getPullRequest().getHead().getUser().getName()).withUserEmail(hook.getPullRequest().getHead().getUser().getEmail()).withSourceRepoHomepage(hook.getPullRequest().getSource().getHomepage()).withSourceRepoName(hook.getPullRequest().getSource().getName()).withSourceNamespace(hook.getPullRequest().getSource().getNamespace()).withSourceRepoUrl(hook.getPullRequest().getSource().getUrl()).withSourceRepoSshUrl(hook.getPullRequest().getSource().getSshUrl()).withSourceRepoHttpUrl(hook.getPullRequest().getSource().getGitHttpUrl()).withPullRequestTitle(hook.getPullRequest().getTitle()).withPullRequestDescription(hook.getPullRequest().getBody()).withPullRequestId(hook.getPullRequest().getId()).withPullRequestIid(hook.getPullRequest().getNumber()).withPullRequestTargetProjectId(hook.getPullRequest().getTargetProjectId()).withTargetBranch(hook.getPullRequest().getTargetBranch()).withTargetRepoName(hook.getPullRequest().getTarget().getName()).withTargetNamespace(hook.getPullRequest().getTarget().getNamespace()).withTargetRepoSshUrl(hook.getPullRequest().getTarget().getSshUrl()).withTargetRepoHttpUrl(hook.getPullRequest().getTarget().getGitHttpUrl()).withTriggeredByUser(hook.getSender().getName()).withLastCommit(hook.getPullRequest().getMergeCommitSha()).withSha(hook.getPullRequest().getMergeCommitSha()).withAfter(hook.getPullRequest().getMergeCommitSha()).withRef(hook.getPullRequest().getMergeReferenceName()).withTargetProjectUrl(hook.getPullRequest().getTarget().getUrl()).withTriggerPhrase(hook.getComment().getBody()).withPathWithNamespace(hook.getPullRequest().getBase().getRepo().getPathWithNamespace()).withJsonBody(hook.getJsonBody()).withNoteBody(hook.getComment().getBody()).build();
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(NoteHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        if (gitSCM == null) {
            return new RevisionParameterAction(this.retrieveRevisionToBuild(hook));
        }
        URIish urIish = this.retrieveUrIish(hook);
        if (urIish == null) {
            return new RevisionParameterAction(this.retrieveRevisionToBuild2(hook));
        }
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook), urIish);
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(NoteHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getPullRequest().getSourceProjectId()).withSha(hook.getPullRequest().getMergeCommitSha()).withRef(hook.getPullRequest().getTargetBranch()).build();
    }

    private String retrieveRevisionToBuild(NoteHook hook) throws NoRevisionToBuildException {
        if (hook.getPullRequest() != null && hook.getPullRequest().getMergeCommitSha() != null) {
            return hook.getPullRequest().getMergeCommitSha();
        }
        return this.retrieveRevisionToBuild2(hook);
    }

    private String retrieveRevisionToBuild2(NoteHook hook) throws NoRevisionToBuildException {
        if (hook.getPullRequest() != null && hook.getPullRequest().getMergeReferenceName() != null) {
            return hook.getPullRequest().getMergeReferenceName();
        }
        if (hook.getComment() != null && StringUtils.isNotBlank((String)hook.getComment().getCommitId())) {
            return hook.getComment().getCommitId();
        }
        throw new NoRevisionToBuildException();
    }

    private boolean isValidTrigger(NoteHook hook) {
        return (this.triggerOnCommitComment && hook.getPullRequest() == null || this.triggerOnNoteRequest && hook.getPullRequest() != null) && this.isValidTriggerPhrase(hook.getComment().getBody()) && this.isValidTriggerAction(hook.getAction());
    }

    private boolean isValidTriggerAction(NoteAction action) {
        return action == NoteAction.comment;
    }

    private boolean isValidTriggerPhrase(String note) {
        if (StringUtils.isEmpty((String)this.noteRegex)) {
            return false;
        }
        Pattern pattern = Pattern.compile(this.noteRegex);
        return pattern.matcher(note).matches();
    }
}

