/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.gitee.hook.model;

import com.gitee.jenkins.gitee.hook.model.NoteAction;
import com.gitee.jenkins.gitee.hook.model.NoteObjectAttributes;
import com.gitee.jenkins.gitee.hook.model.Project;
import com.gitee.jenkins.gitee.hook.model.PullRequestObjectAttributes;
import com.gitee.jenkins.gitee.hook.model.User;
import com.gitee.jenkins.gitee.hook.model.WebHook;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@GeneratePojoBuilder(intoPackage="*.builder.generated", withFactoryMethod="*")
public class NoteHook
extends WebHook {
    private User user;
    private Project project;
    private PullRequestObjectAttributes pullRequest;
    private NoteObjectAttributes comment;
    private NoteAction action;

    public NoteAction getAction() {
        return this.action;
    }

    public void setAction(NoteAction action) {
        this.action = action;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public NoteObjectAttributes getComment() {
        return this.comment;
    }

    public void setComment(NoteObjectAttributes comment) {
        this.comment = comment;
    }

    public PullRequestObjectAttributes getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(PullRequestObjectAttributes pullRequest) {
        this.pullRequest = pullRequest;
    }

    @Override
    public String getWebHookDescription() {
        if (this.pullRequest == null) {
            return this.getHookName() + " commit sha = " + this.comment.getCommitId();
        }
        return this.getHookName() + " iid = " + this.pullRequest.getNumber() + " merge commit sha = " + this.pullRequest.getMergeCommitSha();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteHook that = (NoteHook)o;
        return new EqualsBuilder().append((Object)this.user, (Object)that.user).append((Object)this.action, (Object)that.action).append((Object)this.project, (Object)that.project).append((Object)this.comment, (Object)that.comment).append((Object)this.pullRequest, (Object)that.pullRequest).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.user).append((Object)this.action).append((Object)this.project).append((Object)this.comment).append((Object)this.pullRequest).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("user", (Object)this.user).append("action", (Object)this.action).append("project", (Object)this.project).append("comment", (Object)this.comment).append("pullRequest", (Object)this.pullRequest).toString();
    }
}

