/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.cause;

import com.gitee.jenkins.cause.Messages;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.markup.EscapedMarkupFormatter;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class CauseData {
    private final ActionType actionType;
    private final Integer sourceProjectId;
    private final Integer targetProjectId;
    private final String branch;
    private final String pathWithNamespace;
    private final String sourceBranch;
    private final String userName;
    private final String userEmail;
    private final String sourceRepoHomepage;
    private final String sourceRepoName;
    private final String sourceNamespace;
    private final String sourceRepoUrl;
    private final String sourceRepoSshUrl;
    private final String sourceRepoHttpUrl;
    private final String pullRequestTitle;
    private final String pullRequestDescription;
    private final Integer pullRequestId;
    private final Integer pullRequestIid;
    private final String pullRequestState;
    private final String mergedByUser;
    private final String pullRequestAssignee;
    private final Integer pullRequestTargetProjectId;
    private final String targetBranch;
    private final String targetRepoName;
    private final String targetNamespace;
    private final String targetRepoSshUrl;
    private final String targetRepoHttpUrl;
    private final String triggeredByUser;
    private final String before;
    private final String after;
    private final String lastCommit;
    private final String targetProjectUrl;
    private final String triggerPhrase;
    private final String ref;
    private final String beforeSha;
    private final String isTag;
    private final String sha;
    private final String status;
    private final String stages;
    private final String createdAt;
    private final String finishedAt;
    private final String buildDuration;
    private final String jsonBody;
    private final String noteBody;
    private final boolean created;
    private final boolean deleted;

    @GeneratePojoBuilder(withFactoryMethod="*")
    CauseData(ActionType actionType, Integer sourceProjectId, Integer targetProjectId, String branch, String sourceBranch, String userName, String userEmail, String sourceRepoHomepage, String sourceRepoName, String sourceNamespace, String sourceRepoUrl, String sourceRepoSshUrl, String sourceRepoHttpUrl, String pullRequestTitle, String pullRequestDescription, Integer pullRequestId, Integer pullRequestIid, Integer pullRequestTargetProjectId, String targetBranch, String targetRepoName, String targetNamespace, String targetRepoSshUrl, String targetRepoHttpUrl, String triggeredByUser, String before, String after, String lastCommit, String targetProjectUrl, String triggerPhrase, String pullRequestState, String mergedByUser, String pullRequestAssignee, String ref, String isTag, String sha, String beforeSha, String status, String stages, String createdAt, String finishedAt, String buildDuration, String pathWithNamespace, boolean created, boolean deleted, String jsonBody, String noteBody) {
        this.actionType = (ActionType)((Object)Preconditions.checkNotNull((Object)((Object)actionType), (Object)"actionType must not be null."));
        this.sourceProjectId = (Integer)Preconditions.checkNotNull((Object)sourceProjectId, (Object)"sourceProjectId must not be null.");
        this.targetProjectId = (Integer)Preconditions.checkNotNull((Object)targetProjectId, (Object)"targetProjectId must not be null.");
        this.branch = (String)Preconditions.checkNotNull((Object)branch, (Object)"branch must not be null.");
        this.sourceBranch = (String)Preconditions.checkNotNull((Object)sourceBranch, (Object)"sourceBranch must not be null.");
        this.userName = (String)Preconditions.checkNotNull((Object)userName, (Object)"userName must not be null.");
        this.userEmail = userEmail == null ? "" : userEmail;
        this.sourceRepoHomepage = sourceRepoHomepage == null ? "" : sourceRepoHomepage;
        this.sourceRepoName = (String)Preconditions.checkNotNull((Object)sourceRepoName, (Object)"sourceRepoName must not be null.");
        this.sourceNamespace = (String)Preconditions.checkNotNull((Object)sourceNamespace, (Object)"sourceNamespace must not be null.");
        this.sourceRepoUrl = sourceRepoUrl == null ? sourceRepoSshUrl : sourceRepoUrl;
        this.sourceRepoSshUrl = (String)Preconditions.checkNotNull((Object)sourceRepoSshUrl, (Object)"sourceRepoSshUrl must not be null.");
        this.sourceRepoHttpUrl = (String)Preconditions.checkNotNull((Object)sourceRepoHttpUrl, (Object)"sourceRepoHttpUrl must not be null.");
        this.pullRequestTitle = (String)Preconditions.checkNotNull((Object)pullRequestTitle, (Object)"pullRequestTitle must not be null.");
        this.pullRequestDescription = pullRequestDescription == null ? "" : pullRequestDescription;
        this.pullRequestId = pullRequestId;
        this.pullRequestIid = pullRequestIid;
        this.pullRequestState = pullRequestState == null ? "" : pullRequestState;
        this.mergedByUser = mergedByUser == null ? "" : mergedByUser;
        this.pullRequestAssignee = pullRequestAssignee == null ? "" : pullRequestAssignee;
        this.pullRequestTargetProjectId = pullRequestTargetProjectId;
        this.targetBranch = (String)Preconditions.checkNotNull((Object)targetBranch, (Object)"targetBranch must not be null.");
        this.targetRepoName = (String)Preconditions.checkNotNull((Object)targetRepoName, (Object)"targetRepoName must not be null.");
        this.targetNamespace = (String)Preconditions.checkNotNull((Object)targetNamespace, (Object)"targetNamespace must not be null.");
        this.targetRepoSshUrl = (String)Preconditions.checkNotNull((Object)targetRepoSshUrl, (Object)"targetRepoSshUrl must not be null.");
        this.targetRepoHttpUrl = (String)Preconditions.checkNotNull((Object)targetRepoHttpUrl, (Object)"targetRepoHttpUrl must not be null.");
        this.triggeredByUser = (String)Preconditions.checkNotNull((Object)triggeredByUser, (Object)"triggeredByUser must not be null.");
        this.before = before == null ? "" : before;
        this.after = after == null ? "" : after;
        this.lastCommit = lastCommit;
        this.targetProjectUrl = targetProjectUrl;
        this.triggerPhrase = triggerPhrase;
        this.ref = ref;
        this.isTag = isTag;
        this.sha = sha;
        this.beforeSha = beforeSha;
        this.status = status;
        this.stages = stages;
        this.createdAt = createdAt;
        this.finishedAt = finishedAt;
        this.buildDuration = buildDuration;
        this.pathWithNamespace = pathWithNamespace;
        this.created = created;
        this.deleted = deleted;
        this.jsonBody = jsonBody;
        this.noteBody = noteBody;
    }

    public Map<String, String> getBuildVariables() {
        MapWrapper<String, String> variables = new MapWrapper<String, String>(new HashMap());
        variables.put("giteeBranch", this.branch);
        variables.put("giteeSourceBranch", this.sourceBranch);
        variables.put("giteeActionType", this.actionType.name());
        variables.put("giteeUserName", this.userName);
        variables.put("giteeUserEmail", this.userEmail);
        variables.put("giteeSourceRepoHomepage", this.sourceRepoHomepage);
        variables.put("giteeSourceRepoName", this.sourceRepoName);
        variables.put("giteeSourceNamespace", this.sourceNamespace);
        variables.put("giteeSourceRepoURL", this.sourceRepoUrl);
        variables.put("giteeSourceRepoSshUrl", this.sourceRepoSshUrl);
        variables.put("giteeSourceRepoHttpUrl", this.sourceRepoHttpUrl);
        variables.put("giteePullRequestTitle", this.pullRequestTitle);
        variables.put("giteePullRequestDescription", this.pullRequestDescription);
        variables.put("giteePullRequestId", this.pullRequestId == null ? "" : this.pullRequestId.toString());
        variables.put("giteePullRequestIid", this.pullRequestIid == null ? "" : this.pullRequestIid.toString());
        variables.put("giteePullRequestTargetProjectId", this.pullRequestTargetProjectId == null ? "" : this.pullRequestTargetProjectId.toString());
        variables.put("giteePullRequestLastCommit", this.lastCommit);
        variables.put("giteePushCreated", this.created ? "true" : "false");
        variables.put("giteePushDeleted", this.deleted ? "true" : "false");
        variables.putIfNotNull("giteePullRequestState", this.pullRequestState);
        variables.putIfNotNull("giteeMergedByUser", this.mergedByUser);
        variables.putIfNotNull("giteePullRequestAssignee", this.pullRequestAssignee);
        variables.put("giteeTargetBranch", this.targetBranch);
        variables.put("giteeTargetRepoName", this.targetRepoName);
        variables.put("giteeTargetNamespace", this.targetNamespace);
        variables.put("giteeTargetRepoSshUrl", this.targetRepoSshUrl);
        variables.put("giteeTargetRepoHttpUrl", this.targetRepoHttpUrl);
        variables.put("giteeBefore", this.before);
        variables.put("giteeAfter", this.after);
        variables.put("giteeBeforeCommitSha", this.before);
        variables.put("giteeAfterCommitSha", this.after);
        variables.put("giteeRef", this.ref);
        variables.put("ref", this.ref);
        variables.put("beforeSha", this.beforeSha);
        variables.put("isTag", this.isTag);
        variables.put("sha", this.sha);
        variables.put("status", this.status);
        variables.put("stages", this.stages);
        variables.put("createdAt", this.createdAt);
        variables.put("finishedAt", this.finishedAt);
        variables.put("duration", this.buildDuration);
        variables.put("jsonBody", this.jsonBody);
        variables.put("noteBody", this.noteBody);
        variables.putIfNotNull("giteeTriggerPhrase", this.triggerPhrase);
        return variables;
    }

    public Integer getSourceProjectId() {
        return this.sourceProjectId;
    }

    public Integer getTargetProjectId() {
        return this.targetProjectId;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getSourceRepoHomepage() {
        return this.sourceRepoHomepage;
    }

    public String getSourceRepoName() {
        return this.sourceRepoName;
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public String getSourceRepoUrl() {
        return this.sourceRepoUrl;
    }

    public String getSourceRepoSshUrl() {
        return this.sourceRepoSshUrl;
    }

    public String getSourceRepoHttpUrl() {
        return this.sourceRepoHttpUrl;
    }

    public String getPullRequestTitle() {
        return this.pullRequestTitle;
    }

    public String getPullRequestDescription() {
        return this.pullRequestDescription;
    }

    public String getPathWithNamespace() {
        return this.pathWithNamespace;
    }

    public Integer getPullRequestId() {
        return this.pullRequestId;
    }

    public Integer getPullRequestIid() {
        return this.pullRequestIid;
    }

    public Integer getPullRequestTargetProjectId() {
        return this.pullRequestTargetProjectId;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public String getTargetRepoName() {
        return this.targetRepoName;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetRepoSshUrl() {
        return this.targetRepoSshUrl;
    }

    public String getTargetRepoHttpUrl() {
        return this.targetRepoHttpUrl;
    }

    public String getTriggeredByUser() {
        return this.triggeredByUser;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public String getLastCommit() {
        return this.lastCommit;
    }

    public String getTargetProjectUrl() {
        return this.targetProjectUrl;
    }

    public String getRef() {
        return this.ref;
    }

    public String getIsTag() {
        return this.isTag;
    }

    public String getSha() {
        return this.sha;
    }

    public String getBeforeSha() {
        return this.beforeSha;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStages() {
        return this.stages;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getFinishedAt() {
        return this.finishedAt;
    }

    public String getBuildDuration() {
        return this.buildDuration;
    }

    public String getJsonBody() {
        return this.jsonBody;
    }

    public String getNoteBody() {
        return this.noteBody;
    }

    String getShortDescription() {
        return this.actionType.getShortDescription(this);
    }

    public String getPullRequestState() {
        return this.pullRequestState;
    }

    public String getMergedByUser() {
        return this.mergedByUser;
    }

    public String getPullRequestAssignee() {
        return this.pullRequestAssignee;
    }

    public boolean getCreated() {
        return this.created;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public PullRequest getPullRequest() {
        if (this.pullRequestId == null) {
            return null;
        }
        return new PullRequest(this.pullRequestId, this.pullRequestIid, this.sourceBranch, this.targetBranch, this.pullRequestTitle, this.sourceProjectId, this.targetProjectId, this.pullRequestDescription, this.pullRequestState, this.pathWithNamespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CauseData causeData = (CauseData)o;
        return new EqualsBuilder().append((Object)this.actionType, (Object)causeData.actionType).append((Object)this.sourceProjectId, (Object)causeData.sourceProjectId).append((Object)this.targetProjectId, (Object)causeData.targetProjectId).append((Object)this.branch, (Object)causeData.branch).append((Object)this.sourceBranch, (Object)causeData.sourceBranch).append((Object)this.userName, (Object)causeData.userName).append((Object)this.userEmail, (Object)causeData.userEmail).append((Object)this.sourceRepoHomepage, (Object)causeData.sourceRepoHomepage).append((Object)this.sourceRepoName, (Object)causeData.sourceRepoName).append((Object)this.sourceNamespace, (Object)causeData.sourceNamespace).append((Object)this.sourceRepoUrl, (Object)causeData.sourceRepoUrl).append((Object)this.sourceRepoSshUrl, (Object)causeData.sourceRepoSshUrl).append((Object)this.sourceRepoHttpUrl, (Object)causeData.sourceRepoHttpUrl).append((Object)this.pullRequestTitle, (Object)causeData.pullRequestTitle).append((Object)this.pullRequestDescription, (Object)causeData.pullRequestDescription).append((Object)this.pullRequestId, (Object)causeData.pullRequestId).append((Object)this.pullRequestIid, (Object)causeData.pullRequestIid).append((Object)this.pullRequestState, (Object)causeData.pullRequestState).append((Object)this.mergedByUser, (Object)causeData.mergedByUser).append((Object)this.pullRequestAssignee, (Object)causeData.pullRequestAssignee).append((Object)this.pullRequestTargetProjectId, (Object)causeData.pullRequestTargetProjectId).append((Object)this.targetBranch, (Object)causeData.targetBranch).append((Object)this.targetRepoName, (Object)causeData.targetRepoName).append((Object)this.targetNamespace, (Object)causeData.targetNamespace).append((Object)this.targetRepoSshUrl, (Object)causeData.targetRepoSshUrl).append((Object)this.targetRepoHttpUrl, (Object)causeData.targetRepoHttpUrl).append((Object)this.triggeredByUser, (Object)causeData.triggeredByUser).append((Object)this.before, (Object)causeData.before).append((Object)this.after, (Object)causeData.after).append((Object)this.lastCommit, (Object)causeData.lastCommit).append((Object)this.targetProjectUrl, (Object)causeData.targetProjectUrl).append((Object)this.ref, (Object)causeData.getRef()).append((Object)this.isTag, (Object)causeData.getIsTag()).append((Object)this.sha, (Object)causeData.getSha()).append((Object)this.beforeSha, (Object)causeData.getBeforeSha()).append((Object)this.status, (Object)causeData.getStatus()).append((Object)this.stages, (Object)causeData.getStages()).append((Object)this.createdAt, (Object)causeData.getCreatedAt()).append((Object)this.finishedAt, (Object)causeData.getFinishedAt()).append((Object)this.buildDuration, (Object)causeData.getBuildDuration()).append((Object)this.pathWithNamespace, (Object)causeData.getPathWithNamespace()).append(this.created, causeData.getCreated()).append(this.deleted, causeData.getDeleted()).append((Object)this.jsonBody, (Object)causeData.getJsonBody()).append((Object)this.noteBody, (Object)causeData.getNoteBody()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.actionType).append((Object)this.sourceProjectId).append((Object)this.targetProjectId).append((Object)this.branch).append((Object)this.sourceBranch).append((Object)this.userName).append((Object)this.userEmail).append((Object)this.sourceRepoHomepage).append((Object)this.sourceRepoName).append((Object)this.sourceNamespace).append((Object)this.sourceRepoUrl).append((Object)this.sourceRepoSshUrl).append((Object)this.sourceRepoHttpUrl).append((Object)this.pullRequestTitle).append((Object)this.pullRequestDescription).append((Object)this.pullRequestId).append((Object)this.pullRequestIid).append((Object)this.pullRequestState).append((Object)this.mergedByUser).append((Object)this.pullRequestAssignee).append((Object)this.pullRequestTargetProjectId).append((Object)this.targetBranch).append((Object)this.targetRepoName).append((Object)this.targetNamespace).append((Object)this.targetRepoSshUrl).append((Object)this.targetRepoHttpUrl).append((Object)this.triggeredByUser).append((Object)this.before).append((Object)this.after).append((Object)this.lastCommit).append((Object)this.targetProjectUrl).append((Object)this.ref).append((Object)this.isTag).append((Object)this.sha).append((Object)this.beforeSha).append((Object)this.status).append((Object)this.stages).append((Object)this.createdAt).append((Object)this.finishedAt).append((Object)this.buildDuration).append((Object)this.pathWithNamespace).append(this.created).append(this.deleted).append((Object)this.jsonBody).append((Object)this.noteBody).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("actionType", (Object)this.actionType).append("sourceProjectId", (Object)this.sourceProjectId).append("targetProjectId", (Object)this.targetProjectId).append("branch", (Object)this.branch).append("sourceBranch", (Object)this.sourceBranch).append("userName", (Object)this.userName).append("userEmail", (Object)this.userEmail).append("sourceRepoHomepage", (Object)this.sourceRepoHomepage).append("sourceRepoName", (Object)this.sourceRepoName).append("sourceNamespace", (Object)this.sourceNamespace).append("sourceRepoUrl", (Object)this.sourceRepoUrl).append("sourceRepoSshUrl", (Object)this.sourceRepoSshUrl).append("sourceRepoHttpUrl", (Object)this.sourceRepoHttpUrl).append("pullRequestTitle", (Object)this.pullRequestTitle).append("pullRequestDescription", (Object)this.pullRequestDescription).append("pullRequestId", (Object)this.pullRequestId).append("pullRequestIid", (Object)this.pullRequestIid).append("pullRequestState", (Object)this.pullRequestState).append("mergedByUser", (Object)this.mergedByUser).append("pullRequestAssignee", (Object)this.pullRequestAssignee).append("pullRequestTargetProjectId", (Object)this.pullRequestTargetProjectId).append("targetBranch", (Object)this.targetBranch).append("targetRepoName", (Object)this.targetRepoName).append("targetNamespace", (Object)this.targetNamespace).append("targetRepoSshUrl", (Object)this.targetRepoSshUrl).append("targetRepoHttpUrl", (Object)this.targetRepoHttpUrl).append("triggeredByUser", (Object)this.triggeredByUser).append("before", (Object)this.before).append("after", (Object)this.after).append("lastCommit", (Object)this.lastCommit).append("targetProjectUrl", (Object)this.targetProjectUrl).append("ref", (Object)this.ref).append("isTag", (Object)this.isTag).append("sha", (Object)this.sha).append("beforeSha", (Object)this.beforeSha).append("status", (Object)this.status).append("stages", (Object)this.stages).append("createdAt", (Object)this.createdAt).append("finishedAt", (Object)this.finishedAt).append("duration", (Object)this.buildDuration).append("pathWithNamespace", (Object)this.pathWithNamespace).append("created", this.created).append("deleted", this.deleted).append("jsonBody", (Object)this.jsonBody).append("noteBody", (Object)this.noteBody).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ActionType {
        PUSH{

            @Override
            String getShortDescription(CauseData data) {
                return ActionType.getShortDescriptionPush(data);
            }
        }
        ,
        TAG_PUSH{

            @Override
            String getShortDescription(CauseData data) {
                return ActionType.getShortDescriptionPush(data);
            }
        }
        ,
        MERGE{

            @Override
            String getShortDescription(CauseData data) {
                String forkNamespace;
                String string = forkNamespace = StringUtils.equals((String)data.getSourceNamespace(), (String)data.getTargetBranch()) ? "" : data.getSourceNamespace() + "/";
                if (Jenkins.get().getMarkupFormatter() instanceof EscapedMarkupFormatter || data.getTargetProjectUrl() == null) {
                    return Messages.GiteeWebHookCause_ShortDescription_PullRequestHook_plain(String.valueOf(data.getPullRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch());
                }
                return Messages.GiteeWebHookCause_ShortDescription_PullRequestHook_html(String.valueOf(data.getPullRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch(), data.getTargetProjectUrl());
            }
        }
        ,
        NOTE{

            @Override
            String getShortDescription(CauseData data) {
                String forkNamespace;
                String triggeredBy = data.getTriggeredByUser();
                String string = forkNamespace = StringUtils.equals((String)data.getSourceNamespace(), (String)data.getTargetBranch()) ? "" : data.getSourceNamespace() + "/";
                if (Jenkins.get().getMarkupFormatter() instanceof EscapedMarkupFormatter || data.getTargetProjectUrl() == null) {
                    return Messages.GiteeWebHookCause_ShortDescription_NoteHook_plain(triggeredBy, String.valueOf(data.getPullRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch());
                }
                return Messages.GiteeWebHookCause_ShortDescription_NoteHook_html(triggeredBy, String.valueOf(data.getPullRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch(), data.getTargetProjectUrl());
            }
        }
        ,
        COMMIT_COMMENT{

            @Override
            String getShortDescription(CauseData data) {
                return Messages.GiteeWebHookCause_ShortDescription_Commit_comment(data.getTriggeredByUser());
            }
        }
        ,
        PIPELINE{

            @Override
            String getShortDescription(CauseData data) {
                String getStatus = data.getStatus();
                if (getStatus == null) {
                    return Messages.GiteeWebHookCause_ShortDescription_PipelineHook_noStatus();
                }
                return Messages.GiteeWebHookCause_ShortDescription_PipelineHook(getStatus);
            }
        };


        private static String getShortDescriptionPush(CauseData data) {
            String pushedBy = data.getTriggeredByUser();
            if (pushedBy == null) {
                return Messages.GiteeWebHookCause_ShortDescription_PushHook_noUser();
            }
            return Messages.GiteeWebHookCause_ShortDescription_PushHook(pushedBy);
        }

        abstract String getShortDescription(CauseData var1);
    }

    private static class MapWrapper<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> map;

        MapWrapper(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        @NonNull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        void putIfNotNull(K key, V value) {
            if (value != null) {
                this.map.put(key, value);
            }
        }
    }
}

