/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.workflow;

import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class AcceptGiteePullRequestStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(AcceptGiteePullRequestStep.class.getName());
    private String mergeCommitMessage;

    @DataBoundConstructor
    public AcceptGiteePullRequestStep(String mergeCommitMessage) {
        this.mergeCommitMessage = StringUtils.isEmpty((String)mergeCommitMessage) ? null : mergeCommitMessage;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new AcceptGiteePullRequestStepExecution(context, this);
    }

    public String getMergeCommitMessage() {
        return this.mergeCommitMessage;
    }

    @DataBoundSetter
    public void setMergeCommitMessage(String mergeCommitMessage) {
        this.mergeCommitMessage = StringUtils.isEmpty((String)mergeCommitMessage) ? null : mergeCommitMessage;
    }

    public static class AcceptGiteePullRequestStepExecution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient AcceptGiteePullRequestStep step;

        AcceptGiteePullRequestStepExecution(StepContext context, AcceptGiteePullRequestStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        protected Void run() throws Exception {
            PullRequest pullRequest;
            GiteeWebHookCause cause = (GiteeWebHookCause)this.run.getCause(GiteeWebHookCause.class);
            if (cause != null && (pullRequest = cause.getData().getPullRequest()) != null) {
                GiteeClient client = GiteeConnectionProperty.getClient(this.run);
                if (client == null) {
                    this.println("No Gitee connection configured");
                } else {
                    try {
                        client.acceptPullRequest(pullRequest, this.step.mergeCommitMessage, false);
                    }
                    catch (ProcessingException | WebApplicationException e) {
                        this.printf("Failed to accept pull request for project '%s': %s%n", pullRequest.getProjectId(), e.getMessage());
                        LOGGER.log(Level.SEVERE, String.format("Failed to accept pull request for project '%s'", pullRequest.getProjectId()), e);
                    }
                }
            }
            return null;
        }

        private void println(String message) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", message);
            } else {
                listener.getLogger().println(message);
            }
        }

        private void printf(String message, Object ... args) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", String.format(message, args));
            } else {
                listener.getLogger().printf(message, args);
            }
        }

        private TaskListener getTaskListener() {
            StepContext context = this.getContext();
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Accept Gitee Pull Request";
        }

        public String getFunctionName() {
            return "acceptGiteeMR";
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }
    }
}

