/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.handler.pull;

import com.gitee.jenkins.cause.CauseData;
import com.gitee.jenkins.cause.CauseDataBuilder;
import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.gitee.hook.model.Action;
import com.gitee.jenkins.gitee.hook.model.ActionDesc;
import com.gitee.jenkins.gitee.hook.model.PullRequestHook;
import com.gitee.jenkins.gitee.hook.model.PullRequestLabel;
import com.gitee.jenkins.gitee.hook.model.PullRequestObjectAttributes;
import com.gitee.jenkins.gitee.hook.model.State;
import com.gitee.jenkins.publisher.GiteeMessagePublisher;
import com.gitee.jenkins.trigger.exception.NoRevisionToBuildException;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BuildInstructionFilter;
import com.gitee.jenkins.trigger.filter.PullRequestLabelFilter;
import com.gitee.jenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.gitee.jenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.gitee.jenkins.trigger.handler.pull.PullRequestHookTriggerHandler;
import com.gitee.jenkins.util.BuildUtil;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;

class PullRequestHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<PullRequestHook>
implements PullRequestHookTriggerHandler {
    private static final Logger LOGGER = Logger.getLogger(PullRequestHookTriggerHandlerImpl.class.getName());
    private final Collection<State> allowedStates;
    private final boolean skipWorkInProgressPullRequest;
    private final boolean ciSkipFroTestNotRequired;
    private final Collection<Action> allowedActions;
    private final Collection<ActionDesc> allowedActionDesces;
    private final boolean cancelPendingBuildsOnUpdate;
    private final boolean cancelIncompleteBuildOnSamePullRequest;
    private boolean ignorePullRequestConflicts;

    PullRequestHookTriggerHandlerImpl(Collection<State> allowedStates, boolean skipWorkInProgressPullRequest, boolean cancelPendingBuildsOnUpdate, boolean ciSkipFroTestNotRequired, boolean cancelIncompleteBuildOnSamePullRequest, boolean ignorePullRequestConflicts) {
        this(allowedStates, EnumSet.allOf(Action.class), EnumSet.allOf(ActionDesc.class), skipWorkInProgressPullRequest, cancelPendingBuildsOnUpdate, ciSkipFroTestNotRequired, cancelIncompleteBuildOnSamePullRequest, ignorePullRequestConflicts);
    }

    PullRequestHookTriggerHandlerImpl(Collection<State> allowedStates, Collection<Action> allowedActions, Collection<ActionDesc> allowedActionDesces, boolean skipWorkInProgressPullRequest, boolean cancelPendingBuildsOnUpdate, boolean ciSkipFroTestNotRequired, boolean cancelIncompleteBuildOnSamePullRequest, boolean ignorePullRequestConflicts) {
        this.allowedStates = allowedStates;
        this.allowedActions = allowedActions;
        this.allowedActionDesces = allowedActionDesces;
        this.skipWorkInProgressPullRequest = skipWorkInProgressPullRequest;
        this.cancelPendingBuildsOnUpdate = cancelPendingBuildsOnUpdate;
        this.ciSkipFroTestNotRequired = ciSkipFroTestNotRequired;
        this.cancelIncompleteBuildOnSamePullRequest = cancelIncompleteBuildOnSamePullRequest;
        this.ignorePullRequestConflicts = ignorePullRequestConflicts;
    }

    @Override
    public void handle(Job<?, ?> job, PullRequestHook hook, BuildInstructionFilter buildInstructionFilter, boolean skipLastCommitHasBeenBuild, BranchFilter branchFilter, PullRequestLabelFilter pullRequestLabelFilter) {
        PullRequestObjectAttributes objectAttributes = hook.getPullRequest();
        try {
            LOGGER.log(Level.INFO, "request hook  state=" + String.valueOf((Object)hook.getState()) + ", action = " + String.valueOf((Object)hook.getAction()) + " pr iid = " + objectAttributes.getNumber() + " hook name = " + hook.getHookName());
            if (this.isAllowedByConfig(hook) && this.isNotSkipWorkInProgressPullRequest(objectAttributes)) {
                ArrayList<String> labelsNames = new ArrayList<String>();
                if (hook.getLabels() != null) {
                    for (PullRequestLabel label : hook.getLabels()) {
                        labelsNames.add(label.getTitle());
                    }
                }
                if (!this.ignorePullRequestConflicts && !objectAttributes.isMergeable()) {
                    LOGGER.log(Level.INFO, "This pull request can not be merge");
                    GiteeMessagePublisher publisher = GiteeMessagePublisher.getFromJob(job);
                    GiteeClient client = GiteeConnectionProperty.getClient(job);
                    if (publisher != null && client != null) {
                        PullRequest pullRequest = new PullRequest(objectAttributes);
                        LOGGER.log(Level.INFO, "sending message to gitee.....");
                        client.createPullRequestNote(pullRequest, ":bangbang: This pull request can not be merge! The build will not be triggered. Please manual merge conflict.");
                    }
                    return;
                }
                if (this.ciSkipFroTestNotRequired && !objectAttributes.getNeedTest()) {
                    LOGGER.log(Level.INFO, "Skip because this pull don't need test.");
                    return;
                }
                if (pullRequestLabelFilter.isPullRequestAllowed(labelsNames)) {
                    super.handle(job, hook, buildInstructionFilter, skipLastCommitHasBeenBuild, branchFilter, pullRequestLabelFilter);
                }
            } else {
                LOGGER.log(Level.INFO, "request is not allow, hook state=" + String.valueOf((Object)hook.getState()) + ", action = " + String.valueOf((Object)hook.getAction()) + ", action desc = " + String.valueOf((Object)hook.getActionDesc()));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "request is not allow, hook ----- #" + String.valueOf(hook));
            throw e;
        }
    }

    @Override
    protected boolean isCiSkip(PullRequestHook hook, BuildInstructionFilter buildInstructionFilter) {
        if (buildInstructionFilter != null && hook.getPullRequest() != null) {
            return !buildInstructionFilter.isBuildAllow(hook.getPullRequest().getBody());
        }
        return false;
    }

    @Override
    protected boolean isCommitSkip(Job<?, ?> project, PullRequestHook hook) {
        Run<?, ?> mergeBuild;
        PullRequestObjectAttributes objectAttributes = hook.getPullRequest();
        if (objectAttributes != null && objectAttributes.getMergeCommitSha() != null && (mergeBuild = BuildUtil.getBuildBySHA1IncludingMergeBuilds(project, objectAttributes.getMergeCommitSha())) != null && StringUtils.equals((String)this.getTargetBranchFromBuild(mergeBuild), (String)objectAttributes.getTargetBranch())) {
            LOGGER.log(Level.INFO, "Last commit in Pull Request has already been built in build #" + mergeBuild.getNumber());
            return true;
        }
        return false;
    }

    @Override
    protected void cancelPendingBuildsIfNecessary(Job<?, ?> job, PullRequestHook hook) {
        if (!this.cancelPendingBuildsOnUpdate) {
            return;
        }
        if (!hook.getAction().equals((Object)Action.update)) {
            return;
        }
        this.pendingBuildsHandler.cancelPendingBuilds(job, hook.getPullRequest().getSourceProjectId(), hook.getPullRequest().getSourceBranch());
    }

    @Override
    protected void cancelIncompleteBuildIfNecessary(Job<?, ?> job, PullRequestHook hook) {
        if (!this.cancelIncompleteBuildOnSamePullRequest) {
            return;
        }
        for (Run build : job.getBuilds()) {
            CauseData causeData;
            if (!job.isBuilding()) break;
            if (!build.isBuilding()) continue;
            CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
            GiteeWebHookCause giteeWebHookCause = null;
            for (Cause cause : causeAction.getCauses()) {
                if (!(cause instanceof GiteeWebHookCause)) continue;
                giteeWebHookCause = (GiteeWebHookCause)cause;
                break;
            }
            if (giteeWebHookCause == null || !(causeData = giteeWebHookCause.getData()).getSourceRepoHttpUrl().equals(hook.getPullRequest().getSource().getGitHttpUrl()) || !causeData.getTargetRepoHttpUrl().equals(hook.getPullRequest().getTarget().getGitHttpUrl()) || !causeData.getRef().equals(hook.getPullRequest().getMergeReferenceName())) continue;
            try {
                this.doStop(build);
            }
            catch (ServletException | IOException e) {
                LOGGER.log(Level.WARNING, "Unable to abort incomplete build", e);
            }
        }
    }

    @Override
    protected String getTargetBranch(PullRequestHook hook) {
        return hook.getPullRequest() == null ? null : hook.getPullRequest().getTargetBranch();
    }

    @Override
    protected String getTriggerType() {
        return "pull request";
    }

    @Override
    protected CauseData retrieveCauseData(PullRequestHook hook) {
        return CauseDataBuilder.causeData().withActionType(CauseData.ActionType.MERGE).withSourceProjectId(hook.getPullRequest().getSourceProjectId()).withTargetProjectId(hook.getPullRequest().getTargetProjectId()).withBranch(hook.getPullRequest().getSourceBranch()).withSourceBranch(hook.getPullRequest().getSourceBranch()).withUserName(hook.getPullRequest().getHead().getUser().getName()).withUserEmail(hook.getPullRequest().getHead().getUser().getEmail()).withSourceRepoHomepage(hook.getPullRequest().getSource().getHomepage()).withSourceRepoName(hook.getPullRequest().getSource().getName()).withSourceNamespace(hook.getPullRequest().getSource().getNamespace()).withSourceRepoUrl(hook.getPullRequest().getSource().getUrl()).withSourceRepoSshUrl(hook.getPullRequest().getSource().getSshUrl()).withSourceRepoHttpUrl(hook.getPullRequest().getSource().getGitHttpUrl()).withPullRequestTitle(hook.getPullRequest().getTitle()).withPullRequestDescription(hook.getPullRequest().getBody()).withPullRequestId(hook.getPullRequest().getId()).withPullRequestIid(hook.getPullRequest().getNumber()).withPullRequestState(hook.getState().toString()).withMergedByUser(hook.getUser() == null ? null : hook.getUser().getUsername()).withPullRequestAssignee(hook.getAssignee() == null ? null : hook.getAssignee().getUsername()).withPullRequestTargetProjectId(hook.getPullRequest().getTargetProjectId()).withTargetBranch(hook.getPullRequest().getTargetBranch()).withTargetRepoName(hook.getPullRequest().getTarget().getName()).withTargetNamespace(hook.getPullRequest().getTarget().getNamespace()).withTargetRepoSshUrl(hook.getPullRequest().getTarget().getSshUrl()).withTargetRepoHttpUrl(hook.getPullRequest().getTarget().getGitHttpUrl()).withTriggeredByUser(hook.getSender().getName()).withLastCommit(hook.getPullRequest().getMergeCommitSha()).withSha(hook.getPullRequest().getMergeCommitSha()).withAfter(hook.getPullRequest().getMergeCommitSha()).withRef(hook.getPullRequest().getMergeReferenceName()).withTargetProjectUrl(hook.getPullRequest().getTarget().getUrl()).withPathWithNamespace(hook.getRepo().getPathWithNamespace()).withJsonBody(hook.getJsonBody()).build();
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(PullRequestHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        if (gitSCM == null) {
            return new RevisionParameterAction(this.retrieveRevisionToBuild(hook));
        }
        URIish urIish = this.retrieveUrIish(hook);
        if (urIish == null) {
            return new RevisionParameterAction(this.retrieveRevisionToBuild2(hook));
        }
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook), urIish);
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(PullRequestHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getPullRequest().getSourceProjectId()).withSha(hook.getPullRequest().getMergeCommitSha()).withRef(hook.getPullRequest().getSourceBranch()).build();
    }

    private String retrieveRevisionToBuild(PullRequestHook hook) throws NoRevisionToBuildException {
        if (hook.getPullRequest() != null && hook.getPullRequest().getMergeCommitSha() != null) {
            return hook.getPullRequest().getMergeCommitSha();
        }
        return this.retrieveRevisionToBuild2(hook);
    }

    private String retrieveRevisionToBuild2(PullRequestHook hook) throws NoRevisionToBuildException {
        if (hook.getPullRequest() != null && hook.getPullRequest().getMergeReferenceName() != null) {
            return hook.getPullRequest().getMergeReferenceName();
        }
        throw new NoRevisionToBuildException();
    }

    private String getTargetBranchFromBuild(Run<?, ?> mergeBuild) {
        GiteeWebHookCause cause = (GiteeWebHookCause)mergeBuild.getCause(GiteeWebHookCause.class);
        return cause == null ? null : cause.getData().getTargetBranch();
    }

    private boolean isAllowedByConfig(PullRequestHook hook) {
        return this.allowedStates.contains((Object)hook.getState()) && this.allowedActions.contains((Object)hook.getAction()) && (hook.getAction() != Action.update || this.allowedActionDesces.contains((Object)hook.getActionDesc()));
    }

    private boolean isNotSkipWorkInProgressPullRequest(PullRequestObjectAttributes objectAttributes) {
        return true;
    }
}

