/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.handler;

import com.gitee.jenkins.cause.CauseData;
import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.util.LoggerUtil;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class PendingBuildsHandler {
    private static final Logger LOGGER = Logger.getLogger(PendingBuildsHandler.class.getName());

    public void cancelPendingBuilds(Job<?, ?> job, Integer projectId, String branch) {
        Queue queue = Jenkins.get().getQueue();
        for (Queue.Item item : queue.getItems()) {
            CauseData queueItemCauseData;
            GiteeWebHookCause queueItemGiteeWebHookCause;
            if (!job.getName().equals(item.task.getName()) || (queueItemGiteeWebHookCause = this.getGiteeWebHookCauseData(item)) == null || !projectId.equals((queueItemCauseData = queueItemGiteeWebHookCause.getData()).getSourceProjectId()) || !branch.equals(queueItemCauseData.getBranch())) continue;
            this.cancel(item, queue, branch);
        }
    }

    private GiteeWebHookCause getGiteeWebHookCauseData(Queue.Item item) {
        for (Cause cause : item.getCauses()) {
            if (!(cause instanceof GiteeWebHookCause)) continue;
            GiteeWebHookCause webHookCause = (GiteeWebHookCause)cause;
            return webHookCause;
        }
        return null;
    }

    private void cancel(Queue.Item item, Queue queue, String branch) {
        try {
            LOGGER.log(Level.INFO, "Cancelling job {0} for branch {1}", LoggerUtil.toArray(item.task.getName(), branch));
            queue.cancel(item);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error cancelling queued build", e);
        }
    }
}

