/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.trigger.filter;

import com.gitee.jenkins.trigger.filter.AllBranchesFilter;
import com.gitee.jenkins.trigger.filter.BranchFilter;
import com.gitee.jenkins.trigger.filter.BranchFilterConfig;
import com.gitee.jenkins.trigger.filter.BranchFilterType;
import com.gitee.jenkins.trigger.filter.NameBasedFilter;
import com.gitee.jenkins.trigger.filter.RegexBasedFilter;

public final class BranchFilterFactory {
    private BranchFilterFactory() {
    }

    public static BranchFilter newBranchFilter(BranchFilterConfig config) {
        if (config == null) {
            return new AllBranchesFilter();
        }
        return switch (config.getType()) {
            case BranchFilterType.NameBasedFilter -> new NameBasedFilter(config.getIncludeBranchesSpec(), config.getExcludeBranchesSpec());
            case BranchFilterType.RegexBasedFilter -> new RegexBasedFilter(config.getTargetBranchRegex());
            default -> new AllBranchesFilter();
        };
    }
}

