/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.cause.GiteeWebHookCause;
import com.gitee.jenkins.connection.GiteeConnectionProperty;
import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;

public abstract class PullRequestNotifier
extends Notifier
implements MatrixAggregatable {
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        GiteeClient client = GiteeConnectionProperty.getClient(build);
        if (client == null) {
            listener.getLogger().println("No Gitee connection configured");
            return true;
        }
        PullRequest pullRequest = this.getPullRequest((Run<?, ?>)build);
        if (pullRequest != null) {
            this.perform((Run<?, ?>)build, (TaskListener)listener, client, pullRequest);
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                PullRequestNotifier.this.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                return super.endBuild();
            }
        };
    }

    protected abstract void perform(Run<?, ?> var1, TaskListener var2, GiteeClient var3, PullRequest var4);

    PullRequest getPullRequest(Run<?, ?> run) {
        GiteeWebHookCause cause = (GiteeWebHookCause)run.getCause(GiteeWebHookCause.class);
        return cause == null ? null : cause.getData().getPullRequest();
    }
}

