/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.publisher;

import com.gitee.jenkins.gitee.api.GiteeClient;
import com.gitee.jenkins.gitee.api.model.PullRequest;
import com.gitee.jenkins.publisher.Messages;
import com.gitee.jenkins.publisher.PullRequestNotifier;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GiteeMessagePublisher
extends PullRequestNotifier {
    private static final Logger LOGGER = Logger.getLogger(GiteeMessagePublisher.class.getName());
    private boolean onlyForFailure = false;
    private boolean replaceSuccessNote = false;
    private boolean replaceFailureNote = false;
    private boolean replaceAbortNote = false;
    private boolean replaceUnstableNote = false;
    private String successNoteText;
    private String failureNoteText;
    private String abortNoteText;
    private String unstableNoteText;

    @Deprecated
    public GiteeMessagePublisher(boolean onlyForFailure, boolean replaceSuccessNote, boolean replaceFailureNote, boolean replaceAbortNote, boolean replaceUnstableNote, String successNoteText, String failureNoteText, String abortNoteText, String unstableNoteText) {
        this.onlyForFailure = onlyForFailure;
        this.replaceSuccessNote = replaceSuccessNote;
        this.replaceFailureNote = replaceFailureNote;
        this.replaceAbortNote = replaceAbortNote;
        this.replaceUnstableNote = replaceUnstableNote;
        this.successNoteText = successNoteText;
        this.failureNoteText = failureNoteText;
        this.abortNoteText = abortNoteText;
        this.unstableNoteText = unstableNoteText;
    }

    @DataBoundConstructor
    public GiteeMessagePublisher() {
    }

    public static GiteeMessagePublisher getFromJob(Job<?, ?> job) {
        GiteeMessagePublisher publisher = null;
        if (job instanceof AbstractProject) {
            AbstractProject p = (AbstractProject)job;
            Map map = p.getPublishersList().toMap();
            for (Publisher n : map.values()) {
                GiteeMessagePublisher giteePublisher;
                if (!(n instanceof GiteeMessagePublisher)) continue;
                publisher = giteePublisher = (GiteeMessagePublisher)n;
            }
        }
        return publisher;
    }

    public boolean isOnlyForFailure() {
        return this.onlyForFailure;
    }

    public boolean isReplaceSuccessNote() {
        return this.replaceSuccessNote;
    }

    public boolean isReplaceFailureNote() {
        return this.replaceFailureNote;
    }

    public boolean isReplaceAbortNote() {
        return this.replaceAbortNote;
    }

    public boolean isReplaceUnstableNote() {
        return this.replaceUnstableNote;
    }

    public String getSuccessNoteText() {
        return this.successNoteText == null ? "" : this.successNoteText;
    }

    public String getFailureNoteText() {
        return this.failureNoteText == null ? "" : this.failureNoteText;
    }

    public String getAbortNoteText() {
        return this.abortNoteText == null ? "" : this.abortNoteText;
    }

    public String getUnstableNoteText() {
        return this.unstableNoteText == null ? "" : this.unstableNoteText;
    }

    @DataBoundSetter
    public void setOnlyForFailure(boolean onlyForFailure) {
        this.onlyForFailure = onlyForFailure;
    }

    @DataBoundSetter
    public void setReplaceSuccessNote(boolean replaceSuccessNote) {
        this.replaceSuccessNote = replaceSuccessNote;
    }

    @DataBoundSetter
    public void setReplaceFailureNote(boolean replaceFailureNote) {
        this.replaceFailureNote = replaceFailureNote;
    }

    @DataBoundSetter
    public void setReplaceAbortNote(boolean replaceAbortNote) {
        this.replaceAbortNote = replaceAbortNote;
    }

    @DataBoundSetter
    public void setReplaceUnstableNote(boolean replaceUnstableNote) {
        this.replaceUnstableNote = replaceUnstableNote;
    }

    @DataBoundSetter
    public void setSuccessNoteText(String successNoteText) {
        this.successNoteText = successNoteText;
    }

    @DataBoundSetter
    public void setFailureNoteText(String failureNoteText) {
        this.failureNoteText = failureNoteText;
    }

    @DataBoundSetter
    public void setAbortNoteText(String abortNoteText) {
        this.abortNoteText = abortNoteText;
    }

    @DataBoundSetter
    public void setUnstableNoteText(String unstableNoteText) {
        this.unstableNoteText = unstableNoteText;
    }

    @Override
    protected void perform(Run<?, ?> build, TaskListener listener, GiteeClient client, PullRequest pullRequest) {
        try {
            if (!this.onlyForFailure || build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
                client.createPullRequestNote(pullRequest, this.getNote(build, listener));
            }
        }
        catch (ProcessingException | WebApplicationException e) {
            listener.getLogger().printf("Failed to add comment on Pull Request for project '%s': %s%n", pullRequest.getProjectId(), e.getMessage());
            LOGGER.log(Level.SEVERE, String.format("Failed to add comment on Pull Request for project '%s'", pullRequest.getProjectId()), e);
        }
    }

    private String getResultIcon(Result result) {
        if (result == Result.SUCCESS) {
            return ":white_check_mark:";
        }
        if (result == Result.ABORTED) {
            return ":point_up:";
        }
        if (result == Result.UNSTABLE) {
            return ":warning:";
        }
        return ":x:";
    }

    private static String replaceMacros(Run<?, ?> build, TaskListener listener, String inputString) {
        String returnString = inputString;
        if (build != null && inputString != null) {
            try {
                Map<String, String> messageEnvVars = GiteeMessagePublisher.getEnvVars(build, listener);
                returnString = Util.replaceMacro((String)inputString, messageEnvVars);
            }
            catch (Exception e) {
                listener.getLogger().printf("Couldn't replace macros in message: %s%n", e.getMessage());
                LOGGER.log(Level.WARNING, "Couldn't replace macros in message", e);
            }
        }
        return returnString;
    }

    private static Map<String, String> getEnvVars(Run<?, ?> build, TaskListener listener) {
        HashMap<String, String> messageEnvVars = new HashMap<String, String>();
        if (build != null) {
            messageEnvVars.putAll((Map<String, String>)build.getCharacteristicEnvVars());
            try {
                messageEnvVars.putAll((Map<String, String>)build.getEnvironment(listener));
            }
            catch (Exception e) {
                listener.getLogger().printf("Couldn't get Env Variables: %s%n", e.getMessage());
                LOGGER.log(Level.WARNING, "Couldn't get Env Variables", e);
            }
        }
        return messageEnvVars;
    }

    private String getNote(Run<?, ?> build, TaskListener listener) {
        String message;
        if (this.replaceSuccessNote && build.getResult() == Result.SUCCESS) {
            message = GiteeMessagePublisher.replaceMacros(build, listener, this.getSuccessNoteText());
        } else if (this.replaceAbortNote && build.getResult() == Result.ABORTED) {
            message = GiteeMessagePublisher.replaceMacros(build, listener, this.getAbortNoteText());
        } else if (this.replaceUnstableNote && build.getResult() == Result.UNSTABLE) {
            message = GiteeMessagePublisher.replaceMacros(build, listener, this.getUnstableNoteText());
        } else if (this.replaceFailureNote && build.getResult() == Result.FAILURE) {
            message = GiteeMessagePublisher.replaceMacros(build, listener, this.getFailureNoteText());
        } else {
            String icon = this.getResultIcon(build.getResult());
            String buildUrl = Jenkins.get().getRootUrl() + build.getUrl();
            message = MessageFormat.format("{0} Jenkins Build {1}\n\nResults available at: [Jenkins [{2} # {3}]]({4})", icon, build.getResult(), build.getParent().getDisplayName(), build.getNumber(), buildUrl);
        }
        return message;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GiteeMessagePublisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gitee/help/help-messagesOnResult.html";
        }
    }
}

