/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.jenkins.connection;

import com.gitee.jenkins.connection.GiteeConnection;
import com.gitee.jenkins.connection.GiteeConnectionConfig;
import com.gitee.jenkins.gitee.api.GiteeClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class GiteeConnectionProperty
extends JobProperty<Job<?, ?>> {
    private String giteeConnection;

    @DataBoundConstructor
    public GiteeConnectionProperty(String giteeConnection) {
        this.giteeConnection = giteeConnection;
    }

    public String getGiteeConnection() {
        return this.giteeConnection;
    }

    public GiteeClient getClient() {
        if (StringUtils.isNotEmpty((String)this.giteeConnection)) {
            GiteeConnectionConfig connectionConfig = (GiteeConnectionConfig)Jenkins.get().getDescriptor(GiteeConnectionConfig.class);
            return connectionConfig != null ? connectionConfig.getClient(this.giteeConnection) : null;
        }
        return null;
    }

    public static GiteeClient getClient(Run<?, ?> build) {
        GiteeConnectionProperty connectionProperty = (GiteeConnectionProperty)build.getParent().getProperty(GiteeConnectionProperty.class);
        if (connectionProperty != null) {
            return connectionProperty.getClient();
        }
        return null;
    }

    public static GiteeClient getClient(Job<?, ?> job) {
        GiteeConnectionProperty connectionProperty = (GiteeConnectionProperty)job.getProperty(GiteeConnectionProperty.class);
        if (connectionProperty != null) {
            return connectionProperty.getClient();
        }
        return null;
    }

    @Extension
    @Symbol(value={"giteeConnection"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Gitee connection";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public JobProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)req.bindJSON(GiteeConnectionProperty.class, formData);
        }

        public ListBoxModel doFillGiteeConnectionItems() {
            ListBoxModel options = new ListBoxModel();
            GiteeConnectionConfig descriptor = (GiteeConnectionConfig)Jenkins.get().getDescriptor(GiteeConnectionConfig.class);
            for (GiteeConnection connection : descriptor.getConnections()) {
                options.add(connection.getName(), connection.getName());
            }
            return options;
        }
    }
}

