/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Future;
import hudson.remoting.Pipe;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.SlaveToMasterFileCallable;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class GiteaAssetPublisher
implements SimpleBuildStep,
Describable<GiteaAssetPublisher> {
    private static final Logger LOGGER = Logger.getLogger(GiteaAssetPublisher.class.getName());
    private String assets;
    private String excludes;
    private boolean onlyIfSuccessful;
    private Boolean defaultExcludes = true;
    private Boolean caseSensitive = true;
    private Boolean followSymlinks = true;

    @DataBoundConstructor
    public GiteaAssetPublisher(String assets) {
        this.assets = assets.trim();
    }

    public String getAssets() {
        return this.assets;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    @DataBoundSetter
    public final void setExcludes(@CheckForNull String excludes) {
        this.excludes = Util.fixEmptyAndTrim((String)excludes);
    }

    public boolean isOnlyIfSuccessful() {
        return this.onlyIfSuccessful;
    }

    @DataBoundSetter
    public final void setOnlyIfSuccessful(boolean onlyIfSuccessful) {
        this.onlyIfSuccessful = onlyIfSuccessful;
    }

    public boolean isDefaultExcludes() {
        return this.defaultExcludes;
    }

    @DataBoundSetter
    public final void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @DataBoundSetter
    public final void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    @DataBoundSetter
    public final void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        throw new IllegalStateException("GiteaAssetPublisher.perform(AbstractBuild, Launcher, BuildListener) should not have been called...");
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        block28: {
            if (this.assets.length() == 0) {
                throw new AbortException(Messages.GiteaAssetPublisher_NoIncludes());
            }
            Result result = build.getResult();
            if (this.onlyIfSuccessful && result != null && result.isWorseThan(Result.UNSTABLE)) {
                listener.getLogger().println(Messages.GiteaAssetPublisher_SkipBecauseOnlyIfSuccessful());
                return;
            }
            SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
            if (!(s instanceof GiteaSCMSource)) {
                listener.getLogger().println("Did not publish gitea release assets due to source being no GiteaSCMSource");
                return;
            }
            GiteaSCMSource source = (GiteaSCMSource)s;
            SCMHead head = SCMHead.HeadByItem.findHead((Item)build.getParent());
            if (head == null || !(head instanceof ReleaseSCMHead)) {
                listener.getLogger().println("Did not publish gitea release assets due to head either being null or no ReleaseSCMHead");
                return;
            }
            listener.getLogger().println(Messages.GiteaAssetPublisher_StartPublishing());
            EnvVars environment = build.getEnvironment(listener);
            try {
                Map files;
                String assets = this.assets;
                if (build instanceof AbstractBuild) {
                    assets = environment.expand(assets);
                }
                if (!(files = (Map)workspace.act((FilePath.FileCallable)new ListFiles(assets, this.excludes, this.defaultExcludes, this.caseSensitive, this.followSymlinks))).isEmpty()) {
                    for (Map.Entry entry : files.entrySet()) {
                        String archivedPath = (String)entry.getKey();
                        assert (archivedPath.indexOf(92) == -1);
                        String workspacePath = (String)entry.getValue();
                        assert (workspacePath.indexOf(92) == -1);
                        listener.getLogger().format("GiteaAssetPublisher: %s -> %s%n", archivedPath, workspacePath);
                        if (workspace.isRemote()) {
                            Pipe pipe = Pipe.createRemoteToLocal();
                            Future future = workspace.actAsync((FilePath.FileCallable)new StreamFileRemoteToLocal(pipe, workspacePath));
                            try (GiteaConnection c = source.gitea().open();){
                                c.createReleaseAttachment(source.getRepoOwner(), source.getRepository(), ((ReleaseSCMHead)head).getId(), new File(archivedPath).getName(), pipe.getIn());
                            }
                            try {
                                future.get();
                                continue;
                            }
                            catch (ExecutionException e) {
                                Throwable cause = e.getCause();
                                if (cause == null) {
                                    cause = e;
                                }
                                throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
                            }
                        }
                        FileInputStream file = new FileInputStream(new File(workspace.getRemote(), workspacePath));
                        GiteaConnection c = source.gitea().open();
                        try {
                            c.createReleaseAttachment(source.getRepoOwner(), source.getRepository(), ((ReleaseSCMHead)head).getId(), new File(archivedPath).getName(), file);
                        }
                        finally {
                            if (c == null) continue;
                            c.close();
                        }
                    }
                    break block28;
                }
                result = build.getResult();
                if (result == null || result.isBetterOrEqualTo(Result.UNSTABLE)) {
                    listener.getLogger().println(Messages.GiteaAssetPublisher_NoMatchFound(assets));
                }
            }
            catch (AccessDeniedException e) {
                LOGGER.log(Level.FINE, "Diagnosing anticipated Exception", e);
                throw new AbortException(e.toString());
            }
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    public Descriptor<GiteaAssetPublisher> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    private static final class ListFiles
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private final String includes;
        private final String excludes;
        private final boolean defaultExcludes;
        private final boolean caseSensitive;
        private final boolean followSymlinks;

        ListFiles(String includes, String excludes, boolean defaultExcludes, boolean caseSensitive, boolean followSymlinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.defaultExcludes = defaultExcludes;
            this.caseSensitive = caseSensitive;
            this.followSymlinks = followSymlinks;
        }

        public Map<String, String> invoke(File basedir, VirtualChannel channel) throws IOException, InterruptedException {
            HashMap<String, String> r = new HashMap<String, String>();
            FileSet fileSet = Util.createFileSet((File)basedir, (String)this.includes, (String)this.excludes);
            fileSet.setDefaultexcludes(this.defaultExcludes);
            fileSet.setCaseSensitive(this.caseSensitive);
            fileSet.setFollowSymlinks(this.followSymlinks);
            for (String f : fileSet.getDirectoryScanner().getIncludedFiles()) {
                f = f.replace(File.separatorChar, '/');
                r.put(f, f);
            }
            return r;
        }
    }

    private static final class StreamFileRemoteToLocal
    extends SlaveToMasterFileCallable<Void> {
        private final Pipe pipe;
        private final String workspacePath;

        StreamFileRemoteToLocal(Pipe pipe, String workspacePath) {
            this.pipe = pipe;
            this.workspacePath = workspacePath;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            File file = new File(f, this.workspacePath);
            if (file.isDirectory()) {
                return null;
            }
            try (OutputStream out = this.pipe.getOut();){
                IOUtils.copy((File)file, (OutputStream)out);
            }
            return null;
        }
    }

    @Extension
    @Symbol(value={"publishGiteaAssets"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<GiteaAssetPublisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public GiteaAssetPublisher newInstance(@NonNull StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (GiteaAssetPublisher)req.bindJSON(GiteaAssetPublisher.class, formData);
        }

        public String getDisplayName() {
            return Messages.GiteaAssetPublisher_DisplayName();
        }
    }
}

