/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.servers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.servers.GiteaServer;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class GiteaServers
extends GlobalConfiguration {
    private List<GiteaServer> servers;

    public GiteaServers() {
        this.load();
    }

    public static GiteaServers get() {
        return (GiteaServers)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(GiteaServers.class));
    }

    @NonNull
    public static String normalizeServerUrl(@CheckForNull String serverUrl) {
        serverUrl = StringUtils.defaultString((String)serverUrl);
        try {
            URI uri = new URI(serverUrl).normalize();
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                String host = uri.getHost() == null ? null : uri.getHost().toLowerCase(Locale.ENGLISH);
                int port = uri.getPort();
                if ("http".equals(scheme) && port == 80) {
                    port = -1;
                } else if ("https".equals(scheme) && port == 443) {
                    port = -1;
                }
                serverUrl = new URI(scheme, uri.getUserInfo(), host, port, uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return serverUrl.replaceAll("/$", "");
    }

    public static boolean isEventFor(String serverUrl, String eventUrl) {
        try {
            for (boolean alias : new boolean[]{false, true}) {
                URI serverUri;
                if (alias) {
                    GiteaServer server = GiteaServers.get().findServer(serverUrl);
                    if (server == null || !StringUtils.isNotBlank((String)server.getAliasUrl())) continue;
                    serverUri = new URI(server.getAliasUrl());
                } else {
                    serverUri = new URI(serverUrl);
                }
                URI eventUri = new URI(eventUrl);
                if (!StringUtils.equalsIgnoreCase((String)serverUri.getHost(), (String)eventUri.getHost())) continue;
                if ("http".equals(serverUri.getScheme())) {
                    int serverPort = serverUri.getPort();
                    if (serverPort == -1) {
                        serverPort = 80;
                    }
                    if ("http".equals(eventUri.getScheme())) {
                        int eventPort = eventUri.getPort();
                        if (eventPort == -1) {
                            eventPort = 80;
                        }
                        if (serverPort != eventPort) {
                            continue;
                        }
                    } else if (!"https".equals(eventUri.getScheme())) {
                        continue;
                    }
                } else if ("https".equals(serverUri.getScheme())) {
                    int serverPort = serverUri.getPort();
                    if (serverPort == -1) {
                        serverPort = 443;
                    }
                    if ("https".equals(eventUri.getScheme())) {
                        int eventPort = eventUri.getPort();
                        if (eventPort == -1) {
                            eventPort = 443;
                        }
                        if (serverPort != eventPort) {
                            continue;
                        }
                    } else if (!"http".equals(eventUri.getScheme())) continue;
                }
                String serverPath = StringUtils.defaultIfBlank((String)serverUri.getPath(), (String)"");
                String eventPath = StringUtils.defaultIfBlank((String)eventUri.getPath(), (String)"/");
                if (!eventPath.startsWith(serverPath + "/")) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return false;
    }

    public boolean isEndpointSelectable() {
        return this.getServers().size() > 1;
    }

    public ListBoxModel getServerItems() {
        ListBoxModel result = new ListBoxModel();
        for (GiteaServer endpoint : this.getServers()) {
            String serverUrl = endpoint.getServerUrl();
            String displayName = endpoint.getDisplayName();
            result.add((String)(StringUtils.isBlank((String)displayName) ? serverUrl : displayName + " (" + serverUrl + ")"), serverUrl);
        }
        return result;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @NonNull
    public synchronized List<GiteaServer> getServers() {
        return this.servers == null || this.servers.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.servers);
    }

    public synchronized void setServers(@CheckForNull List<? extends GiteaServer> servers) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ArrayList<GiteaServer> eps = new ArrayList<GiteaServer>(Util.fixNull(servers));
        HashSet<String> serverUrls = new HashSet<String>();
        ListIterator iterator = eps.listIterator();
        while (iterator.hasNext()) {
            GiteaServer endpoint = (GiteaServer)((Object)iterator.next());
            String serverUrl = endpoint.getServerUrl();
            if (StringUtils.isBlank((String)serverUrl) || serverUrls.contains(serverUrl)) {
                iterator.remove();
                continue;
            }
            serverUrls.add(serverUrl);
        }
        this.servers = eps;
        this.save();
    }

    public synchronized boolean addServer(@NonNull GiteaServer endpoint) {
        ArrayList<GiteaServer> endpoints = new ArrayList<GiteaServer>(this.getServers());
        for (GiteaServer ep : endpoints) {
            if (!ep.getServerUrl().equals(endpoint.getServerUrl())) continue;
            return false;
        }
        endpoints.add(endpoint);
        this.setServers(endpoints);
        return true;
    }

    public synchronized void updateServer(@NonNull GiteaServer endpoint) {
        ArrayList<GiteaServer> endpoints = new ArrayList<GiteaServer>(this.getServers());
        boolean found = false;
        for (int i = 0; i < endpoints.size(); ++i) {
            GiteaServer ep = (GiteaServer)((Object)endpoints.get(i));
            if (!ep.getServerUrl().equals(endpoint.getServerUrl())) continue;
            endpoints.set(i, endpoint);
            found = true;
            break;
        }
        if (!found) {
            endpoints.add(endpoint);
        }
        this.setServers(endpoints);
    }

    public boolean removeServer(@NonNull GiteaServer endpoint) {
        return this.removeServer(endpoint.getServerUrl());
    }

    public synchronized boolean removeServer(@CheckForNull String serverUrl) {
        serverUrl = GiteaServers.normalizeServerUrl(serverUrl);
        boolean modified = false;
        ArrayList<GiteaServer> endpoints = new ArrayList<GiteaServer>(this.getServers());
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            if (!serverUrl.equals(((GiteaServer)((Object)iterator.next())).getServerUrl())) continue;
            iterator.remove();
            modified = true;
        }
        this.setServers(endpoints);
        return modified;
    }

    @CheckForNull
    public synchronized GiteaServer findServer(@CheckForNull String serverUrl) {
        serverUrl = GiteaServers.normalizeServerUrl(serverUrl);
        for (GiteaServer endpoint : this.getServers()) {
            if (!serverUrl.equals(endpoint.getServerUrl())) continue;
            return endpoint;
        }
        return null;
    }
}

