/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.servers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMName;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaUser;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;
import org.jenkinsci.plugin.gitea.servers.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class GiteaServer
extends AbstractDescribableImpl<GiteaServer> {
    private static final String[] COMMON_PREFIX_HOSTNAMES = new String[]{"git.", "gitea.", "gogs.", "vcs.", "scm.", "source."};
    @CheckForNull
    private final String displayName;
    @NonNull
    private final String serverUrl;
    private final boolean manageHooks;
    @CheckForNull
    private final String credentialsId;
    @CheckForNull
    private final String aliasUrl;

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public GiteaServer(@CheckForNull String displayName, @NonNull String serverUrl, boolean manageHooks, @CheckForNull String credentialsId) {
        this(displayName, serverUrl, manageHooks, credentialsId, null);
    }

    @DataBoundConstructor
    public GiteaServer(@CheckForNull String displayName, @NonNull String serverUrl, boolean manageHooks, @CheckForNull String credentialsId, @CheckForNull String aliasUrl) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((String)credentialsId);
        this.credentialsId = manageHooks ? credentialsId : null;
        this.serverUrl = GiteaServers.normalizeServerUrl(serverUrl);
        this.displayName = StringUtils.isBlank((String)displayName) ? SCMName.fromUrl((String)this.serverUrl, (String[])COMMON_PREFIX_HOSTNAMES) : displayName;
        this.aliasUrl = StringUtils.trimToNull((String)GiteaServers.normalizeServerUrl(aliasUrl));
    }

    @CheckForNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public String getAliasUrl() {
        return this.aliasUrl;
    }

    @CheckForNull
    public StandardCredentials credentials() {
        return StringUtils.isBlank((String)this.credentialsId) ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)this.credentialsId)}));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GiteaServer> {
        public static FormValidation doCheckServerUrl(@QueryParameter String value) {
            FormValidation formValidation;
            block10: {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                GiteaConnection c = Gitea.server(GiteaServers.normalizeServerUrl(value)).open();
                try {
                    formValidation = FormValidation.okWithMarkup((String)Messages.GiteaServer_serverVersion(Util.escape((String)c.fetchVersion().getVersion())));
                    if (c == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException e) {
                        return FormValidation.errorWithMarkup((String)Messages.GiteaServer_invalidUrl(Util.escape((String)e.getMessage())));
                    }
                    catch (InterruptedException e) {
                        return FormValidation.warning((String)Messages.GiteaServer_versionInterrupted());
                    }
                    catch (IOException e) {
                        return FormValidation.errorWithMarkup((String)Messages.GiteaServer_cannotConnect(Util.escape((String)e.getMessage())));
                    }
                }
                c.close();
            }
            return formValidation;
        }

        public static FormValidation doCheckAliasUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                new URI(value);
                return FormValidation.ok();
            }
            catch (URISyntaxException e) {
                return FormValidation.errorWithMarkup((String)Messages.GiteaServer_invalidUrl(Util.escape((String)e.getMessage())));
            }
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.GiteaServer_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            StandardListBoxModel result = new StandardListBoxModel();
            serverUrl = GiteaServers.normalizeServerUrl(serverUrl);
            result.includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(GiteaAuth.class));
            return result;
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String serverUrl, @QueryParameter String value) {
            FormValidation formValidation;
            block10: {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                serverUrl = GiteaServers.normalizeServerUrl(serverUrl);
                StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)value)}));
                if (credentials == null) {
                    return FormValidation.errorWithMarkup((String)Messages.GiteaServer_credentialsNotResolved(Util.escape((String)value)));
                }
                GiteaConnection c = Gitea.server(serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials)).open();
                try {
                    GiteaUser user = c.fetchCurrentUser();
                    formValidation = FormValidation.okWithMarkup((String)Messages.GiteaServer_hookManagementAs(Util.escape((String)user.getUsername())));
                    if (c == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        return FormValidation.warning((String)Messages.GiteaServer_validateInterrupted());
                    }
                    catch (IOException e) {
                        return FormValidation.errorWithMarkup((String)Messages.GiteaServer_cannotConnect(Util.escape((String)e.getMessage())));
                    }
                }
                c.close();
            }
            return formValidation;
        }
    }
}

