/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.credentials.Messages;
import org.jenkinsci.plugin.gitea.credentials.PersonalAccessToken;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PersonalAccessTokenImpl
extends BaseStandardCredentials
implements StandardUsernameCredentials,
PersonalAccessToken {
    @NonNull
    private final Secret token;

    @DataBoundConstructor
    public PersonalAccessTokenImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String token) {
        super(scope, id, description);
        this.token = Secret.fromString((String)token);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    public boolean isUsernameSecret() {
        return true;
    }

    @NonNull
    public String getUsername() {
        return this.getToken().getPlainText();
    }

    @NonNull
    public Secret getPassword() {
        return this.getToken();
    }

    @Symbol(value={"giteaAccessToken"})
    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.PersonalAccessTokenImpl_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckToken(@QueryParameter String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)Messages.PersonalAccessTokenImpl_tokenRequired());
            }
            Secret secret = Secret.fromString((String)value);
            if (StringUtils.equals((String)value, (String)secret.getPlainText())) {
                if (value.length() != 40) {
                    return FormValidation.error((String)Messages.PersonalAccessTokenImpl_tokenWrongLength());
                }
            } else if (secret.getPlainText().length() != 40) {
                return FormValidation.warning((String)Messages.PersonalAccessTokenImpl_tokenWrongLength());
            }
            return FormValidation.ok();
        }
    }
}

