/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.client.impl;

import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import jenkins.model.Jenkins;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.client.api.GiteaAnnotatedTag;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuthToken;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuthUser;
import org.jenkinsci.plugin.gitea.client.api.GiteaBranch;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitDetail;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitStatus;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaHook;
import org.jenkinsci.plugin.gitea.client.api.GiteaHttpStatusException;
import org.jenkinsci.plugin.gitea.client.api.GiteaIssue;
import org.jenkinsci.plugin.gitea.client.api.GiteaIssueState;
import org.jenkinsci.plugin.gitea.client.api.GiteaOrganization;
import org.jenkinsci.plugin.gitea.client.api.GiteaOwner;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequest;
import org.jenkinsci.plugin.gitea.client.api.GiteaRelease;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;
import org.jenkinsci.plugin.gitea.client.api.GiteaTag;
import org.jenkinsci.plugin.gitea.client.api.GiteaUser;
import org.jenkinsci.plugin.gitea.client.api.GiteaVersion;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

class DefaultGiteaConnection
implements GiteaConnection {
    private final String serverUrl;
    private final GiteaAuth authentication;
    private final ObjectMapper mapper = new ObjectMapper();
    private Pattern nextPagePattern = Pattern.compile("<(.*)>;\\s*rel=\"next\"");

    DefaultGiteaConnection(@NonNull String serverUrl, @NonNull GiteaAuth authentication) {
        this.serverUrl = serverUrl;
        this.authentication = authentication;
    }

    private static void setRequestMethodViaJreBugWorkaround(final HttpURLConnection httpURLConnection, final String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws NoSuchFieldException, IllegalAccessException {
                        Object target;
                        if (httpURLConnection instanceof HttpsURLConnection) {
                            Field delegate = httpURLConnection.getClass().getDeclaredField("delegate");
                            delegate.setAccessible(true);
                            target = delegate.get(httpURLConnection);
                        } else {
                            target = httpURLConnection;
                        }
                        Field methodField = HttpURLConnection.class.getDeclaredField("method");
                        methodField.setAccessible(true);
                        methodField.set(target, method);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    @Override
    public GiteaVersion fetchVersion() throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/version").build(), GiteaVersion.class);
    }

    @Override
    public GiteaUser fetchCurrentUser() throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/user").build(), GiteaUser.class);
    }

    @Override
    public GiteaOwner fetchOwner(String name) throws IOException, InterruptedException {
        block3: {
            try {
                GiteaOrganization giteaOrganization = this.fetchOrganization(name);
                if (giteaOrganization != null) {
                    return giteaOrganization;
                }
            }
            catch (GiteaHttpStatusException e) {
                if (e.getStatusCode() == 404) break block3;
                throw e;
            }
        }
        return this.fetchUser(name);
    }

    @Override
    public GiteaUser fetchUser(String name) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/users").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).build().set("name", (Object)name), GiteaUser.class);
    }

    @Override
    public GiteaOrganization fetchOrganization(String name) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).build().set("name", (Object)name), GiteaOrganization.class);
    }

    @Override
    public GiteaRepository fetchRepository(String username, String name) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).build().set("username", (Object)username).set("name", (Object)name), GiteaRepository.class);
    }

    @Override
    public GiteaRepository fetchRepository(GiteaOwner owner, String name) throws IOException, InterruptedException {
        return this.fetchRepository(owner.getUsername(), name);
    }

    @Override
    public List<GiteaRepository> fetchCurrentUserRepositories() throws IOException, InterruptedException {
        return this.getList(this.api().literal("/user").literal("/repos").build(), GiteaRepository.class);
    }

    @Override
    public List<GiteaRepository> fetchRepositories(String username) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/users").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).literal("/repos").build().set("username", (Object)username), GiteaRepository.class);
    }

    @Override
    public List<GiteaRepository> fetchRepositories(GiteaOwner owner) throws IOException, InterruptedException {
        if (owner instanceof GiteaOrganization) {
            return this.fetchOrganizationRepositories(owner);
        }
        return this.fetchRepositories(owner.getUsername());
    }

    @Override
    public List<GiteaRepository> fetchOrganizationRepositories(GiteaOwner owner) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"org")}).literal("/repos").build().set("org", (Object)owner.getUsername()), GiteaRepository.class);
    }

    @Override
    public GiteaBranch fetchBranch(String username, String repository, String name) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/branches").path(new VarSpec[]{UriTemplateBuilder.var((String)"name", (boolean)true)}).build().set("username", (Object)username).set("repository", (Object)repository).set("name", (Object)StringUtils.split((String)name, (char)'/')), GiteaBranch.class);
    }

    @Override
    public GiteaBranch fetchBranch(GiteaRepository repository, String name) throws IOException, InterruptedException {
        return this.fetchBranch(repository.getOwner().getUsername(), repository.getName(), name);
    }

    @Override
    public List<GiteaBranch> fetchBranches(String username, String name) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/branches").build().set("username", (Object)username).set("name", (Object)name), GiteaBranch.class);
    }

    @Override
    public List<GiteaBranch> fetchBranches(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchBranches(repository.getOwner().getUsername(), repository.getName());
    }

    @Override
    public GiteaAnnotatedTag fetchAnnotatedTag(String username, String repository, String sha1) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/git/tags").path(new VarSpec[]{UriTemplateBuilder.var((String)"sha1")}).build().set("username", (Object)username).set("repository", (Object)repository).set("sha1", (Object)sha1), GiteaAnnotatedTag.class);
    }

    @Override
    public GiteaAnnotatedTag fetchAnnotatedTag(GiteaRepository repository, GiteaTag tag) throws IOException, InterruptedException {
        return this.fetchAnnotatedTag(repository.getOwner().getUsername(), repository.getName(), tag.getId());
    }

    @Override
    public GiteaTag fetchTag(String username, String repository, String tag) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/tags").path(new VarSpec[]{UriTemplateBuilder.var((String)"tag")}).build().set("username", (Object)username).set("name", (Object)repository).set("tag", (Object)tag), GiteaTag.class);
    }

    @Override
    public GiteaTag fetchTag(GiteaRepository repository, String tag) throws IOException, InterruptedException {
        return this.fetchTag(repository.getOwner().getUsername(), repository.getName(), tag);
    }

    @Override
    public List<GiteaTag> fetchTags(String username, String name) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/tags").build().set("username", (Object)username).set("name", (Object)name), GiteaTag.class);
    }

    @Override
    public List<GiteaTag> fetchTags(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchTags(repository.getOwner().getUsername(), repository.getName());
    }

    @Override
    public GiteaCommitDetail fetchCommit(String username, String repository, String sha1) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/git/commits").path(new VarSpec[]{UriTemplateBuilder.var((String)"sha1")}).build().set("username", (Object)username).set("repository", (Object)repository).set("sha1", (Object)sha1), GiteaCommitDetail.class);
    }

    @Override
    public GiteaCommitDetail fetchCommit(GiteaRepository repository, String sha1) throws IOException, InterruptedException {
        return this.fetchCommit(repository.getOwner().getUsername(), repository.getName(), sha1);
    }

    @Override
    public List<GiteaUser> fetchCollaborators(String username, String name) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/collaborators").build().set("username", (Object)username).set("name", (Object)name), GiteaUser.class);
    }

    @Override
    public List<GiteaUser> fetchCollaborators(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchCollaborators(repository.getOwner().getUsername(), repository.getName());
    }

    @Override
    public boolean checkCollaborator(String username, String name, String collaboratorName) throws IOException, InterruptedException {
        return this.status(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/collaborators").path(new VarSpec[]{UriTemplateBuilder.var((String)"collaboratorName")}).build().set("username", (Object)username).set("name", (Object)name).set("collaboratorName", (Object)collaboratorName)) / 100 == 2;
    }

    @Override
    public boolean checkCollaborator(GiteaRepository repository, String collaboratorName) throws IOException, InterruptedException {
        return this.checkCollaborator(repository.getOwner().getUsername(), repository.getName(), collaboratorName);
    }

    @Override
    public List<GiteaHook> fetchHooks(String organizationName) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").build().set("name", (Object)organizationName), GiteaHook.class);
    }

    @Override
    public List<GiteaHook> fetchHooks(GiteaOrganization organization) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").build().set("name", (Object)organization.getUsername()), GiteaHook.class);
    }

    @Override
    public GiteaHook createHook(GiteaOrganization organization, GiteaHook hook) throws IOException, InterruptedException {
        return this.post(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").build().set("name", (Object)organization.getUsername()), hook, GiteaHook.class);
    }

    @Override
    public void deleteHook(GiteaOrganization organization, GiteaHook hook) throws IOException, InterruptedException {
        this.deleteHook(organization, hook.getId());
    }

    @Override
    public void deleteHook(GiteaOrganization organization, long id) throws IOException, InterruptedException {
        int status = this.delete(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("name", (Object)organization.getUsername()).set("id", (Object)id));
        if (status / 100 != 2) {
            throw new IOException("Could not delete organization hook " + id + " for " + organization.getUsername() + " HTTP/" + status);
        }
    }

    @Override
    public List<GiteaHook> fetchHooks(String username, String name) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").build().set("username", (Object)username).set("name", (Object)name), GiteaHook.class);
    }

    @Override
    public List<GiteaHook> fetchHooks(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchHooks(repository.getOwner().getUsername(), repository.getName());
    }

    @Override
    public GiteaHook createHook(GiteaRepository repository, GiteaHook hook) throws IOException, InterruptedException {
        return this.post(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()), hook, GiteaHook.class);
    }

    @Override
    public void deleteHook(GiteaRepository repository, GiteaHook hook) throws IOException, InterruptedException {
        this.deleteHook(repository, hook.getId());
    }

    @Override
    public void deleteHook(GiteaRepository repository, long id) throws IOException, InterruptedException {
        int status = this.delete(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()).set("id", (Object)id));
        if (status / 100 != 2) {
            throw new IOException("Could not delete hook " + id + " for " + repository.getOwner().getUsername() + "/" + repository.getName() + " HTTP/" + status);
        }
    }

    @Override
    public void updateHook(GiteaOrganization organization, GiteaHook hook) throws IOException, InterruptedException {
        GiteaHook diff = new GiteaHook();
        diff.setConfig(hook.getConfig());
        diff.setActive(hook.isActive());
        diff.setEvents(hook.getEvents());
        this.patch(this.api().literal("/orgs").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("name", (Object)organization.getUsername()).set("id", (Object)hook.getId()), diff, Void.class);
    }

    @Override
    public void updateHook(GiteaRepository repository, GiteaHook hook) throws IOException, InterruptedException {
        GiteaHook diff = new GiteaHook();
        diff.setConfig(hook.getConfig());
        diff.setActive(hook.isActive());
        diff.setEvents(hook.getEvents());
        this.patch(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/hooks").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()).set("id", (Object)hook.getId()), diff, Void.class);
    }

    @Override
    public List<GiteaCommitStatus> fetchCommitStatuses(GiteaRepository repository, String sha) throws IOException, InterruptedException {
        return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/statuses").path(new VarSpec[]{UriTemplateBuilder.var((String)"sha")}).build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()).set("sha", (Object)sha), GiteaCommitStatus.class);
    }

    @Override
    public GiteaCommitStatus createCommitStatus(String username, String repository, String sha, GiteaCommitStatus status) throws IOException, InterruptedException {
        return this.post(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/statuses").path(new VarSpec[]{UriTemplateBuilder.var((String)"sha")}).build().set("username", (Object)username).set("name", (Object)repository).set("sha", (Object)sha), status, GiteaCommitStatus.class);
    }

    @Override
    public GiteaCommitStatus createCommitStatus(GiteaRepository repository, String sha, GiteaCommitStatus status) throws IOException, InterruptedException {
        return this.createCommitStatus(repository.getOwner().getUsername(), repository.getName(), sha, status);
    }

    @Override
    public GiteaPullRequest fetchPullRequest(String username, String name, long id) throws IOException, InterruptedException {
        return this.getObject(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/pulls").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("username", (Object)username).set("name", (Object)name).set("id", (Object)Long.toString(id)), GiteaPullRequest.class);
    }

    @Override
    public GiteaPullRequest fetchPullRequest(GiteaRepository repository, long id) throws IOException, InterruptedException {
        return this.fetchPullRequest(repository.getOwner().getUsername(), repository.getName(), id);
    }

    @Override
    public List<GiteaPullRequest> fetchPullRequests(String username, String name) throws IOException, InterruptedException {
        return this.fetchPullRequests(username, name, EnumSet.of(GiteaIssueState.OPEN));
    }

    @Override
    public List<GiteaPullRequest> fetchPullRequests(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchPullRequests(repository, EnumSet.of(GiteaIssueState.OPEN));
    }

    @Override
    public List<GiteaPullRequest> fetchPullRequests(String username, String name, Set<GiteaIssueState> states) throws IOException, InterruptedException {
        String state = null;
        if (states != null && states.size() == 1) {
            for (GiteaIssueState s : GiteaIssueState.values()) {
                if (!states.contains((Object)s)) continue;
                state = s.getKey();
            }
        }
        try {
            return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/pulls").query(new VarSpec[]{UriTemplateBuilder.var((String)"state")}).build().set("username", (Object)username).set("name", (Object)name).set("state", (Object)state), GiteaPullRequest.class);
        }
        catch (GiteaHttpStatusException e) {
            if (e.getStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<GiteaPullRequest> fetchPullRequests(GiteaRepository repository, Set<GiteaIssueState> states) throws IOException, InterruptedException {
        return this.fetchPullRequests(repository.getOwner().getUsername(), repository.getName(), states);
    }

    @Override
    public List<GiteaIssue> fetchIssues(String username, String name) throws IOException, InterruptedException {
        return this.fetchIssues(username, name, EnumSet.of(GiteaIssueState.OPEN));
    }

    @Override
    public List<GiteaIssue> fetchIssues(GiteaRepository repository) throws IOException, InterruptedException {
        return this.fetchIssues(repository, EnumSet.of(GiteaIssueState.OPEN));
    }

    @Override
    public List<GiteaIssue> fetchIssues(String username, String name, Set<GiteaIssueState> states) throws IOException, InterruptedException {
        String state = null;
        if (states != null && states.size() == 1) {
            for (GiteaIssueState s : GiteaIssueState.values()) {
                if (!states.contains((Object)s)) continue;
                state = s.getKey();
            }
        }
        try {
            return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/issues").query(new VarSpec[]{UriTemplateBuilder.var((String)"state")}).build().set("username", (Object)username).set("name", (Object)name).set("state", (Object)state), GiteaIssue.class);
        }
        catch (GiteaHttpStatusException e) {
            if (e.getStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<GiteaIssue> fetchIssues(GiteaRepository repository, Set<GiteaIssueState> states) throws IOException, InterruptedException {
        return this.fetchIssues(repository.getOwner().getUsername(), repository.getName(), states);
    }

    @Override
    public byte[] fetchFile(GiteaRepository repository, String ref, String path) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/raw").path(new VarSpec[]{UriTemplateBuilder.var((String)"ref", (boolean)true)}).path(new VarSpec[]{UriTemplateBuilder.var((String)"path", (boolean)true)}).build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()).set("ref", (Object)StringUtils.split((String)ref, (char)'/')).set("path", (Object)StringUtils.split((String)path, (String)"/")));
        this.withAuthentication(connection);
        try {
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 404) {
                throw new FileNotFoundException(path);
            }
            if (status / 100 == 2) {
                try (InputStream is = connection.getInputStream();){
                    byte[] byArray = IOUtils.toByteArray((InputStream)is);
                    return byArray;
                }
            }
            throw new IOException("HTTP " + status + "/" + connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }

    @Override
    public boolean checkFile(GiteaRepository repository, String ref, String path) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/raw").path(new VarSpec[]{UriTemplateBuilder.var((String)"ref", (boolean)true)}).path(new VarSpec[]{UriTemplateBuilder.var((String)"path", (boolean)true)}).build().set("username", (Object)repository.getOwner().getUsername()).set("name", (Object)repository.getName()).set("ref", (Object)StringUtils.split((String)ref, (char)'/')).set("path", (Object)StringUtils.split((String)path, (String)"/")));
        this.withAuthentication(connection);
        try {
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 404) {
                boolean bl = false;
                return bl;
            }
            if (status / 100 == 2) {
                boolean bl = true;
                return bl;
            }
            throw new IOException("HTTP " + status + "/" + connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }

    @Override
    public List<GiteaRelease> fetchReleases(String username, String name, boolean draft, boolean prerelease) throws IOException, InterruptedException {
        try {
            StringBuilder params = new StringBuilder();
            if (!draft || !prerelease) {
                params.append("?");
                if (!draft) {
                    params.append("draft=false");
                }
                if (!prerelease) {
                    if (!draft) {
                        params.append("&");
                    }
                    params.append("pre-release=false");
                }
            }
            return this.getList(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).literal("/releases").literal(params.toString()).build().set("username", (Object)username).set("name", (Object)name), GiteaRelease.class);
        }
        catch (GiteaHttpStatusException e) {
            if (e.getStatusCode() == 404) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<GiteaRelease> fetchReleases(GiteaRepository repository, boolean draft, boolean prerelease) throws IOException, InterruptedException {
        return this.fetchReleases(repository.getOwner().getUsername(), repository.getName(), draft, prerelease);
    }

    @Override
    public GiteaRelease.Attachment createReleaseAttachment(String username, String repository, long id, String name, InputStream file) throws IOException, InterruptedException {
        return this.postFile(this.api().literal("/repos").path(new VarSpec[]{UriTemplateBuilder.var((String)"username")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/releases").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).literal("/assets").query(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).build().set("username", (Object)username).set("repository", (Object)repository).set("id", (Object)id).set("name", (Object)name), name, file, GiteaRelease.Attachment.class);
    }

    @Override
    public GiteaRelease.Attachment createReleaseAttachment(GiteaRepository repository, long id, String name, InputStream file) throws IOException, InterruptedException {
        return this.createReleaseAttachment(repository.getOwner().getUsername(), repository.getName(), id, name, file);
    }

    @Override
    public void close() throws IOException {
    }

    private UriTemplateBuilder api() {
        return UriTemplate.buildFromTemplate((String)this.serverUrl).literal("/api/v1");
    }

    private void withAuthentication(HttpURLConnection connection) {
        if (this.authentication instanceof GiteaAuthUser) {
            String auth = ((GiteaAuthUser)this.authentication).getUsername() + ":" + ((GiteaAuthUser)this.authentication).getPassword();
            connection.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64String((byte[])auth.getBytes(StandardCharsets.UTF_8)));
        } else if (this.authentication instanceof GiteaAuthToken) {
            connection.setRequestProperty("Authorization", "token " + ((GiteaAuthToken)this.authentication).getToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int status(UriTemplate template) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        try {
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int delete(UriTemplate template) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        connection.setRequestMethod("DELETE");
        try {
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        finally {
            connection.disconnect();
        }
    }

    private <T> T getObject(UriTemplate template, Class<T> modelClass) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        try {
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 200) {
                InputStream is = connection.getInputStream();
                Object object = this.mapper.readerFor(modelClass).readValue(is);
                return (T)object;
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            throw new GiteaHttpStatusException(status, connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }

    private <T> T post(UriTemplate template, Object body, Class<T> modelClass) throws IOException, InterruptedException {
        byte[] bytes;
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        connection.setRequestMethod("POST");
        if (body != null) {
            bytes = this.mapper.writer((DateFormat)new StdDateFormat()).writeValueAsBytes(body);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
            connection.setDoOutput(true);
        } else {
            bytes = null;
            connection.setDoOutput(false);
        }
        connection.setDoInput(!Void.class.equals(modelClass));
        try {
            int status;
            connection.connect();
            if (bytes != null) {
                try (OutputStream os = connection.getOutputStream();){
                    os.write(bytes);
                }
            }
            if ((status = connection.getResponseCode()) / 100 == 2) {
                if (Void.class.equals(modelClass)) {
                    T t = null;
                    return t;
                }
                InputStream is = connection.getInputStream();
                Object object = this.mapper.readerFor(modelClass).readValue(is);
                return (T)object;
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            throw new GiteaHttpStatusException(status, connection.getResponseMessage(), bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null);
        }
        finally {
            connection.disconnect();
        }
    }

    private <T> T postFile(UriTemplate template, String fileName, InputStream file, Class<T> modelClass) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        connection.setRequestMethod("POST");
        String boundary = "===" + System.currentTimeMillis() + "===";
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=\"" + boundary + "\"");
        connection.setDoOutput(true);
        connection.setDoInput(!Void.class.equals(modelClass));
        String LINE_FEED = "\r\n";
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(connection.getOutputStream(), "UTF-8"), true);
        writer.append("--" + boundary).append("\r\n");
        writer.append("Content-Disposition: form-data; name=\"attachment\"; filename=\"" + fileName + "\"").append("\r\n");
        writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append("\r\n");
        writer.append("Content-Transfer-Encoding: binary").append("\r\n");
        writer.append("\r\n");
        writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead2 = -1;
        while ((bytesRead2 = file.read(buffer)) != -1) {
            connection.getOutputStream().write(buffer, 0, bytesRead2);
        }
        connection.getOutputStream().flush();
        file.close();
        writer.flush();
        writer.append("\r\n");
        writer.append("--" + boundary + "--").append("\r\n");
        writer.close();
        try {
            connection.connect();
            int status = connection.getResponseCode();
            if (status / 100 == 2) {
                if (Void.class.equals(modelClass)) {
                    T bytesRead2 = null;
                    return bytesRead2;
                }
                InputStream is = connection.getInputStream();
                Object object = this.mapper.readerFor(modelClass).readValue(is);
                return (T)object;
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            throw new GiteaHttpStatusException(status, connection.getResponseMessage(), "<multipart/form-data with file>");
        }
        finally {
            connection.disconnect();
        }
    }

    private <T> T patch(UriTemplate template, Object body, Class<T> modelClass) throws IOException, InterruptedException {
        byte[] bytes;
        HttpURLConnection connection = this.openConnection(template);
        this.withAuthentication(connection);
        DefaultGiteaConnection.setRequestMethodViaJreBugWorkaround(connection, "PATCH");
        if (body != null) {
            bytes = this.mapper.writer((DateFormat)new StdDateFormat()).writeValueAsBytes(body);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
            connection.setDoOutput(true);
        } else {
            bytes = null;
            connection.setDoOutput(false);
        }
        connection.setDoInput(true);
        try {
            int status;
            connection.connect();
            if (bytes != null) {
                try (OutputStream os = connection.getOutputStream();){
                    os.write(bytes);
                }
            }
            if ((status = connection.getResponseCode()) / 100 == 2) {
                if (Void.class.equals(modelClass)) {
                    T t = null;
                    return t;
                }
                InputStream is = connection.getInputStream();
                Object object = this.mapper.readerFor(modelClass).readValue(is);
                return (T)object;
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            throw new GiteaHttpStatusException(status, connection.getResponseMessage(), bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null);
        }
        finally {
            connection.disconnect();
        }
    }

    private <T> List<T> getList(UriTemplate template, Class<T> modelClass) throws IOException, InterruptedException {
        return this.getList(template.expand(), modelClass);
    }

    private <T> List<T> getList(String url, Class<T> modelClass) throws IOException, InterruptedException {
        HttpURLConnection connection = this.openConnection(url);
        this.withAuthentication(connection);
        try {
            connection.connect();
            int status = connection.getResponseCode();
            if (status / 100 == 2) {
                Optional<String> next = Optional.ofNullable(connection.getHeaderField("Link")).map(this.nextPagePattern::matcher).filter(Matcher::find).map(matcher -> matcher.group(1));
                try (InputStream is = connection.getInputStream();){
                    List list = (List)this.mapper.readerFor((JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, modelClass)).readValue(is);
                    if (next.isPresent()) {
                        list.addAll(this.getList(next.get(), modelClass));
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != null) continue;
                        iterator.remove();
                    }
                    List list2 = list;
                    return list2;
                }
            }
            throw new GiteaHttpStatusException(status, connection.getResponseMessage());
        }
        finally {
            connection.disconnect();
        }
    }

    private HttpURLConnection openConnection(UriTemplate template) throws IOException {
        return this.openConnection(template.expand());
    }

    @Restricted(value={NoExternalUse.class})
    protected HttpURLConnection openConnection(String spec) throws IOException {
        URL url = new URL(spec);
        Jenkins jenkins = Jenkins.get();
        if (jenkins.proxy == null) {
            return (HttpURLConnection)url.openConnection();
        }
        return (HttpURLConnection)url.openConnection(jenkins.proxy.createProxy(url.getHost()));
    }
}

