/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.client.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugin.gitea.client.api.GiteaIssueState;
import org.jenkinsci.plugin.gitea.client.api.GiteaLabel;
import org.jenkinsci.plugin.gitea.client.api.GiteaMilestone;
import org.jenkinsci.plugin.gitea.client.api.GiteaObject;
import org.jenkinsci.plugin.gitea.client.api.GiteaOwner;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class GiteaPullRequest
extends GiteaObject<GiteaPullRequest> {
    private long id;
    private String url;
    private long number;
    private GiteaOwner user;
    private String title;
    private String body;
    private List<GiteaLabel> labels = new ArrayList<GiteaLabel>();
    private GiteaMilestone milestone;
    private GiteaOwner assignee;
    private GiteaIssueState state;
    private long comments;
    private String htmlUrl;
    private String diffUrl;
    private String patchUrl;
    private boolean mergeable;
    private boolean merged;
    private Date mergedAt;
    private String mergeCommitSha;
    private GiteaOwner mergedBy;
    private Reference base;
    private Reference head;
    private String mergeBase;
    private Date createdAt;
    private Date updatedAt;

    public GiteaPullRequest() {
    }

    public GiteaPullRequest(String url, GiteaOwner user, String title, String body, List<GiteaLabel> labels, GiteaMilestone milestone, GiteaOwner assignee, GiteaIssueState state, long comments, String htmlUrl, String diffUrl, String patchUrl, boolean mergeable, boolean merged, Date mergedAt, String mergeCommitSha, GiteaOwner mergedBy, Reference base, Reference head, String mergeBase) {
        this.url = url;
        this.user = user;
        this.title = title;
        this.body = body;
        this.labels = labels;
        this.milestone = milestone;
        this.assignee = assignee;
        this.state = state;
        this.comments = comments;
        this.htmlUrl = htmlUrl;
        this.diffUrl = diffUrl;
        this.patchUrl = patchUrl;
        this.mergeable = mergeable;
        this.merged = merged;
        this.mergedAt = mergedAt == null ? null : (Date)mergedAt.clone();
        this.mergeCommitSha = mergeCommitSha;
        this.mergedBy = mergedBy;
        this.base = base;
        this.head = head;
        this.mergeBase = mergeBase;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public GiteaOwner getUser() {
        return this.user == null ? null : (GiteaOwner)this.user.clone();
    }

    public void setUser(GiteaOwner user) {
        this.user = user == null ? null : (GiteaOwner)user.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<GiteaLabel> getLabels() {
        return this.labels == null ? new ArrayList<GiteaLabel>() : new ArrayList<GiteaLabel>(this.labels);
    }

    public void setLabels(List<GiteaLabel> labels) {
        this.labels = labels == null ? new ArrayList<GiteaLabel>() : new ArrayList<GiteaLabel>(labels);
    }

    public GiteaMilestone getMilestone() {
        return this.milestone == null ? null : (GiteaMilestone)this.milestone.clone();
    }

    public void setMilestone(GiteaMilestone milestone) {
        this.milestone = milestone == null ? null : (GiteaMilestone)milestone.clone();
    }

    public GiteaOwner getAssignee() {
        return this.assignee == null ? null : (GiteaOwner)this.assignee.clone();
    }

    public void setAssignee(GiteaOwner assignee) {
        this.assignee = assignee == null ? null : (GiteaOwner)assignee.clone();
    }

    public GiteaIssueState getState() {
        return this.state;
    }

    public void setState(GiteaIssueState state) {
        this.state = state;
    }

    public long getComments() {
        return this.comments;
    }

    public void setComments(long comments) {
        this.comments = comments;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    @JsonProperty(value="html_url")
    public void setHtmlUrl(String htmlUrl) {
        this.htmlUrl = htmlUrl;
    }

    public String getDiffUrl() {
        return this.diffUrl;
    }

    @JsonProperty(value="diff_url")
    public void setDiffUrl(String diffUrl) {
        this.diffUrl = diffUrl;
    }

    public String getPatchUrl() {
        return this.patchUrl;
    }

    @JsonProperty(value="patch_url")
    public void setPatchUrl(String patchUrl) {
        this.patchUrl = patchUrl;
    }

    public boolean isMergeable() {
        return this.mergeable;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public Date getMergedAt() {
        return this.mergedAt == null ? null : (Date)this.mergedAt.clone();
    }

    @JsonProperty(value="merged_at")
    public void setMergedAt(Date mergedAt) {
        this.mergedAt = mergedAt == null ? null : (Date)mergedAt.clone();
    }

    public String getMergeCommitSha() {
        return this.mergeCommitSha;
    }

    @JsonProperty(value="merge_commit_sha")
    public void setMergeCommitSha(String mergeCommitSha) {
        this.mergeCommitSha = mergeCommitSha;
    }

    public GiteaOwner getMergedBy() {
        return this.mergedBy;
    }

    @JsonProperty(value="merged_by")
    public void setMergedBy(GiteaOwner mergedBy) {
        this.mergedBy = mergedBy;
    }

    public Reference getBase() {
        return this.base;
    }

    public void setBase(Reference base) {
        this.base = base;
    }

    public Reference getHead() {
        return this.head;
    }

    public void setHead(Reference head) {
        this.head = head;
    }

    public String getMergeBase() {
        return this.mergeBase;
    }

    @JsonProperty(value="merge_base")
    public void setMergeBase(String mergeBase) {
        this.mergeBase = mergeBase;
    }

    public Date getCreatedAt() {
        return this.createdAt == null ? null : (Date)this.createdAt.clone();
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt == null ? null : (Date)createdAt.clone();
    }

    public Date getUpdatedAt() {
        return this.updatedAt == null ? null : (Date)this.updatedAt.clone();
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt == null ? null : (Date)updatedAt.clone();
    }

    public String toString() {
        return "GiteaPullRequest{id=" + this.id + ", url='" + this.url + "', number=" + this.number + ", user=" + String.valueOf(this.user) + ", title='" + this.title + "', body='" + this.body + "', labels=" + String.valueOf(this.labels) + ", milestone=" + String.valueOf(this.milestone) + ", assignee=" + String.valueOf(this.assignee) + ", state='" + String.valueOf((Object)this.state) + "', comments=" + this.comments + ", htmlUrl='" + this.htmlUrl + "', diffUrl='" + this.diffUrl + "', patchUrl='" + this.patchUrl + "', mergeable=" + this.mergeable + ", merged=" + this.merged + ", mergedAt=" + String.valueOf(this.mergedAt) + ", mergeCommitSha='" + this.mergeCommitSha + "', mergedBy=" + String.valueOf(this.mergedBy) + ", base=" + String.valueOf(this.base) + ", head=" + String.valueOf(this.head) + ", mergeBase='" + this.mergeBase + "', createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + "}";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Reference
    extends GiteaObject<Reference> {
        private String label;
        private String ref;
        private String sha;
        private long repoId;
        private GiteaRepository repo;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String getSha() {
            return this.sha;
        }

        public void setSha(String sha) {
            this.sha = sha;
        }

        public long getRepoId() {
            return this.repoId;
        }

        @JsonProperty(value="repo_id")
        public void setRepoId(long repoId) {
            this.repoId = repoId;
        }

        public GiteaRepository getRepo() {
            return this.repo == null ? null : (GiteaRepository)this.repo.clone();
        }

        public void setRepo(GiteaRepository repo) {
            this.repo = repo == null ? null : (GiteaRepository)repo.clone();
        }

        public String toString() {
            return "Reference{label='" + this.label + "', ref='" + this.ref + "', sha='" + this.sha + "', repoId=" + this.repoId + ", repo=" + String.valueOf(this.repo) + "}";
        }
    }
}

