/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.client.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugin.gitea.client.api.GiteaIssueState;
import org.jenkinsci.plugin.gitea.client.api.GiteaLabel;
import org.jenkinsci.plugin.gitea.client.api.GiteaMilestone;
import org.jenkinsci.plugin.gitea.client.api.GiteaObject;
import org.jenkinsci.plugin.gitea.client.api.GiteaOwner;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class GiteaIssue
extends GiteaObject<GiteaIssue> {
    private long id;
    private String url;
    private long number;
    private GiteaOwner user;
    private String title;
    private String body;
    private List<GiteaLabel> labels = new ArrayList<GiteaLabel>();
    private GiteaMilestone milestone;
    private GiteaOwner assignee;
    private GiteaIssueState state;
    private long comments;
    private Date createdAt;
    private Date updatedAt;
    private PullSummary pullRequest;

    public GiteaIssue() {
    }

    public GiteaIssue(String url, GiteaOwner user, String title, String body, List<GiteaLabel> labels, GiteaMilestone milestone, GiteaOwner assignee, GiteaIssueState state, long comments) {
        this.url = url;
        this.user = user;
        this.title = title;
        this.body = body;
        this.labels = labels;
        this.milestone = milestone;
        this.assignee = assignee;
        this.state = state;
        this.comments = comments;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public GiteaOwner getUser() {
        return this.user == null ? null : (GiteaOwner)this.user.clone();
    }

    public void setUser(GiteaOwner user) {
        this.user = user == null ? null : (GiteaOwner)user.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List<GiteaLabel> getLabels() {
        return this.labels == null ? new ArrayList<GiteaLabel>() : new ArrayList<GiteaLabel>(this.labels);
    }

    public void setLabels(List<GiteaLabel> labels) {
        this.labels = labels == null ? new ArrayList<GiteaLabel>() : new ArrayList<GiteaLabel>(labels);
    }

    public GiteaMilestone getMilestone() {
        return this.milestone == null ? null : (GiteaMilestone)this.milestone.clone();
    }

    public void setMilestone(GiteaMilestone milestone) {
        this.milestone = milestone == null ? null : (GiteaMilestone)milestone.clone();
    }

    public GiteaOwner getAssignee() {
        return this.assignee == null ? null : (GiteaOwner)this.assignee.clone();
    }

    public void setAssignee(GiteaOwner assignee) {
        this.assignee = assignee == null ? null : (GiteaOwner)assignee.clone();
    }

    public GiteaIssueState getState() {
        return this.state;
    }

    public void setState(GiteaIssueState state) {
        this.state = state;
    }

    public long getComments() {
        return this.comments;
    }

    public void setComments(long comments) {
        this.comments = comments;
    }

    public Date getCreatedAt() {
        return this.createdAt == null ? null : (Date)this.createdAt.clone();
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt == null ? null : (Date)createdAt.clone();
    }

    public Date getUpdatedAt() {
        return this.updatedAt == null ? null : (Date)this.updatedAt.clone();
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt == null ? null : (Date)updatedAt.clone();
    }

    public PullSummary getPullRequest() {
        return this.pullRequest == null ? null : this.pullRequest.clone();
    }

    @JsonProperty(value="pull_request")
    public void setPullRequest(PullSummary pullRequest) {
        this.pullRequest = pullRequest == null ? null : pullRequest.clone();
    }

    public String toString() {
        return "GiteaIssue{id=" + this.id + ", url='" + this.url + "', number=" + this.number + ", user=" + String.valueOf(this.user) + ", title='" + this.title + "', body='" + this.body + "', labels=" + String.valueOf(this.labels) + ", milestone=" + String.valueOf(this.milestone) + ", assignee=" + String.valueOf(this.assignee) + ", state='" + String.valueOf((Object)this.state) + "', comments=" + this.comments + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", pullRequest=" + String.valueOf(this.pullRequest) + "}";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PullSummary
    implements Cloneable {
        private boolean merged;
        private Date mergedAt;

        public boolean isMerged() {
            return this.merged;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public PullSummary clone() {
            try {
                return (PullSummary)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public Date getMergedAt() {
            return this.mergedAt == null ? null : (Date)this.mergedAt.clone();
        }

        @JsonProperty(value="merged_at")
        public void setMergedAt(Date mergedAt) {
            this.mergedAt = mergedAt == null ? null : (Date)mergedAt.clone();
        }

        public String toString() {
            return "PullSummary{merged=" + this.merged + ", mergedAt=" + String.valueOf(this.mergedAt) + "}";
        }
    }
}

