/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea.client.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ServiceLoader;
import jenkins.model.Jenkins;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuthNone;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.spi.GiteaConnectionFactory;

public final class Gitea {
    public static final boolean IGNORE_UNKNOWN_PROPERTIES = true;
    @NonNull
    private final String serverUrl;
    @CheckForNull
    private ClassLoader classLoader;
    @NonNull
    private GiteaAuth authentication = new GiteaAuthNone();

    private Gitea(@NonNull String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @NonNull
    public static Gitea server(@NonNull String serverUrl) {
        return new Gitea(serverUrl).jenkinsPluginClassLoader();
    }

    @NonNull
    public Gitea as(@CheckForNull GiteaAuth authentication) {
        this.authentication = authentication == null ? new GiteaAuthNone() : authentication;
        return this;
    }

    @NonNull
    public String serverUrl() {
        return this.serverUrl;
    }

    @NonNull
    public GiteaAuth as() {
        return this.authentication;
    }

    @CheckForNull
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public Gitea classLoader(@CheckForNull ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @NonNull
    public GiteaConnection open() throws IOException, InterruptedException {
        ServiceLoader<GiteaConnectionFactory> loader = ServiceLoader.load(GiteaConnectionFactory.class, this.classLoader);
        long priority = 0L;
        GiteaConnectionFactory best = null;
        for (GiteaConnectionFactory factory : loader) {
            if (!factory.canOpen(this)) continue;
            long p = factory.priority(this);
            if (best != null && p <= priority) continue;
            best = factory;
            priority = p;
        }
        if (best != null) {
            return best.open(this);
        }
        throw new IOException("No implementation for connecting to " + this.serverUrl);
    }

    public Gitea jenkinsPluginClassLoader() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        this.classLoader = instance == null ? this.getClass().getClassLoader() : instance.getPluginManager().uberClassLoader;
        return this;
    }
}

