/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.WebhookRegistration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class WebhookRegistrationTrait
extends SCMSourceTrait {
    @NonNull
    private final WebhookRegistration mode;

    @DataBoundConstructor
    public WebhookRegistrationTrait(@NonNull String mode) {
        this(WebhookRegistration.valueOf(mode));
    }

    public WebhookRegistrationTrait(@NonNull WebhookRegistration mode) {
        this.mode = mode;
    }

    @NonNull
    public final WebhookRegistration getMode() {
        return this.mode;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        ((GiteaSCMSourceContext)context).webhookRegistration(this.getMode());
    }

    @Extension
    @Symbol(value={"giteaWebhookRegistration"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.WebhookRegistrationTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GiteaSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GiteaSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillModeItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.WebhookRegistrationTrait_disableHook(), WebhookRegistration.DISABLE.toString());
            result.add(Messages.WebhookRegistrationTrait_useItemHook(), WebhookRegistration.ITEM.toString());
            return result;
        }
    }
}

