/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SSHCheckoutTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public SSHCheckoutTrait(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitSCMBuilder)builder).withCredentials(this.credentialsId);
    }

    @Extension
    @Symbol(value={"giteaSSHCheckout"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHCheckoutTrait_displayName();
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GiteaSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GiteaSCMSource.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.add(Messages.SSHCheckoutTrait_useAgentKey(), "");
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class));
            return result;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String value) {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.error((String)Messages.SSHCheckoutTrait_incompatibleCredentials());
            }
            return FormValidation.warning((String)Messages.SSHCheckoutTrait_missingCredentials());
        }
    }
}

