/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.ReleaseSCMHeadCategory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ReleaseDiscoveryTrait
extends SCMSourceTrait {
    private boolean includePreReleases;
    private boolean artifactToAssetMappingEnabled;

    @DataBoundConstructor
    public ReleaseDiscoveryTrait(boolean includePreReleases) {
        this.includePreReleases = includePreReleases;
    }

    public boolean getIncludePreReleases() {
        return this.includePreReleases;
    }

    @DataBoundSetter
    public final void setIncludePreReleases(boolean includePreReleases) {
        this.includePreReleases = includePreReleases;
    }

    public boolean getArtifactToAssetMappingEnabled() {
        return this.artifactToAssetMappingEnabled;
    }

    @DataBoundSetter
    public final void setArtifactToAssetMappingEnabled(boolean artifactToAssetMappingEnabled) {
        this.artifactToAssetMappingEnabled = artifactToAssetMappingEnabled;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GiteaSCMSourceContext ctx = (GiteaSCMSourceContext)context;
        ctx.wantReleases(true);
        ctx.includePreReleases(this.includePreReleases);
        ctx.withArtifactToAssetMappingEnabled(this.artifactToAssetMappingEnabled);
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category instanceof ReleaseSCMHeadCategory;
    }

    @Extension
    @Discovery
    @Symbol(value={"giteaReleaseDiscovery"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.ReleaseDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GiteaSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GiteaSCMSource.class;
        }
    }
}

