/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.damnhandy.uri.template.UriTemplate;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigator;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.WebhookRegistration;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaEventType;
import org.jenkinsci.plugin.gitea.client.api.GiteaHook;
import org.jenkinsci.plugin.gitea.client.api.GiteaHookType;
import org.jenkinsci.plugin.gitea.client.api.GiteaOrganization;
import org.jenkinsci.plugin.gitea.client.api.GiteaPayloadType;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;
import org.jenkinsci.plugin.gitea.client.api.GiteaUser;
import org.jenkinsci.plugin.gitea.servers.GiteaServer;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class GiteaWebhookListener {
    public static final Logger LOGGER = Logger.getLogger(GiteaWebhookListener.class.getName());

    public static void register(SCMNavigatorOwner owner, GiteaSCMNavigator navigator, WebhookRegistration mode, String credentialsId) {
        StandardCredentials credentials;
        String serverUrl = navigator.getServerUrl();
        switch (mode) {
            case SYSTEM: {
                GiteaServer server = GiteaServers.get().findServer(serverUrl);
                if (server == null || !server.isManageHooks()) {
                    return;
                }
                credentials = server.credentials();
                break;
            }
            case ITEM: {
                credentials = navigator.credentials((SCMSourceOwner)owner);
                break;
            }
            default: {
                return;
            }
        }
        if (credentials == null) {
            return;
        }
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String rootUrl = locationConfiguration.getUrl();
        if (StringUtils.isBlank((String)rootUrl) || rootUrl.startsWith("http://localhost:")) {
            LOGGER.log(Level.FINE, "JENKINS_URL is not defined. Cannot register a WebHook.");
            return;
        }
        String hookUrl = UriTemplate.buildFromTemplate((String)rootUrl).literal("gitea-webhook").literal("/post").build().expand();
        try (GiteaConnection c = GiteaWebhookListener.connect(serverUrl, credentials);){
            GiteaUser user = c.fetchUser(navigator.getRepoOwner());
            if (StringUtils.isNotBlank((String)user.getEmail())) {
                return;
            }
            GiteaOrganization org = c.fetchOrganization(navigator.getRepoOwner());
            if (org == null) {
                return;
            }
            List<GiteaHook> hooks = c.fetchHooks(org);
            GiteaHook hook = null;
            for (GiteaHook h : hooks) {
                if (!hookUrl.equals(h.getConfig().getUrl())) continue;
                if (hook == null && h.getType() == GiteaHookType.GITEA && h.getConfig().getContentType() == GiteaPayloadType.JSON && h.isActive() && EnumSet.allOf(GiteaEventType.class).equals(h.getEvents())) {
                    hook = h;
                    continue;
                }
                c.deleteHook(org, h);
            }
            if (hook == null) {
                hook = new GiteaHook();
                GiteaHook.Configuration configuration = new GiteaHook.Configuration();
                configuration.setContentType(GiteaPayloadType.JSON);
                configuration.setUrl(hookUrl);
                hook.setType(GiteaHookType.GITEA);
                hook.setConfig(configuration);
                hook.setEvents(EnumSet.allOf(GiteaEventType.class));
                hook.setActive(true);
                c.createHook(org, hook);
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Could not manage organization hooks for " + navigator.getRepoOwner() + " on " + serverUrl, e);
        }
    }

    private static GiteaConnection connect(String serverUrl, StandardCredentials credentials) throws IOException, InterruptedException {
        return Gitea.server(serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials)).open();
    }

    public static void register(SCMSourceOwner owner, GiteaSCMSource source, WebhookRegistration mode, String credentialsId) {
        StandardCredentials credentials;
        String serverUrl = source.getServerUrl();
        switch (mode) {
            case SYSTEM: {
                GiteaServer server = GiteaServers.get().findServer(serverUrl);
                if (server == null || !server.isManageHooks()) {
                    return;
                }
                credentials = server.credentials();
                break;
            }
            case ITEM: {
                credentials = source.credentials();
                break;
            }
            default: {
                return;
            }
        }
        if (credentials == null) {
            return;
        }
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String rootUrl = locationConfiguration.getUrl();
        if (StringUtils.isBlank((String)rootUrl) || rootUrl.startsWith("http://localhost:")) {
            LOGGER.log(Level.FINE, "JENKINS_URL is not defined. Cannot register a WebHook.");
            return;
        }
        String hookUrl = UriTemplate.buildFromTemplate((String)rootUrl).literal("gitea-webhook").literal("/post").build().expand();
        try (GiteaConnection c = GiteaWebhookListener.connect(serverUrl, credentials);){
            GiteaRepository repo = c.fetchRepository(source.getRepoOwner(), source.getRepository());
            if (repo == null) {
                return;
            }
            List<GiteaHook> hooks = c.fetchHooks(repo);
            GiteaHook hook = null;
            for (GiteaHook h : hooks) {
                if (!hookUrl.equals(h.getConfig().getUrl())) continue;
                if (hook == null && h.getType() == GiteaHookType.GITEA && h.getConfig().getContentType() == GiteaPayloadType.JSON && h.isActive() && EnumSet.allOf(GiteaEventType.class).equals(h.getEvents())) {
                    hook = h;
                    continue;
                }
                c.deleteHook(repo, h);
            }
            if (hook == null) {
                hook = new GiteaHook();
                GiteaHook.Configuration configuration = new GiteaHook.Configuration();
                configuration.setContentType(GiteaPayloadType.JSON);
                configuration.setUrl(hookUrl);
                hook.setType(GiteaHookType.GITEA);
                hook.setConfig(configuration);
                hook.setEvents(EnumSet.allOf(GiteaEventType.class));
                hook.setActive(true);
                c.createHook(repo, hook);
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Could not manage repository hooks for " + source.getRepoOwner() + "/" + source.getRepository() + " on " + serverUrl, e);
        }
    }

    public static void register(SCMTriggerItem item, GitSCM scm) {
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String rootUrl = locationConfiguration.getUrl();
        if (StringUtils.isBlank((String)rootUrl) || rootUrl.startsWith("http://localhost:")) {
            LOGGER.log(Level.FINE, "JENKINS_URL is not defined. Cannot register a WebHook.");
            return;
        }
        if (scm.getExtensions().get(IgnoreNotifyCommit.class) != null) {
            return;
        }
        ArrayList<GiteaServer> serverList = new ArrayList<GiteaServer>(GiteaServers.get().getServers());
        if (serverList.isEmpty()) {
            return;
        }
        HashSet<CallSite> registered = new HashSet<CallSite>();
        String hookUrl = UriTemplate.buildFromTemplate((String)rootUrl).literal("gitea-webhook").literal("/post").build().expand();
        for (RemoteConfig repository : scm.getRepositories()) {
            block11: for (URIish remoteURL : repository.getURIs()) {
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    Object remotePath;
                    URIish serverURL;
                    GiteaServer server = (GiteaServer)((Object)iterator.next());
                    if (!server.isManageHooks()) {
                        iterator.remove();
                        continue;
                    }
                    try {
                        serverURL = new URIish(server.getServerUrl());
                    }
                    catch (URISyntaxException e) {
                        continue;
                    }
                    if (!StringUtils.equals((String)serverURL.getHost(), (String)remoteURL.getHost()) || serverURL.getPort() != -1 && remoteURL.getPort() != -1 && serverURL.getPort() != remoteURL.getPort()) continue;
                    Object serverPath = serverURL.getPath();
                    if (!((String)serverPath).startsWith("/")) {
                        serverPath = "/" + (String)serverPath;
                    }
                    if (!((String)serverPath).endsWith("/")) {
                        serverPath = (String)serverPath + "/";
                    }
                    if (!((String)(remotePath = remoteURL.getPath())).startsWith("/")) {
                        remotePath = "/" + (String)remotePath;
                    }
                    if (!((String)remotePath).startsWith((String)serverPath)) continue;
                    int index = ((String)(remotePath = ((String)remotePath).substring(((String)serverPath).length()))).indexOf(47);
                    if (index == -1) continue block11;
                    String repoOwner = ((String)remotePath).substring(0, index);
                    String repoName = StringUtils.removeEnd((String)((String)remotePath).substring(index + 1), (String)".git");
                    String registeredKey = server.getServerUrl() + "::" + repoOwner + "::" + repoName;
                    if (registered.contains(registeredKey)) continue block11;
                    registered.add((CallSite)((Object)registeredKey));
                    try {
                        GiteaConnection c = GiteaWebhookListener.connect(server.getServerUrl(), server.credentials());
                        try {
                            GiteaRepository repo = c.fetchRepository(repoOwner, repoName);
                            if (repo == null) continue block11;
                            List<GiteaHook> hooks = c.fetchHooks(repo);
                            GiteaHook hook = null;
                            for (GiteaHook h : hooks) {
                                if (!hookUrl.equals(h.getConfig().getUrl())) continue;
                                if (hook == null && h.getType() == GiteaHookType.GITEA && h.getConfig().getContentType() == GiteaPayloadType.JSON && h.isActive() && EnumSet.allOf(GiteaEventType.class).equals(h.getEvents())) {
                                    hook = h;
                                    continue;
                                }
                                c.deleteHook(repo, h);
                            }
                            if (hook != null) continue;
                            hook = new GiteaHook();
                            GiteaHook.Configuration configuration = new GiteaHook.Configuration();
                            configuration.setContentType(GiteaPayloadType.JSON);
                            configuration.setUrl(hookUrl);
                            hook.setType(GiteaHookType.GITEA);
                            hook.setConfig(configuration);
                            hook.setEvents(EnumSet.allOf(GiteaEventType.class));
                            hook.setActive(true);
                            c.createHook(repo, hook);
                        }
                        finally {
                            if (c == null) continue block11;
                            c.close();
                            continue block11;
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Could not manage repository hooks for " + repoOwner + "/" + repoName + " on " + server.getServerUrl(), e);
                    }
                }
                if (!serverList.isEmpty()) continue;
                return;
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static class GitSCMOnSaveNotifier
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (!(o instanceof Item)) {
                return;
            }
            SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)((Item)o));
            if (item == null) {
                return;
            }
            SCMTrigger trigger = item.getSCMTrigger();
            if (trigger == null || trigger.isIgnorePostCommitHooks()) {
                return;
            }
            for (SCM scm : item.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                GiteaWebhookListener.register(item, (GitSCM)scm);
            }
        }
    }
}

