/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.ExtensionPoint;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMEvent;
import org.jenkinsci.plugin.gitea.client.api.GiteaEvent;
import org.jvnet.tiger_types.Types;

public abstract class GiteaWebhookHandler<E extends SCMEvent<P>, P extends GiteaEvent>
implements ExtensionPoint {
    private final String eventName;
    private final Class<E> eventClass;
    private final Class<P> payloadClass;
    private final ObjectMapper mapper = new ObjectMapper();

    protected GiteaWebhookHandler(String eventName, Class<E> eventClass, Class<P> payloadClass) {
        this.eventName = eventName;
        this.eventClass = eventClass;
        this.payloadClass = payloadClass;
    }

    protected GiteaWebhookHandler(String eventName) {
        Class p;
        Class e;
        this.eventName = eventName;
        Type bt = Types.getBaseClass(this.getClass(), GiteaWebhookHandler.class);
        if (bt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)bt;
            e = Types.erasure((Type)pt.getActualTypeArguments()[0]);
            if (!SCMEvent.class.isAssignableFrom(e)) {
                throw new AssertionError((Object)("Could not determine the " + String.valueOf(SCMEvent.class) + " event class generic parameter of " + String.valueOf(this.getClass()) + " best guess was " + String.valueOf(e)));
            }
            p = Types.erasure((Type)pt.getActualTypeArguments()[1]);
            if (!GiteaEvent.class.isAssignableFrom(p)) {
                throw new AssertionError((Object)("Could not determine the " + String.valueOf(GiteaEvent.class) + " payload class generic parameter of " + String.valueOf(this.getClass()) + " best guess was " + String.valueOf(p)));
            }
        } else {
            throw new AssertionError((Object)("Type inferrence failure for subclass " + String.valueOf(this.getClass()) + " of parameterized type " + String.valueOf(GiteaWebhookHandler.class) + ". Use the constructor that takes the Class objects explicitly."));
        }
        this.eventClass = e;
        this.payloadClass = p;
    }

    public GiteaWebhookHandler() {
        Class p;
        Class e;
        Type bt = Types.getBaseClass(this.getClass(), GiteaWebhookHandler.class);
        if (bt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)bt;
            e = Types.erasure((Type)pt.getActualTypeArguments()[0]);
            if (!SCMEvent.class.isAssignableFrom(e)) {
                throw new AssertionError((Object)("Could not determine the " + String.valueOf(SCMEvent.class) + " event class generic parameter of " + String.valueOf(this.getClass()) + " best guess was " + String.valueOf(e)));
            }
            p = Types.erasure((Type)pt.getActualTypeArguments()[1]);
            if (!GiteaEvent.class.isAssignableFrom(p)) {
                throw new AssertionError((Object)("Could not determine the " + String.valueOf(GiteaEvent.class) + " payload class generic parameter of " + String.valueOf(this.getClass()) + " best guess was " + String.valueOf(p)));
            }
        } else {
            throw new AssertionError((Object)("Type inferrence failure for subclass " + String.valueOf(this.getClass()) + " of parameterized type " + String.valueOf(GiteaWebhookHandler.class) + ". Use the constructor that takes the Class objects explicitly."));
        }
        this.eventClass = e;
        this.payloadClass = p;
        Matcher eventNameMatcher = Pattern.compile("^\\QGitea\\E([A-Z][a-z_]*)\\QSCM\\E(Head|Source|Navigator)?\\QEvent\\E$").matcher(this.eventClass.getSimpleName());
        if (!eventNameMatcher.matches()) {
            throw new AssertionError((Object)("Could not infer event name from " + String.valueOf(this.eventClass) + " as it does not follow the convention Gitea[Name]SCMEvent. Use the constructor that specifies the event name explicitly"));
        }
        this.eventName = eventNameMatcher.group(1).toLowerCase(Locale.ENGLISH);
    }

    public final boolean matches(String eventName) {
        return this.eventName.equals(eventName);
    }

    public final void process(InputStream inputStream, String origin) throws IOException {
        this.process(this.createEvent((GiteaEvent)this.payloadClass.cast(this.mapper.readerFor(this.payloadClass).readValue(inputStream)), origin));
    }

    protected abstract E createEvent(P var1, String var2);

    protected abstract void process(E var1);

    public final String getEventName() {
        return this.eventName;
    }

    public final Class<E> getEventClass() {
        return this.eventClass;
    }

    public final Class<P> getPayloadClass() {
        return this.payloadClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{eventName='" + this.eventName + "', eventClass=" + String.valueOf(this.eventClass) + ", payloadClass=" + String.valueOf(this.payloadClass) + "}";
    }
}

