/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class GiteaWebhookAction
extends CrumbExclusion
implements UnprotectedRootAction {
    private final Logger LOGGER = Logger.getLogger(GiteaWebhookAction.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "gitea-webhook";
    }

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/" + this.getUrlName() + "/post")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public HttpResponse doPost(StaplerRequest2 request) throws IOException {
        String origin = SCMEvent.originOf((HttpServletRequest)request);
        if (!request.getMethod().equals("POST")) {
            this.LOGGER.log(Level.FINE, "Received {0} request (expecting POST) from {1}", new Object[]{request.getMethod(), origin});
            return HttpResponses.error((int)400, (String)("Only POST requests are supported, this was a " + request.getMethod() + " request"));
        }
        if (!"application/json".equals(request.getContentType())) {
            this.LOGGER.log(Level.FINE, "Received {0} body (expecting application/json) from {1}", new Object[]{request.getContentType(), origin});
            return HttpResponses.error((int)400, (String)("Only application/json content is supported, this was " + request.getContentType()));
        }
        String type = request.getHeader("X-Gitea-Event");
        if (StringUtils.isBlank((String)type)) {
            this.LOGGER.log(Level.FINE, "Received request without X-Gitea-Event header from {1}", new Object[]{request.getContentType(), origin});
            return HttpResponses.error((int)400, (String)"Expecting a Gitea event, missing expected X-Gitea-Event header");
        }
        this.LOGGER.log(Level.FINER, "Received {0} event from {1}", new Object[]{request.getContentType(), origin});
        boolean processed = false;
        for (GiteaWebhookHandler h : ExtensionList.lookup(GiteaWebhookHandler.class)) {
            if (!h.matches(type)) continue;
            this.LOGGER.log(Level.FINER, "Processing {0} event from {1} with {2}", new Object[]{type, origin, h});
            h.process((InputStream)request.getInputStream(), origin);
            processed = true;
        }
        if (!processed) {
            this.LOGGER.log(Level.INFO, "Received hook payload with unknown type: {0} from {1}", new Object[]{type, origin});
        }
        return HttpResponses.text((String)(processed ? "Processed" : "Ignored"));
    }
}

