/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.TagSCMHead;
import org.jenkinsci.plugin.gitea.client.api.GiteaBranch;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequest;
import org.jenkinsci.plugin.gitea.client.api.GiteaRelease;
import org.jenkinsci.plugin.gitea.client.api.GiteaTag;

public class GiteaSCMSourceRequest
extends SCMSourceRequest {
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchReleases;
    private final boolean includePreReleases;
    private final boolean fetchOriginPRs;
    private final boolean fetchForkPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies;
    @CheckForNull
    private final Set<Long> requestedPullRequestNumbers;
    @CheckForNull
    private final Set<String> requestedOriginBranchNames;
    @CheckForNull
    private final Set<String> requestedTagNames;
    @CheckForNull
    private Iterable<GiteaPullRequest> pullRequests;
    @CheckForNull
    private Iterable<GiteaBranch> branches;
    @CheckForNull
    private Iterable<GiteaTag> tags;
    @CheckForNull
    private Iterable<GiteaRelease> releases;
    @CheckForNull
    private Set<String> collaboratorNames;
    @CheckForNull
    private GiteaConnection connection;

    GiteaSCMSourceRequest(SCMSource source, GiteaSCMSourceContext context, TaskListener listener) {
        super(source, (SCMSourceContext)context, listener);
        this.fetchBranches = context.wantBranches();
        this.fetchTags = context.wantTags();
        this.fetchReleases = context.wantReleases();
        this.includePreReleases = context.includesPreReleases();
        this.fetchOriginPRs = context.wantOriginPRs();
        this.fetchForkPRs = context.wantForkPRs();
        this.originPRStrategies = this.fetchOriginPRs && !context.originPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.originPRStrategies())) : Collections.emptySet();
        this.forkPRStrategies = this.fetchForkPRs && !context.forkPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.forkPRStrategies())) : Collections.emptySet();
        Set includes = context.observer().getIncludes();
        if (includes != null) {
            HashSet<Long> pullRequestNumbers = new HashSet<Long>(includes.size());
            HashSet<String> branchNames = new HashSet<String>(includes.size());
            HashSet<String> tagNames = new HashSet<String>(includes.size());
            for (SCMHead h : includes) {
                if (h instanceof BranchSCMHead) {
                    branchNames.add(h.getName());
                    continue;
                }
                if (h instanceof PullRequestSCMHead) {
                    pullRequestNumbers.add(Long.parseLong(((PullRequestSCMHead)h).getId()));
                    if (!SCMHeadOrigin.DEFAULT.equals((Object)h.getOrigin())) continue;
                    branchNames.add(((PullRequestSCMHead)h).getOriginName());
                    continue;
                }
                if (h instanceof TagSCMHead) {
                    tagNames.add(h.getName());
                    continue;
                }
                if (!(h instanceof ReleaseSCMHead)) continue;
            }
            this.requestedPullRequestNumbers = Collections.unmodifiableSet(pullRequestNumbers);
            this.requestedOriginBranchNames = Collections.unmodifiableSet(branchNames);
            this.requestedTagNames = Collections.unmodifiableSet(tagNames);
        } else {
            this.requestedPullRequestNumbers = null;
            this.requestedOriginBranchNames = null;
            this.requestedTagNames = null;
        }
    }

    public final boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isFetchReleases() {
        return this.fetchReleases;
    }

    public final boolean isIncludingPreReleases() {
        return this.includePreReleases;
    }

    public final boolean isFetchPRs() {
        return this.isFetchOriginPRs() || this.isFetchForkPRs();
    }

    public final boolean isFetchOriginPRs() {
        return this.fetchOriginPRs;
    }

    public final boolean isFetchForkPRs() {
        return this.fetchForkPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getOriginPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getForkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getPRStrategies(boolean fork) {
        if (fork) {
            return this.fetchForkPRs ? this.getForkPRStrategies() : Collections.emptySet();
        }
        return this.fetchOriginPRs ? this.getOriginPRStrategies() : Collections.emptySet();
    }

    public final Map<Boolean, Set<ChangeRequestCheckoutStrategy>> getPRStrategies() {
        HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>> result = new HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>>();
        for (Boolean fork : new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            result.put(fork, this.getPRStrategies(fork));
        }
        return result;
    }

    @CheckForNull
    public final Set<Long> getRequestedPullRequestNumbers() {
        return this.requestedPullRequestNumbers;
    }

    @CheckForNull
    public final Set<String> getRequestedOriginBranchNames() {
        return this.requestedOriginBranchNames;
    }

    @CheckForNull
    public final Set<String> getRequestedTagNames() {
        return this.requestedTagNames;
    }

    @NonNull
    public Iterable<GiteaPullRequest> getPullRequests() {
        return Util.fixNull(this.pullRequests);
    }

    public void setPullRequests(@CheckForNull Iterable<GiteaPullRequest> pullRequests) {
        this.pullRequests = pullRequests;
    }

    @NonNull
    public final Iterable<GiteaBranch> getBranches() {
        return Util.fixNull(this.branches);
    }

    public final void setBranches(@CheckForNull Iterable<GiteaBranch> branches) {
        this.branches = branches;
    }

    @NonNull
    public final Iterable<GiteaTag> getTags() {
        return Util.fixNull(this.tags);
    }

    public final void setTags(@CheckForNull Iterable<GiteaTag> tags) {
        this.tags = tags;
    }

    @NonNull
    public final Iterable<GiteaRelease> getReleases() {
        return Util.fixNull(this.releases);
    }

    public final void setReleases(@CheckForNull Iterable<GiteaRelease> releases) {
        this.releases = releases;
    }

    public final Set<String> getCollaboratorNames() {
        return this.collaboratorNames;
    }

    public final void setCollaboratorNames(@CheckForNull Set<String> collaboratorNames) {
        this.collaboratorNames = collaboratorNames;
    }

    @CheckForNull
    public GiteaConnection getConnection() {
        return this.connection;
    }

    public void setConnection(@CheckForNull GiteaConnection gitHub) {
        this.connection = gitHub;
    }

    public void close() throws IOException {
        Throwable exception = null;
        for (Iterable o : Arrays.asList(this.pullRequests, this.branches, this.tags, this.releases)) {
            if (!(o instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)o)).close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        try {
            super.close();
        }
        catch (IOException e) {
            if (exception == null) {
                throw e;
            }
            exception.addSuppressed(e);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

