/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.EnumSet;
import java.util.Set;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceRequest;
import org.jenkinsci.plugin.gitea.WebhookRegistration;

public class GiteaSCMSourceContext
extends SCMSourceContext<GiteaSCMSourceContext, GiteaSCMSourceRequest> {
    private boolean wantBranches;
    private boolean wantTags;
    private boolean wantReleases;
    private boolean includesPreReleases;
    private boolean wantOriginPRs;
    private boolean wantForkPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    @NonNull
    private WebhookRegistration webhookRegistration = WebhookRegistration.SYSTEM;
    private boolean notificationsDisabled;
    private boolean artifactToAssetMappingEnabled;

    public GiteaSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public final boolean wantBranches() {
        return this.wantBranches;
    }

    public final boolean wantTags() {
        return this.wantTags;
    }

    public final boolean wantReleases() {
        return this.wantReleases;
    }

    public final boolean includesPreReleases() {
        return this.includesPreReleases;
    }

    public final boolean wantPRs() {
        return this.wantOriginPRs || this.wantForkPRs;
    }

    public final boolean wantOriginPRs() {
        return this.wantOriginPRs;
    }

    public final boolean wantForkPRs() {
        return this.wantForkPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> originPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> forkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final WebhookRegistration webhookRegistration() {
        return this.webhookRegistration;
    }

    public final boolean notificationsDisabled() {
        return this.notificationsDisabled;
    }

    @NonNull
    public GiteaSCMSourceContext wantBranches(boolean include) {
        this.wantBranches = this.wantBranches || include;
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext wantTags(boolean include) {
        this.wantTags = this.wantTags || include;
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext wantReleases(boolean include) {
        this.wantReleases = this.wantReleases || include;
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext includePreReleases(boolean include) {
        this.includesPreReleases = this.includesPreReleases || include;
        return this;
    }

    public final boolean artifactToAssetMappingEnabled() {
        return this.artifactToAssetMappingEnabled;
    }

    @NonNull
    public GiteaSCMSourceContext wantOriginPRs(boolean include) {
        this.wantOriginPRs = this.wantOriginPRs || include;
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext wantForkPRs(boolean include) {
        this.wantForkPRs = this.wantForkPRs || include;
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext withOriginPRStrategies(Set<ChangeRequestCheckoutStrategy> strategies) {
        this.originPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public GiteaSCMSourceContext withForkPRStrategies(Set<ChangeRequestCheckoutStrategy> strategies) {
        this.forkPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public final GiteaSCMSourceContext webhookRegistration(WebhookRegistration mode) {
        this.webhookRegistration = mode;
        return this;
    }

    @NonNull
    public final GiteaSCMSourceContext withNotificationsDisabled(boolean disabled) {
        this.notificationsDisabled = disabled;
        return this;
    }

    @NonNull
    public final GiteaSCMSourceContext withArtifactToAssetMappingEnabled(boolean enabled) {
        this.artifactToAssetMappingEnabled = enabled;
        return this;
    }

    @NonNull
    public GiteaSCMSourceRequest newRequest(@NonNull SCMSource source, @CheckForNull TaskListener listener) {
        return new GiteaSCMSourceRequest(source, this, listener);
    }
}

