/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.plugin.gitea.BranchDiscoveryTrait;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.ForkPullRequestDiscoveryTrait;
import org.jenkinsci.plugin.gitea.GiteaAvatar;
import org.jenkinsci.plugin.gitea.GiteaLink;
import org.jenkinsci.plugin.gitea.GiteaSCMBuilder;
import org.jenkinsci.plugin.gitea.GiteaSCMFileSystem;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigatorContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceRequest;
import org.jenkinsci.plugin.gitea.GiteaWebhookListener;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.OriginPullRequestDiscoveryTrait;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.ReleaseSCMHeadCategory;
import org.jenkinsci.plugin.gitea.ReleaseSCMRevision;
import org.jenkinsci.plugin.gitea.TagSCMHead;
import org.jenkinsci.plugin.gitea.TagSCMRevision;
import org.jenkinsci.plugin.gitea.WebhookRegistration;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAnnotatedTag;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaBranch;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitDetail;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaHttpStatusException;
import org.jenkinsci.plugin.gitea.client.api.GiteaIssueState;
import org.jenkinsci.plugin.gitea.client.api.GiteaOwner;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequest;
import org.jenkinsci.plugin.gitea.client.api.GiteaRelease;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;
import org.jenkinsci.plugin.gitea.client.api.GiteaTag;
import org.jenkinsci.plugin.gitea.client.api.GiteaVersion;
import org.jenkinsci.plugin.gitea.servers.GiteaServer;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GiteaSCMSource
extends AbstractGitSCMSource {
    public static final VersionNumber TAG_SUPPORT_MINIMUM_VERSION = new VersionNumber("1.9.0");
    public static final VersionNumber READ_ACCESS_COLLABORATOR_LISTING_SUPPORT_MINIMUM_VERSION = new VersionNumber("1.12.0");
    private static final Logger LOGGER = Logger.getLogger(GiteaSCMSource.class.getName());
    private final String serverUrl;
    private final String repoOwner;
    private final String repository;
    private String credentialsId;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private transient String sshRemote;
    private transient GiteaRepository giteaRepository;

    @DataBoundConstructor
    public GiteaSCMSource(String serverUrl, String repoOwner, String repository) {
        this.serverUrl = serverUrl;
        this.repoOwner = repoOwner;
        this.repository = repository;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getSshRemote() {
        return this.sshRemote;
    }

    public void setSshRemote(String sshRemote) {
        this.sshRemote = sshRemote;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getRemote() {
        return GiteaSCMBuilder.checkoutUriTemplate((Item)this.getOwner(), this.serverUrl, this.getSshRemote(), this.getCredentialsId()).set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).expand();
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (GiteaConnection c = this.gitea().open();){
            listener.getLogger().format("Looking up repository %s/%s%n", this.repoOwner, this.repository);
            this.giteaRepository = c.fetchRepository(this.repoOwner, this.repository);
            this.sshRemote = this.giteaRepository.getSshUrl();
            if (head instanceof BranchSCMHead) {
                listener.getLogger().format("Querying the current revision of branch %s...%n", head.getName());
                String revision = c.fetchBranch(this.repoOwner, this.repository, head.getName()).getCommit().getId();
                listener.getLogger().format("Current revision of branch %s is %s%n", head.getName(), revision);
                BranchSCMRevision branchSCMRevision = new BranchSCMRevision((BranchSCMHead)head, revision);
                return branchSCMRevision;
            }
            if (head instanceof TagSCMHead) {
                listener.getLogger().format("Querying the current revision of tag %s...%n", head.getName());
                List<GiteaTag> tags = c.fetchTags(this.repoOwner, this.repository);
                for (GiteaTag tag : tags) {
                    Date timestamp;
                    String revision;
                    block24: {
                        if (tag.getCommit() == null || tag.getCommit().getSha() == null) continue;
                        if (!head.getName().equals(tag.getName())) continue;
                        revision = tag.getCommit().getSha();
                        timestamp = null;
                        if (!tag.getId().equalsIgnoreCase(tag.getCommit().getSha())) {
                            try {
                                GiteaAnnotatedTag annotatedTag = c.fetchAnnotatedTag(this.repoOwner, this.repository, tag.getId());
                                GiteaAnnotatedTag.Tagger tagger = annotatedTag.getTagger();
                                timestamp = tagger != null ? tagger.getDate() : null;
                            }
                            catch (GiteaHttpStatusException annotatedTag) {
                                // empty catch block
                            }
                        }
                        if (timestamp == null) {
                            try {
                                GiteaCommitDetail detail = c.fetchCommit(this.repoOwner, this.repository, tag.getCommit().getSha());
                                GiteaCommitDetail.GitCommit commit = detail.getCommit();
                                GiteaCommitDetail.GitActor committer = commit != null ? commit.getCommitter() : null;
                                timestamp = committer != null ? committer.getDate() : null;
                            }
                            catch (GiteaHttpStatusException e) {
                                if (e.getStatusCode() == 404) break block24;
                                throw e;
                            }
                        }
                    }
                    listener.getLogger().format("Current revision of tag %s is %s%n", head.getName(), revision);
                    long ts = timestamp == null ? 0L : timestamp.getTime();
                    TagSCMRevision tagSCMRevision = new TagSCMRevision(new TagSCMHead(tag.getName(), ts), revision);
                    return tagSCMRevision;
                }
                listener.getLogger().format("Tag %s does not / no longer exists. Current tags are: %s%n", head.getName(), tags.stream().map(GiteaTag::getName).collect(Collectors.joining(", ")));
                Iterator<GiteaTag> iterator = null;
                return iterator;
            }
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead h = (PullRequestSCMHead)head;
                listener.getLogger().format("Querying the current revision of pull request #%s...%n", h.getId());
                GiteaPullRequest pr = c.fetchPullRequest(this.repoOwner, this.repository, Long.parseLong(h.getId()));
                if (pr.getState() == GiteaIssueState.OPEN) {
                    listener.getLogger().format("Current revision of pull request #%s is %s%n", h.getId(), pr.getHead().getSha());
                    PullRequestSCMRevision tag = new PullRequestSCMRevision(h, new BranchSCMRevision(h.getTarget(), pr.getBase().getSha()), new BranchSCMRevision(new BranchSCMHead(h.getOriginName()), pr.getHead().getSha()));
                    return tag;
                }
                listener.getLogger().format("Pull request #%s is CLOSED%n", h.getId());
                SCMRevision tag = null;
                return tag;
            }
            if (head instanceof ReleaseSCMHead) {
                ReleaseSCMHead h = (ReleaseSCMHead)head;
                GiteaTag tag = c.fetchTag(this.repoOwner, this.repository, h.getName());
                String revision = tag.getCommit().getSha();
                ReleaseSCMRevision releaseSCMRevision = new ReleaseSCMRevision(new ReleaseSCMHead(h.getName(), h.getId()), revision);
                return releaseSCMRevision;
            }
            listener.getLogger().format("Unknown head: %s of type %s%n", head.getName(), head.getClass().getName());
            SCMRevision sCMRevision = null;
            return sCMRevision;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieve(SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        c = this.gitea().open();
        try {
            listener.getLogger().format("Looking up repository %s/%s%n", new Object[]{this.repoOwner, this.repository});
            this.giteaRepository = c.fetchRepository(this.repoOwner, this.repository);
            this.sshRemote = this.giteaRepository.getSshUrl();
            if (this.giteaRepository.isEmpty()) {
                listener.getLogger().format("Repository %s is empty%n", new Object[]{this.repository});
                return;
            }
            request = ((GiteaSCMSourceContext)new GiteaSCMSourceContext(criteria, observer).withTraits(this.getTraits())).newRequest((SCMSource)this, listener);
            try {
                block44: {
                    block45: {
                        request.setConnection(c);
                        if (request.isFetchBranches()) {
                            request.setBranches(c.fetchBranches(this.giteaRepository));
                        }
                        if (request.isFetchPRs()) {
                            if (this.giteaRepository.isMirror()) {
                                listener.getLogger().format("%n  Ignoring pull requests as repository is a mirror...%n", new Object[0]);
                            } else {
                                request.setPullRequests(c.fetchPullRequests(this.giteaRepository, EnumSet.of(GiteaIssueState.OPEN)));
                            }
                        }
                        if (request.isFetchTags()) {
                            version = c.fetchVersion();
                            v = version.getVersionNumber();
                            if (v.isOlderThan(GiteaSCMSource.TAG_SUPPORT_MINIMUM_VERSION)) {
                                listener.getLogger().format("%n  Ignoring tags as Gitea server is version %s and version %s is the minimum version to support tag indexing%n", new Object[]{version.getVersion(), GiteaSCMSource.TAG_SUPPORT_MINIMUM_VERSION.toString()});
                                request.setTags(null);
                            } else {
                                request.setTags(c.fetchTags(this.giteaRepository));
                            }
                        }
                        if (request.isFetchReleases()) {
                            request.setReleases(c.fetchReleases(this.giteaRepository, false, request.isIncludingPreReleases()));
                        }
                        if (request.isFetchBranches()) {
                            count = 0;
                            listener.getLogger().format("%n  Checking branches...%n", new Object[0]);
                            for (GiteaBranch b : request.getBranches()) {
                                ++count;
                                listener.getLogger().format("%n    Checking branch %s%n", new Object[]{HyperlinkNote.encodeTo((String)UriTemplate.buildFromTemplate((String)this.giteaRepository.getHtmlUrl()).literal("/src/branch").path(new String[]{"branch"}).build().set("branch", (Object)b.getName()).expand(), (String)b.getName())});
                                head = new BranchSCMHead(b.getName());
                                if (!request.process(head, (SCMRevision)(revision = new BranchSCMRevision(head, b.getCommit().getId())), (SCMSourceRequest.ProbeLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljava/lang/Object;)Ljenkins/scm/api/SCMSourceCriteria$Probe;, createProbe(jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision ), (Lorg/jenkinsci/plugin/gitea/BranchSCMHead;Lorg/jenkinsci/plugin/gitea/BranchSCMRevision;)Ljenkins/scm/api/SCMSourceCriteria$Probe;)((GiteaSCMSource)this), new SCMSourceRequest.Witness[]{new CriteriaWitness<H, R>(listener)})) continue;
                                listener.getLogger().format("%n  %d branches were processed (query completed)%n", new Object[]{count});
                                return;
                            }
                            listener.getLogger().format("%n  %d branches were processed%n", new Object[]{count});
                        }
                        if (!request.isFetchPRs() || this.giteaRepository.isMirror() || request.getForkPRStrategies().isEmpty() && request.getOriginPRStrategies().isEmpty()) ** GOTO lbl61
                        count = 0;
                        listener.getLogger().format("%n  Checking pull requests...%n", new Object[0]);
                        var8_12 = request.getPullRequests().iterator();
                        while (true) {
                            if (var8_12.hasNext()) {
                                p = (GiteaPullRequest)var8_12.next();
                                if (p == null) continue;
                                ++count;
                            } else {
                                listener.getLogger().format("%n  %d pull requests were processed%n", new Object[]{count});
lbl61:
                                // 2 sources

                                if (!request.isFetchTags()) break block44;
                                count = 0;
                                listener.getLogger().format("%n  Checking tags...%n", new Object[0]);
                                var8_12 = request.getTags().iterator();
                                break block45;
                            }
                            listener.getLogger().format("%n  Checking pull request %s%n", new Object[]{HyperlinkNote.encodeTo((String)UriTemplate.buildFromTemplate((String)this.giteaRepository.getHtmlUrl()).literal("/pulls").path(new String[]{"number"}).build().set("number", (Object)p.getNumber()).expand(), (String)("#" + p.getNumber()))});
                            originOwner = p.getHead().getRepo().getOwner().getUsername();
                            originRepository = p.getHead().getRepo().getName();
                            strategies = request.getPRStrategies(StringUtils.equalsIgnoreCase((String)this.repoOwner, (String)originOwner) == false && StringUtils.equalsIgnoreCase((String)this.repository, (String)originRepository) != false);
                            var13_20 = strategies.iterator();
                            do {
                                if (!var13_20.hasNext()) ** break;
                                strategy = var13_20.next();
                            } while (!request.process(head = new PullRequestSCMHead("PR-" + p.getNumber() + (String)(strategies.size() > 1 ? "-" + strategy.name().toLowerCase(Locale.ENGLISH) : ""), p.getNumber(), new BranchSCMHead(p.getBase().getRef()), strategy, (SCMHeadOrigin)(StringUtils.equalsIgnoreCase((String)originOwner, (String)this.repoOwner) != false && StringUtils.equalsIgnoreCase((String)originRepository, (String)this.repository) != false ? SCMHeadOrigin.DEFAULT : new SCMHeadOrigin.Fork(originOwner + "/" + originRepository)), originOwner, originRepository, p.getHead().getRef()), (SCMRevision)(revision = new PullRequestSCMRevision(head, new BranchSCMRevision(head.getTarget(), p.getBase().getSha()), new BranchSCMRevision(new BranchSCMHead(head.getOriginName()), p.getHead().getSha()))), (SCMSourceRequest.ProbeLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljava/lang/Object;)Ljenkins/scm/api/SCMSourceCriteria$Probe;, createProbe(jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision ), (Lorg/jenkinsci/plugin/gitea/PullRequestSCMHead;Lorg/jenkinsci/plugin/gitea/PullRequestSCMRevision;)Ljenkins/scm/api/SCMSourceCriteria$Probe;)((GiteaSCMSource)this), new SCMSourceRequest.Witness[]{new CriteriaWitness<H, R>(listener)}));
                            break;
                        }
                        listener.getLogger().format("%n  %d pull requests were processed (query completed)%n", new Object[]{count});
                        return;
                    }
                    while (var8_12.hasNext()) {
                        block46: {
                            tag = (GiteaTag)var8_12.next();
                            if (tag.getCommit() == null) continue;
                            ++count;
                            listener.getLogger().format("%n    Checking tag %s%n", new Object[]{HyperlinkNote.encodeTo((String)UriTemplate.buildFromTemplate((String)this.giteaRepository.getHtmlUrl()).literal("/src/tag").path(new String[]{"tag"}).build().set("tag", (Object)tag.getName()).expand(), (String)tag.getName())});
                            timestamp = null;
                            if (!tag.getId().equalsIgnoreCase(tag.getCommit().getSha())) {
                                try {
                                    annotatedTag = c.fetchAnnotatedTag(this.repoOwner, this.repository, tag.getId());
                                    listener.getLogger().format("annotated tag: %s%n", new Object[]{annotatedTag});
                                    tagger = annotatedTag.getTagger();
                                    timestamp = tagger != null ? tagger.getDate() : null;
                                }
                                catch (GiteaHttpStatusException annotatedTag) {
                                    // empty catch block
                                }
                            }
                            if (timestamp == null) {
                                try {
                                    detail = c.fetchCommit(this.repoOwner, this.repository, tag.getCommit().getSha());
                                    commit = detail.getCommit();
                                    committer = commit != null ? commit.getCommitter() : null;
                                    timestamp = committer != null ? committer.getDate() : null;
                                }
                                catch (GiteaHttpStatusException e) {
                                    if (e.getStatusCode() == 404) break block46;
                                    throw e;
                                }
                            }
                        }
                        if (!request.process(head /* !! */  = new TagSCMHead(tag.getName(), timestamp == null ? 0L : timestamp.getTime()), (SCMRevision)(revision /* !! */  = new TagSCMRevision((TagSCMHead)head /* !! */ , tag.getCommit().getSha())), (SCMSourceRequest.ProbeLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljava/lang/Object;)Ljenkins/scm/api/SCMSourceCriteria$Probe;, createProbe(jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision ), (Lorg/jenkinsci/plugin/gitea/TagSCMHead;Lorg/jenkinsci/plugin/gitea/TagSCMRevision;)Ljenkins/scm/api/SCMSourceCriteria$Probe;)((GiteaSCMSource)this), new SCMSourceRequest.Witness[]{new CriteriaWitness<H, R>(listener)})) continue;
                        listener.getLogger().format("%n  %d tags were processed (query completed)%n", new Object[]{count});
                        return;
                    }
                    listener.getLogger().format("%n  %d tags were processed%n", new Object[]{count});
                }
                if (request.isFetchReleases() == false) return;
                count = 0;
                listener.getLogger().format("%n  Checking releases...%n", new Object[0]);
                for (GiteaRelease release : request.getReleases()) {
                    ++count;
                    listener.getLogger().format("%n    Checking release '%s' (tag %s)%n", new Object[]{release.getName(), HyperlinkNote.encodeTo((String)UriTemplate.buildFromTemplate((String)this.giteaRepository.getHtmlUrl()).literal("/src/tag").path(new String[]{"tag"}).build().set("tag", (Object)release.getTagName()).expand(), (String)release.getTagName())});
                    releaseTag = c.fetchTag(this.giteaRepository, release.getTagName());
                    head /* !! */  = new ReleaseSCMHead(release.getTagName(), release.getId());
                    if (!request.process(head /* !! */ , (SCMRevision)(revision /* !! */  = new ReleaseSCMRevision(head /* !! */ , releaseTag.getCommit().getSha())), (SCMSourceRequest.ProbeLambda)LambdaMetafactory.metafactory(null, null, null, (Ljenkins/scm/api/SCMHead;Ljava/lang/Object;)Ljenkins/scm/api/SCMSourceCriteria$Probe;, createProbe(jenkins.scm.api.SCMHead jenkins.scm.api.SCMRevision ), (Lorg/jenkinsci/plugin/gitea/ReleaseSCMHead;Lorg/jenkinsci/plugin/gitea/ReleaseSCMRevision;)Ljenkins/scm/api/SCMSourceCriteria$Probe;)((GiteaSCMSource)this), new SCMSourceRequest.Witness[]{new CriteriaWitness<H, R>(listener)})) continue;
                    listener.getLogger().format("%n  %d releases were processed (query completed)%n", new Object[]{count});
                    return;
                }
                listener.getLogger().format("%n  %d releases were processed%n", new Object[]{count});
                return;
            }
            finally {
                if (request != null) {
                    request.close();
                }
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    @NonNull
    protected List<Action> retrieveActions(SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (this.giteaRepository == null) {
            try (GiteaConnection c = this.gitea().open();){
                listener.getLogger().format("Looking up repository %s/%s%n", this.repoOwner, this.repository);
                this.giteaRepository = c.fetchRepository(this.repoOwner, this.repository);
            }
        }
        ArrayList<Action> result = new ArrayList<Action>();
        result.add((Action)new ObjectMetadataAction(this.giteaRepository.getName(), this.giteaRepository.getDescription(), this.giteaRepository.getWebsite()));
        if (StringUtils.isNotBlank((String)this.giteaRepository.getAvatarUrl())) {
            result.add((Action)new GiteaAvatar(this.giteaRepository.getAvatarUrl()));
        }
        result.add(new GiteaLink("icon-gitea-repo", UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).build().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).expand()));
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (this.giteaRepository == null) {
            try (GiteaConnection c = this.gitea().open();){
                listener.getLogger().format("Looking up repository %s/%s%n", this.repoOwner, this.repository);
                this.giteaRepository = c.fetchRepository(this.repoOwner, this.repository);
            }
        }
        ArrayList<Action> result = new ArrayList<Action>();
        if (head instanceof BranchSCMHead) {
            String branchUrl = UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/src/branch").path(new VarSpec[]{UriTemplateBuilder.var((String)"branch")}).build().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).set("branch", (Object)head.getName()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, branchUrl));
            result.add(new GiteaLink("icon-gitea-branch", branchUrl));
            if (head.getName().equals(this.giteaRepository.getDefaultBranch())) {
                result.add((Action)new PrimaryInstanceMetadataAction());
            }
        } else if (head instanceof TagSCMHead) {
            String tagUrl = UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/src/tag").path(new VarSpec[]{UriTemplateBuilder.var((String)"tag")}).build().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).set("tag", (Object)head.getName()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, tagUrl));
            result.add(new GiteaLink("icon-gitea-branch", tagUrl));
            if (head.getName().equals(this.giteaRepository.getDefaultBranch())) {
                result.add((Action)new PrimaryInstanceMetadataAction());
            }
        } else if (head instanceof PullRequestSCMHead) {
            String pullUrl = UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/pulls").path(new VarSpec[]{UriTemplateBuilder.var((String)"id")}).build().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).set("id", (Object)((PullRequestSCMHead)head).getId()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, pullUrl));
            result.add(new GiteaLink("icon-gitea-branch", pullUrl));
        } else if (head instanceof ReleaseSCMHead) {
            String releaseUrl = UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal("/releases").literal("/tag").path(new VarSpec[]{UriTemplateBuilder.var((String)"name")}).build().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).set("name", (Object)head.getName()).expand();
            result.add((Action)new ObjectMetadataAction(null, null, releaseUrl));
            result.add(new GiteaLink("icon-gitea-logo", releaseUrl));
        }
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return super.retrieveActions(revision, event, listener);
    }

    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (revision instanceof PullRequestSCMRevision) {
            PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
            try (GiteaConnection c = this.gitea().open();){
                try (GiteaSCMSourceRequest request = ((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.getTraits())).newRequest((SCMSource)this, listener);){
                    request.setConnection(c);
                    GiteaVersion giteaVersion = c.fetchVersion();
                    VersionNumber versionNumber = giteaVersion.getVersionNumber();
                    if (!versionNumber.isOlderThan(READ_ACCESS_COLLABORATOR_LISTING_SUPPORT_MINIMUM_VERSION) || this.giteaRepository.getPermissions().isAdmin()) {
                        request.setCollaboratorNames(c.fetchCollaborators(this.giteaRepository).stream().map(GiteaOwner::getUsername).collect(Collectors.toSet()));
                    } else {
                        listener.getLogger().format("%n[Gitea] Ignore collaborator fetching because Gitea server version is %s and it's requires admin privileges. From %s, collaborator fetching requires only read permission to repository.%n", giteaVersion.getVersion(), READ_ACCESS_COLLABORATOR_LISTING_SUPPORT_MINIMUM_VERSION.toString());
                    }
                    if (request.isTrusted(head)) {
                        SCMRevision sCMRevision = revision;
                        return sCMRevision;
                    }
                }
                PullRequestSCMRevision rev = (PullRequestSCMRevision)revision;
                listener.getLogger().format("Loading trusted files from base branch %s at %s rather than %s%n", head.getTarget().getName(), ((AbstractGitSCMSource.SCMRevisionImpl)rev.getTarget()).getHash(), rev.getOrigin().getHash());
                SCMRevision sCMRevision = rev.getTarget();
                return sCMRevision;
            }
        }
        return revision;
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, SCMRevision revision) {
        return ((GiteaSCMBuilder)new GiteaSCMBuilder(this, head, revision).withTraits(this.traits)).build();
    }

    @NonNull
    protected SCMProbe createProbe(final @NonNull SCMHead head, SCMRevision revision) throws IOException {
        try {
            GiteaSCMFileSystem.BuilderImpl builder = (GiteaSCMFileSystem.BuilderImpl)((Object)ExtensionList.lookup(SCMFileSystem.Builder.class).get(GiteaSCMFileSystem.BuilderImpl.class));
            if (builder == null) {
                throw new AssertionError();
            }
            final SCMFileSystem fs = builder.build((SCMSource)this, head, revision);
            return new SCMProbe(){

                @NonNull
                public SCMProbeStat stat(@NonNull String path) throws IOException {
                    try {
                        return SCMProbeStat.fromType((SCMFile.Type)fs.child(path).getType());
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }

                public void close() throws IOException {
                    fs.close();
                }

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    try {
                        return fs.lastModified();
                    }
                    catch (IOException | InterruptedException e) {
                        return 0L;
                    }
                }

                public SCMFile getRoot() {
                    return fs.getRoot();
                }
            };
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void afterSave() {
        WebhookRegistration mode = ((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(((GiteaSCMNavigatorContext)new GiteaSCMNavigatorContext().withTraits(this.traits)).traits())).webhookRegistration();
        GiteaWebhookListener.register(this.getOwner(), this, mode, this.credentialsId);
    }

    public Gitea gitea() throws AbortException {
        GiteaServer server = GiteaServers.get().findServer(this.serverUrl);
        if (server == null) {
            throw new AbortException("Unknown server: " + this.serverUrl);
        }
        StandardCredentials credentials = this.credentials();
        SCMSourceOwner owner = this.getOwner();
        if (owner != null) {
            CredentialsProvider.track((Item)owner, (Credentials)credentials);
        }
        return Gitea.server(this.serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials));
    }

    public StandardCredentials credentials() {
        SCMSourceOwner owner;
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)owner, (Authentication)((owner = this.getOwner()) instanceof Queue.Task ? ((Queue.Task)owner).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)this.serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)this.credentialsId)}));
    }

    private static class CriteriaWitness<H extends SCMHead, R extends SCMRevision>
    implements SCMSourceRequest.Witness<H, R> {
        private final TaskListener listener;

        public CriteriaWitness(TaskListener listener) {
            this.listener = listener;
        }

        public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
            if (isMatch) {
                this.listener.getLogger().format("    Met criteria%n", new Object[0]);
            } else {
                this.listener.getLogger().format("    Does not meet criteria%n", new Object[0]);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return "Gitea";
        }

        public ListBoxModel doFillServerUrlItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    ListBoxModel result = new ListBoxModel();
                    result.add(serverUrl);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ)) {
                ListBoxModel result = new ListBoxModel();
                result.add(serverUrl);
                return result;
            }
            return GiteaServers.get().getServerItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.includeEmptyValue();
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, (Item)context, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(GiteaAuth.class));
            return result;
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String value) throws IOException, InterruptedException {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            GiteaServer server = GiteaServers.get().findServer(serverUrl);
            if (server == null) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build(), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), AuthenticationTokens.matcher(GiteaAuth.class)})).isEmpty()) {
                return FormValidation.error((String)Messages.GiteaSCMSource_selectedCredentialsMissing());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner, @QueryParameter String repository) throws IOException, InterruptedException {
            ListBoxModel listBoxModel;
            block16: {
                ListBoxModel result = new ListBoxModel();
                if (context == null) {
                    if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                        result.add(repository);
                        return result;
                    }
                } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                    result.add(repository);
                    return result;
                }
                if (StringUtils.isBlank((String)repoOwner)) {
                    result.add(repository);
                    return result;
                }
                GiteaServer server = GiteaServers.get().findServer(serverUrl);
                if (server == null) {
                    result.add(repository);
                    return result;
                }
                StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)credentialsId)}));
                GiteaConnection c = Gitea.server(serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials)).open();
                try {
                    GiteaOwner owner = c.fetchOwner(repoOwner);
                    List<GiteaRepository> repositories = c.fetchRepositories(owner);
                    for (GiteaRepository r : repositories) {
                        result.add(r.getName());
                    }
                    listBoxModel = result;
                    if (c == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (c != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Could not populate repositories", e);
                        if (result.isEmpty()) {
                            result.add(repository);
                        }
                        return result;
                    }
                }
                c.close();
            }
            return listBoxModel;
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, GiteaSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)Messages.GiteaSCMSource_traitSection_withinRepo(), (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)Messages.GiteaSCMSource_traitSection_additional(), null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), new ForkPullRequestDiscoveryTrait.TrustContributors())});
        }

        public String getIconClassName() {
            return "icon-gitea-repo";
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._GiteaSCMSource_UncategorizedCategory()), new ChangeRequestSCMHeadCategory(Messages._GiteaSCMSource_ChangeRequestCategory()), new TagSCMHeadCategory(Messages._GiteaSCMSource_TagCategory()), new ReleaseSCMHeadCategory(Messages._GiteaSCMSource_ReleaseCategory())};
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-gitea-org icon-sm", "plugin/gitea/images/16x16/gitea-org.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-org icon-md", "plugin/gitea/images/24x24/gitea-org.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-org icon-lg", "plugin/gitea/images/32x32/gitea-org.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-org icon-xlg", "plugin/gitea/images/48x48/gitea-org.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-logo icon-sm", "plugin/gitea/images/16x16/gitea.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-logo icon-md", "plugin/gitea/images/24x24/gitea.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-logo icon-lg", "plugin/gitea/images/32x32/gitea.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-logo icon-xlg", "plugin/gitea/images/48x48/gitea.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-repo icon-sm", "plugin/gitea/images/16x16/gitea-repo.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-repo icon-md", "plugin/gitea/images/24x24/gitea-repo.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-repo icon-lg", "plugin/gitea/images/32x32/gitea-repo.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-repo icon-xlg", "plugin/gitea/images/48x48/gitea-repo.png", "width: 48px; height: 48px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-branch icon-sm", "plugin/gitea/images/16x16/gitea-branch.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-branch icon-md", "plugin/gitea/images/24x24/gitea-branch.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-branch icon-lg", "plugin/gitea/images/32x32/gitea-branch.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-gitea-branch icon-xlg", "plugin/gitea/images/48x48/gitea-branch.png", "width: 48px; height: 48px;"));
        }
    }
}

