/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaAvatar;
import org.jenkinsci.plugin.gitea.GiteaLink;
import org.jenkinsci.plugin.gitea.GiteaSCMBuilder;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigatorContext;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigatorRequest;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceBuilder;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaWebhookListener;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.WebhookRegistration;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaOrganization;
import org.jenkinsci.plugin.gitea.client.api.GiteaOwner;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;
import org.jenkinsci.plugin.gitea.servers.GiteaServer;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GiteaSCMNavigator
extends SCMNavigator {
    private final String serverUrl;
    private final String repoOwner;
    private String credentialsId;
    private List<SCMTrait<? extends SCMTrait<?>>> traits = new ArrayList();
    private GiteaOwner giteaOwner;

    @DataBoundConstructor
    public GiteaSCMNavigator(String serverUrl, String repoOwner) {
        this.serverUrl = serverUrl;
        this.repoOwner = repoOwner;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(SCMTrait[] traits) {
        this.traits = new ArrayList();
        if (traits != null) {
            for (SCMTrait trait : traits) {
                this.traits.add(trait);
            }
        }
    }

    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
        this.traits = traits != null ? new ArrayList(traits) : new ArrayList();
    }

    @NonNull
    protected String id() {
        return this.serverUrl + "::" + this.repoOwner;
    }

    public void visitSources(final @NonNull SCMSourceObserver observer) throws IOException, InterruptedException {
        GiteaSCMNavigatorContext context = (GiteaSCMNavigatorContext)new GiteaSCMNavigatorContext().withTraits(this.traits);
        try (GiteaSCMNavigatorRequest request = context.newRequest(this, observer);
             GiteaConnection c = this.gitea(observer.getContext()).open();){
            this.giteaOwner = c.fetchOwner(this.repoOwner);
            List<GiteaRepository> repositories = c.fetchRepositories(this.giteaOwner);
            int count = 0;
            observer.getListener().getLogger().format("%n  Checking repositories...%n", new Object[0]);
            HashSet<Long> seen = new HashSet<Long>();
            for (GiteaRepository r : repositories) {
                if (seen.contains(r.getId())) continue;
                seen.add(r.getId());
                if (!StringUtils.equalsIgnoreCase((String)r.getOwner().getUsername(), (String)this.repoOwner)) continue;
                ++count;
                if (r.isEmpty()) {
                    observer.getListener().getLogger().format("%n    Ignoring empty repository %s%n", HyperlinkNote.encodeTo((String)r.getHtmlUrl(), (String)r.getName()));
                    continue;
                }
                if (r.isArchived() && context.isExcludeArchivedRepositories()) {
                    observer.getListener().getLogger().format("%n    Skipping repository %s because it is archived", r.getName());
                    continue;
                }
                observer.getListener().getLogger().format("%n    Checking repository %s%n", HyperlinkNote.encodeTo((String)r.getHtmlUrl(), (String)r.getName()));
                if (!request.process(r.getName(), new SCMNavigatorRequest.SourceLambda(){

                    @NonNull
                    public SCMSource create(@NonNull String projectName) throws IOException, InterruptedException {
                        return ((GiteaSCMSourceBuilder)new GiteaSCMSourceBuilder(GiteaSCMNavigator.this.getId() + "::" + projectName, GiteaSCMNavigator.this.serverUrl, GiteaSCMNavigator.this.credentialsId, GiteaSCMNavigator.this.repoOwner, projectName).withTraits(GiteaSCMNavigator.this.traits)).build();
                    }
                }, null, new SCMNavigatorRequest.Witness[]{new SCMNavigatorRequest.Witness(){

                    public void record(@NonNull String projectName, boolean isMatch) {
                        if (isMatch) {
                            observer.getListener().getLogger().format("      Proposing %s%n", projectName);
                        } else {
                            observer.getListener().getLogger().format("      Ignoring %s%n", projectName);
                        }
                    }
                }})) continue;
                observer.getListener().getLogger().format("%n  %d repositories were processed (query complete)%n", count);
                return;
            }
            observer.getListener().getLogger().format("%n  %d repositories were processed%n", count);
        }
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (this.giteaOwner == null) {
            try (GiteaConnection c = this.gitea((SCMSourceOwner)owner).open();){
                this.giteaOwner = c.fetchUser(this.repoOwner);
                if (StringUtils.isBlank((String)this.giteaOwner.getEmail())) {
                    this.giteaOwner = c.fetchOrganization(this.repoOwner);
                }
            }
        }
        ArrayList<Action> result = new ArrayList<Action>();
        String objectUrl = UriTemplate.buildFromTemplate((String)this.serverUrl).path(new String[]{"owner"}).build().set("owner", (Object)this.repoOwner).expand();
        result.add((Action)new ObjectMetadataAction(Util.fixEmpty((String)this.giteaOwner.getFullName()), null, objectUrl));
        if (StringUtils.isNotBlank((String)this.giteaOwner.getAvatarUrl())) {
            result.add((Action)new GiteaAvatar(this.giteaOwner.getAvatarUrl()));
        }
        result.add(new GiteaLink("icon-gitea-org", objectUrl));
        if (this.giteaOwner instanceof GiteaOrganization) {
            String website = ((GiteaOrganization)this.giteaOwner).getWebsite();
            if (StringUtils.isBlank((String)website)) {
                listener.getLogger().println("Organization website: unspecified");
            } else {
                listener.getLogger().printf("Organization website: %s%n", HyperlinkNote.encodeTo((String)website, (String)StringUtils.defaultIfBlank((String)this.giteaOwner.getFullName(), (String)website)));
            }
        }
        return result;
    }

    public void afterSave(@NonNull SCMNavigatorOwner owner) {
        WebhookRegistration mode = ((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(((GiteaSCMNavigatorContext)new GiteaSCMNavigatorContext().withTraits(this.traits)).traits())).webhookRegistration();
        GiteaWebhookListener.register(owner, this, mode, this.credentialsId);
    }

    private Gitea gitea(SCMSourceOwner owner) throws AbortException {
        GiteaServer server = GiteaServers.get().findServer(this.serverUrl);
        if (server == null) {
            throw new AbortException("Unknown server: " + this.serverUrl);
        }
        StandardCredentials credentials = this.credentials(owner);
        CredentialsProvider.track((Item)owner, (Credentials)credentials);
        return Gitea.server(this.serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, (Credentials)credentials));
    }

    public StandardCredentials credentials(SCMSourceOwner owner) {
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)owner, (Authentication)Jenkins.getAuthentication(), (List)URIRequirementBuilder.fromUri((String)this.serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)this.credentialsId)}));
    }

    @Extension
    @Symbol(value={"gitea"})
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        public String getDisplayName() {
            return Messages.GiteaSCMNavigator_displayName();
        }

        public ListBoxModel doFillServerUrlItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    ListBoxModel result = new ListBoxModel();
                    result.add(serverUrl);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ)) {
                ListBoxModel result = new ListBoxModel();
                result.add(serverUrl);
                return result;
            }
            return GiteaServers.get().getServerItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.includeEmptyValue();
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, (Item)context, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), AuthenticationTokens.matcher(GiteaAuth.class));
            return result;
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String value) throws IOException, InterruptedException {
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            GiteaServer server = GiteaServers.get().findServer(serverUrl);
            if (server == null) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)serverUrl).build(), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), AuthenticationTokens.matcher(GiteaAuth.class)})).isEmpty()) {
                return FormValidation.error((String)Messages.GiteaSCMNavigator_selectedCredentialsMissing());
            }
            return FormValidation.ok();
        }

        @NonNull
        public String getDescription() {
            return Messages.GiteaSCMNavigator_description();
        }

        public String getIconClassName() {
            return "icon-gitea-org";
        }

        public String getPronoun() {
            return Messages.GiteaSCMNavigator_pronoun();
        }

        public SCMNavigator newInstance(String name) {
            GiteaServers s = GiteaServers.get();
            List<Object> servers = s == null ? Collections.emptyList() : s.getServers();
            GiteaSCMNavigator navigator = new GiteaSCMNavigator(servers.isEmpty() ? null : ((GiteaServer)((Object)servers.get(0))).getServerUrl(), name);
            navigator.setTraits(this.getTraitsDefaults());
            return navigator;
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            GiteaSCMSource.DescriptorImpl sourceDescriptor = (GiteaSCMSource.DescriptorImpl)Jenkins.get().getDescriptorByType(GiteaSCMSource.DescriptorImpl.class);
            ArrayList all = new ArrayList();
            all.addAll(SCMNavigatorTrait._for((SCMNavigatorDescriptor)this, GiteaSCMNavigatorContext.class, GiteaSCMSourceBuilder.class));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, GiteaSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)sourceDescriptor, null, GiteaSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)Messages.GiteaSCMNavigator_traitSection_repositories(), (NamedArrayList.Predicate)new NamedArrayList.Predicate<SCMTraitDescriptor<?>>(){

                public boolean test(SCMTraitDescriptor<?> scmTraitDescriptor) {
                    return scmTraitDescriptor instanceof SCMNavigatorTraitDescriptor;
                }
            }, (boolean)true, result);
            NamedArrayList.select(all, (String)Messages.GiteaSCMNavigator_traitSection_withinRepo(), (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)Messages.GiteaSCMNavigator_traitSection_additional(), null, (boolean)true, result);
            return result;
        }

        @NonNull
        public List<SCMTrait<? extends SCMTrait<?>>> getTraitsDefaults() {
            GiteaSCMSource.DescriptorImpl descriptor = (GiteaSCMSource.DescriptorImpl)((Object)ExtensionList.lookup(Descriptor.class).get(GiteaSCMSource.DescriptorImpl.class));
            ArrayList result = new ArrayList();
            if (descriptor != null) {
                result.addAll(descriptor.getTraitsDefaults());
            }
            return result;
        }
    }
}

