/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import java.io.IOException;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaSCMFile;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.ReleaseSCMRevision;
import org.jenkinsci.plugin.gitea.TagSCMHead;
import org.jenkinsci.plugin.gitea.TagSCMRevision;
import org.jenkinsci.plugin.gitea.client.api.Gitea;
import org.jenkinsci.plugin.gitea.client.api.GiteaAuth;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;

public class GiteaSCMFileSystem
extends SCMFileSystem {
    private final GiteaConnection connection;
    private final GiteaRepository repo;
    private final String ref;

    protected GiteaSCMFileSystem(GiteaConnection connection, GiteaRepository repo, String ref, @CheckForNull SCMRevision rev) throws IOException {
        super(rev);
        this.connection = connection;
        this.repo = repo;
        this.ref = rev != null ? (rev.getHead() instanceof PullRequestSCMHead ? ((PullRequestSCMRevision)rev).getOrigin().getHash() : (rev instanceof BranchSCMRevision ? ((BranchSCMRevision)rev).getHash() : (rev instanceof TagSCMRevision ? ((TagSCMRevision)rev).getHash() : (rev instanceof ReleaseSCMRevision ? ((ReleaseSCMRevision)rev).getHash() : ref)))) : ref;
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public long lastModified() throws IOException {
        return 0L;
    }

    @NonNull
    public SCMFile getRoot() {
        return new GiteaSCMFile(this.connection, this.repo, this.ref);
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof GiteaSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return false;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return scmSourceDescriptor instanceof GiteaSCMSource.DescriptorImpl;
        }

        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) {
            return null;
        }

        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            String ref;
            String repository;
            String repoOwner;
            GiteaSCMSource src = (GiteaSCMSource)source;
            if (head instanceof PullRequestSCMHead) {
                repoOwner = src.getRepoOwner();
                repository = src.getRepository();
                ref = head.getName();
            } else if (head instanceof BranchSCMHead) {
                repoOwner = src.getRepoOwner();
                repository = src.getRepository();
                ref = head.getName();
            } else if (head instanceof TagSCMHead) {
                repoOwner = src.getRepoOwner();
                repository = src.getRepository();
                ref = head.getName();
            } else if (head instanceof ReleaseSCMHead) {
                repoOwner = src.getRepoOwner();
                repository = src.getRepository();
                ref = head.getName();
            } else {
                return null;
            }
            SCMSourceOwner owner = source.getOwner();
            String serverUrl = src.getServerUrl();
            String credentialsId = src.getCredentialsId();
            StandardCredentials credentials = null;
            if (!StringUtils.isBlank((String)credentialsId)) {
                Authentication authentication = owner instanceof Queue.Task ? ((Queue.Task)owner).getDefaultAuthentication() : ACL.SYSTEM;
                credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)owner, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(GiteaAuth.class), CredentialsMatchers.withId((String)credentialsId)}));
            }
            if (owner != null) {
                CredentialsProvider.track((Item)owner, credentials);
            }
            GiteaConnection connection = Gitea.server(serverUrl).as((GiteaAuth)AuthenticationTokens.convert(GiteaAuth.class, credentials)).open();
            try {
                return new GiteaSCMFileSystem(connection, connection.fetchRepository(repoOwner, repository), ref, rev);
            }
            catch (IOException | InterruptedException e) {
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    e.addSuppressed(ioe);
                }
                throw e;
            }
        }
    }
}

